/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionResponse;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractResourceServerTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UmaPermissionTicketPushedClaimsTest
extends AbstractResourceServerTest {
    @Test
    public void testEvaluatePermissionsWithPushedClaims() throws Exception {
        ResourceRepresentation resource = this.addResource("Bank Account", "withdraw");
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName("Withdraw Limit Policy");
        StringBuilder code = new StringBuilder();
        code.append("var context = $evaluation.getContext();");
        code.append("var attributes = context.getAttributes();");
        code.append("var withdrawValue = attributes.getValue('my.bank.account.withdraw.value');");
        code.append("if (withdrawValue && withdrawValue.asDouble(0) <= 100) {");
        code.append("   $evaluation.grant();");
        code.append("}");
        policy.setCode(code.toString());
        AuthorizationResource authorization = this.getClient(this.getRealm()).authorization();
        authorization.policies().js().create(policy).close();
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName("Withdraw Permission");
        representation.addScope(new String[]{"withdraw"});
        representation.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(representation).close();
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest permissionRequest = new PermissionRequest(resource.getId(), new String[0]);
        permissionRequest.addScope(new String[]{"withdraw"});
        permissionRequest.setClaim("my.bank.account.withdraw.value", new String[]{"50.5"});
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(permissionRequest);
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        AuthorizationResponse authorizationResponse = authzClient.authorization().authorize(request);
        Assert.assertNotNull((Object)authorizationResponse);
        Assert.assertNotNull((Object)authorizationResponse.getToken());
        AccessToken token = this.toAccessToken(authorizationResponse.getToken());
        Collection permissions = token.getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        Permission permission = (Permission)permissions.iterator().next();
        Map claims = permission.getClaims();
        Assert.assertNotNull((Object)claims);
        Assert.assertThat((Object)((Set)claims.get("my.bank.account.withdraw.value")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"50.5"}));
        permissionRequest.setClaim("my.bank.account.withdraw.value", new String[]{"100.5"});
        response = authzClient.protection("marta", "password").permission().create(permissionRequest);
        request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authorizationResponse = authzClient.authorization().authorize(request);
            Assert.fail((String)"Access should be denied");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

