/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.RegexPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RegexPolicyTest
extends AbstractAuthzTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        ProtocolMapperRepresentation userAttrFooProtocolMapper = new ProtocolMapperRepresentation();
        userAttrFooProtocolMapper.setName("userAttrFoo");
        userAttrFooProtocolMapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        userAttrFooProtocolMapper.setProtocol("openid-connect");
        HashMap<String, String> configFoo = new HashMap<String, String>();
        configFoo.put("access.token.claim", "true");
        configFoo.put("id.token.claim", "true");
        configFoo.put("jsonType.label", "String");
        configFoo.put("user.attribute", "foo");
        configFoo.put("claim.name", "foo");
        userAttrFooProtocolMapper.setConfig(configFoo);
        ProtocolMapperRepresentation userAttrBarProtocolMapper = new ProtocolMapperRepresentation();
        userAttrBarProtocolMapper.setName("userAttrBar");
        userAttrBarProtocolMapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        userAttrBarProtocolMapper.setProtocol("openid-connect");
        HashMap<String, String> configBar = new HashMap<String, String>();
        configBar.put("access.token.claim", "true");
        configBar.put("id.token.claim", "true");
        configBar.put("jsonType.label", "String");
        configBar.put("user.attribute", "bar");
        configBar.put("claim.name", "bar");
        userAttrBarProtocolMapper.setConfig(configBar);
        testRealms.add(RealmBuilder.create().name("authz-test").user(UserBuilder.create().username("marta").password("password").addAttribute("foo", "foo").addAttribute("bar", "barbar")).user(UserBuilder.create().username("taro").password("password").addAttribute("foo", "faa").addAttribute("bar", "bbarbar")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").directAccessGrants().protocolMapper(userAttrFooProtocolMapper, userAttrBarProtocolMapper)).build());
    }

    @Before
    public void configureAuthorization() throws Exception {
        this.createResource("Resource A");
        this.createResource("Resource B");
        this.createRegexPolicy("Regex foo Policy", "foo", "foo");
        this.createRegexPolicy("Regex bar Policy", "bar", "^bar.+$");
        this.createResourcePermission("Resource A Permission", "Resource A", "Regex foo Policy");
        this.createResourcePermission("Resource B Permission", "Resource B", "Regex bar Policy");
    }

    private void createResource(String name) {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourceRepresentation resource = new ResourceRepresentation(name, new String[0]);
        authorization.resources().create(resource).close();
    }

    private void createRegexPolicy(String name, String targetClaim, String pattern) {
        RegexPolicyRepresentation policy = new RegexPolicyRepresentation();
        policy.setName(name);
        policy.setTargetClaim(targetClaim);
        policy.setPattern(pattern);
        this.getClient().authorization().policies().regex().create(policy).close();
    }

    private void createResourcePermission(String name, String resource, String ... policies) {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(name);
        permission.addResource(resource);
        permission.addPolicy(policies);
        this.getClient().authorization().permissions().resource().create(permission).close();
    }

    private ClientResource getClient() {
        return this.getClient(this.getRealm());
    }

    private ClientResource getClient(RealmResource realm) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    private RealmResource getRealm() {
        try {
            return this.getAdminClient().realm("authz-test");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create admin client");
        }
    }

    @Test
    public void testWithExpectedUserAttribute() {
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest("Resource A", new String[0]);
        String ticket = authzClient.protection().permission().create(request).getTicket();
        AuthorizationResponse response = authzClient.authorization("marta", "password").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
        request = new PermissionRequest("Resource B", new String[0]);
        ticket = authzClient.protection().permission().create(request).getTicket();
        response = authzClient.authorization("marta", "password").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
    }

    @Test
    public void testWithoutExpectedUserAttribute() {
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest("Resource A", new String[0]);
        String ticket = authzClient.protection().permission().create(request).getTicket();
        try {
            authzClient.authorization("taro", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail.");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        request = new PermissionRequest("Resource B", new String[0]);
        ticket = authzClient.protection().permission().create(request).getTicket();
        try {
            authzClient.authorization("taro", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail.");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
    }

    private AuthzClient getAuthzClient() {
        return AuthzClient.create((InputStream)this.getClass().getResourceAsStream("/authorization-test/default-keycloak.json"));
    }
}

