/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.ClientScopePolicyRepresentation;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientScopeBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClientScopePolicyTest
extends AbstractAuthzTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("authz-test").user(UserBuilder.create().username("marta").password("password")).clientScope(ClientScopeBuilder.create().name("foo").protocol("openid-connect")).clientScope(ClientScopeBuilder.create().name("bar").protocol("openid-connect")).clientScope(ClientScopeBuilder.create().name("baz").protocol("openid-connect")).clientScope(ClientScopeBuilder.create().name("to-remove-a").protocol("openid-connect")).clientScope(ClientScopeBuilder.create().name("to-remove-b").protocol("openid-connect")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").addOptionalClientScopes("foo", "bar", "baz").directAccessGrants()).build());
    }

    @Before
    public void configureAuthorization() throws Exception {
        this.createResource("Resource A");
        this.createResource("Resource B");
        this.createClientScopePolicy("Client Scope foo Policy", "foo", "bar");
        this.createClientScopePolicyAndLastOneRequired("Client Scope bar Policy", "foo", "bar");
        this.createResourcePermission("Resource A Permission", "Resource A", "Client Scope foo Policy");
        this.createResourcePermission("Resource B Permission", "Resource B", "Client Scope bar Policy");
    }

    private void createResource(String name) {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourceRepresentation resource = new ResourceRepresentation(name, new String[0]);
        authorization.resources().create(resource).close();
    }

    private void createClientScopePolicy(String name, String ... clientScopes) {
        ClientScopePolicyRepresentation policy = new ClientScopePolicyRepresentation();
        policy.setName(name);
        for (String clientScope : clientScopes) {
            policy.addClientScope(clientScope);
        }
        this.getClient().authorization().policies().clientScope().create(policy).close();
    }

    private void createClientScopePolicyAndLastOneRequired(String name, String ... clientScopes) {
        ClientScopePolicyRepresentation policy = new ClientScopePolicyRepresentation();
        policy.setName(name);
        for (int i = 0; i < clientScopes.length - 1; ++i) {
            policy.addClientScope(clientScopes[i]);
        }
        policy.addClientScope(clientScopes[clientScopes.length - 1], true);
        this.getClient().authorization().policies().clientScope().create(policy).close();
    }

    private void createResourcePermission(String name, String resource, String ... policies) {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(name);
        permission.addResource(resource);
        permission.addPolicy(policies);
        this.getClient().authorization().permissions().resource().create(permission).close();
    }

    private ClientResource getClient() {
        return this.getClient(this.getRealm());
    }

    private ClientResource getClient(RealmResource realm) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    private RealmResource getRealm() {
        try {
            return this.getAdminClient().realm("authz-test");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create admin client");
        }
    }

    @Test
    public void testWithExpectedClientScope() {
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest("Resource A", new String[0]);
        String ticket = authzClient.protection().permission().create(request).getTicket();
        AuthorizationResponse response = authzClient.authorization("marta", "password", "foo").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
        request = new PermissionRequest("Resource A", new String[0]);
        ticket = authzClient.protection().permission().create(request).getTicket();
        response = authzClient.authorization("marta", "password", "bar").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
        request = new PermissionRequest("Resource B", new String[0]);
        ticket = authzClient.protection().permission().create(request).getTicket();
        response = authzClient.authorization("marta", "password", "bar").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
    }

    @Test
    public void testWithoutExpectedClientScope() {
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest("Resource A", new String[0]);
        String ticket = authzClient.protection().permission().create(request).getTicket();
        try {
            authzClient.authorization("marta", "password", "baz").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail.");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        request = new PermissionRequest("Resource B", new String[0]);
        ticket = authzClient.protection().permission().create(request).getTicket();
        try {
            authzClient.authorization("marta", "password", "foo").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail.");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testRemovePolicyWhenRemovingScope() {
        this.createClientScopePolicy("Client Scope To Remove Policy", "to-remove-a", "to-remove-b");
        ClientScopesResource clientScopes = this.getRealm().clientScopes();
        ClientScopeRepresentation scopeRep = clientScopes.findAll().stream().filter(r -> r.getName().equals("to-remove-a")).findAny().get();
        this.getClient().removeDefaultClientScope(scopeRep.getId());
        this.getRealm().clientScopes().get(scopeRep.getId()).remove();
        ClientScopePolicyRepresentation policyRep = this.getClient().authorization().policies().clientScope().findByName("Client Scope To Remove Policy");
        String id = scopeRep.getId();
        Assert.assertFalse((boolean)policyRep.getClientScopes().stream().anyMatch(def -> def.getId().equals(id)));
        scopeRep = clientScopes.findAll().stream().filter(r -> r.getName().equals("to-remove-b")).findAny().get();
        this.getClient().removeDefaultClientScope(scopeRep.getId());
        this.getRealm().clientScopes().get(scopeRep.getId()).remove();
        Assert.assertNull((Object)this.getClient().authorization().policies().clientScope().findByName("Client Scope To Remove Policy"));
    }

    private AuthzClient getAuthzClient() {
        return AuthzClient.create((InputStream)this.getClass().getResourceAsStream("/authorization-test/default-keycloak.json"));
    }
}

