/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionResponse;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AuthzClientCredentialsTest
extends AbstractAuthzTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(this.configureRealm(RealmBuilder.create().name("authz-client-jwt-test"), ClientBuilder.create().attribute("jwt.credential.certificate", "MIICnTCCAYUCBgFPPLDaTzANBgkqhkiG9w0BAQsFADASMRAwDgYDVQQDDAdjbGllbnQxMB4XDTE1MDgxNzE3MjI0N1oXDTI1MDgxNzE3MjQyN1owEjEQMA4GA1UEAwwHY2xpZW50MTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIUjjgv+V3s96O+Za9002Lp/trtGuHBeaeVL9dFKMKzO2MPqdRmHB4PqNlDdd28Rwf5Xn6iWdFpyUKOnI/yXDLhdcuFpR0sMNK/C9Lt+hSpPFLuzDqgtPgDotlMxiHIWDOZ7g9/gPYNXbNvjv8nSiyqoguoCQiiafW90bPHsiVLdP7ZIUwCcfi1qQm7FhxRJ1NiW5dvUkuCnnWEf0XR+Wzc5eC9EgB0taLFiPsSEIlWMm5xlahYyXkPdNOqZjiRnrTWm5Y4uk8ZcsD/KbPTf/7t7cQXipVaswgjdYi1kK2/zRwOhg1QwWFX/qmvdd+fLxV0R6VqRDhn7Qep2cxwMxLsCAwEAATANBgkqhkiG9w0BAQsFAAOCAQEAKE6OA46sf20bz8LZPoiNsqRwBUDkaMGXfnob7s/hJZIIwDEx0IAQ3uKsG7q9wb+aA6s+v7S340zb2k3IxuhFaHaZpAd4CyR5cn1FHylbzoZ7rI/3ASqHDqpljdJaFqPH+m7nZWtyDvtZf+gkZ8OjsndwsSBK1d/jMZPp29qYbl1+XfO7RCp/jDqro/R3saYFaIFiEZPeKn1hUJn6BO48vxH1xspSu9FmlvDOEAOz4AuM58z4zRMP49GcFdCWr1wkonJUHaSptJaQwmBwLFUkCbE5I1ixGMb7mjEud6Y5jhfzJiZMo2U8RfcjNbrN0diZl3jB6LQIwESnhYSghaTjNQ==").authenticatorType("client-jwt")).build());
        testRealms.add(this.configureRealm(RealmBuilder.create().name("authz-test"), ClientBuilder.create().secret("secret")).build());
        testRealms.add(this.configureRealm(RealmBuilder.create().name("authz-test-session").accessTokenLifespan(1), ClientBuilder.create().secret("secret")).build());
        testRealms.add(this.configureRealm(RealmBuilder.create().name("authz-test-no-rt").accessTokenLifespan(1), ClientBuilder.create().secret("secret").attribute("client_credentials.use_refresh_token", "false")).build());
    }

    @Override
    @Before
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.testContext.getTestRealmReps().forEach(realmRepresentation -> {
            Keycloak adminClient = this.getAdminClient();
            ClientsResource clients = adminClient.realm(realmRepresentation.getRealm()).clients();
            ClientRepresentation client = (ClientRepresentation)clients.findByClientId("resource-server-test").get(0);
            client.setAuthorizationServicesEnabled(Boolean.valueOf(false));
            clients.get(client.getId()).update(client);
            client.setAuthorizationServicesEnabled(Boolean.valueOf(true));
            clients.get(client.getId()).update(client);
            AuthorizationResource authorization = clients.get(client.getId()).authorization();
            ResourceServerRepresentation settings = authorization.getSettings();
            settings.setAllowRemoteResourceManagement(true);
            authorization.update(settings);
        });
    }

    @Test
    public void testSuccessfulJWTAuthentication() {
        this.assertAccessProtectionAPI(this.getAuthzClient("keycloak-with-jwt-authentication.json").protection());
    }

    @Test
    public void testSuccessfulAuthorizationRequest() throws Exception {
        AuthzClient authzClient = this.getAuthzClient("keycloak-with-jwt-authentication.json");
        ProtectionResource protection = authzClient.protection();
        PermissionRequest request = new PermissionRequest("Default Resource", new String[0]);
        PermissionResponse ticketResponse = protection.permission().create(request);
        String ticket = ticketResponse.getTicket();
        AuthorizationResponse authorizationResponse = authzClient.authorization("marta", "password").authorize(new AuthorizationRequest(ticket));
        String rpt = authorizationResponse.getToken();
        Assert.assertNotNull((Object)rpt);
        AccessToken accessToken = (AccessToken)new JWSInput(rpt).readJsonContent(AccessToken.class);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        ArrayList permissions = new ArrayList(authorization.getPermissions());
        Assert.assertFalse((boolean)permissions.isEmpty());
        Assert.assertEquals((Object)"Default Resource", (Object)((Permission)permissions.get(0)).getResourceName());
    }

    @Test
    public void failJWTAuthentication() {
        try {
            this.getAuthzClient("keycloak-with-invalid-keys-jwt-authentication.json").protection().resource().findAll();
            Assert.fail((String)"Should fail due to invalid signature");
        }
        catch (Exception cause) {
            Assert.assertTrue((boolean)HttpResponseException.class.isInstance(cause.getCause().getCause()));
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(cause.getCause().getCause())).getStatusCode());
        }
    }

    @Test
    public void testSuccessfulClientSecret() {
        ProtectionResource protection = this.getAuthzClient("default-keycloak.json").protection();
        this.assertAccessProtectionAPI(protection);
    }

    @Test
    public void testReusingAccessAndRefreshTokens_refreshDisabled() throws Exception {
        this.testReusingAccessAndRefreshTokens(0);
    }

    @Test
    public void testReusingAccessAndRefreshTokens_refreshEnabled() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.getAdminClient().realm("authz-test-session"), (String)"resource-server-test");
        ClientRepresentation clientRepresentation = ClientBuilder.edit(client.toRepresentation()).attribute("client_credentials.use_refresh_token", "true").build();
        client.update(clientRepresentation);
        this.testReusingAccessAndRefreshTokens(1);
        clientRepresentation.getAttributes().put("client_credentials.use_refresh_token", "false");
        client.update(clientRepresentation);
    }

    private void testReusingAccessAndRefreshTokens(int expectedUserSessionsCount) throws Exception {
        ClientsResource clients = this.getAdminClient().realm("authz-test-session").clients();
        ClientRepresentation clientRepresentation = (ClientRepresentation)clients.findByClientId("resource-server-test").get(0);
        List userSessions = clients.get(clientRepresentation.getId()).getUserSessions(Integer.valueOf(-1), Integer.valueOf(-1));
        Assert.assertEquals((long)0L, (long)userSessions.size());
        AuthzClient authzClient = this.getAuthzClient("default-session-keycloak.json");
        ProtectionResource protection = authzClient.protection();
        protection.resource().findByName("Default Resource");
        userSessions = clients.get(clientRepresentation.getId()).getUserSessions(null, null);
        Assert.assertEquals((long)expectedUserSessionsCount, (long)userSessions.size());
        Thread.sleep(2000L);
        protection = authzClient.protection();
        protection.resource().findByName("Default Resource");
        userSessions = clients.get(clientRepresentation.getId()).getUserSessions(null, null);
        Assert.assertEquals((long)expectedUserSessionsCount, (long)userSessions.size());
    }

    @Test
    public void testPermissionWhenResourceServerIsCurrentUser() throws Exception {
        ClientsResource clients = this.getAdminClient().realm("authz-test-session").clients();
        ClientRepresentation clientRepresentation = (ClientRepresentation)clients.findByClientId("resource-server-test").get(0);
        List userSessions = clients.get(clientRepresentation.getId()).getUserSessions(Integer.valueOf(-1), Integer.valueOf(-1));
        Assert.assertEquals((long)0L, (long)userSessions.size());
        AuthzClient authzClient = this.getAuthzClient("default-session-keycloak.json");
        org.keycloak.authorization.client.resource.AuthorizationResource authorization = authzClient.authorization(authzClient.obtainAccessToken().getToken());
        AuthorizationResponse response = authorization.authorize();
        AccessToken accessToken = this.toAccessToken(response.getToken());
        Assert.assertEquals((long)1L, (long)accessToken.getAuthorization().getPermissions().size());
        Assert.assertEquals((Object)"Default Resource", (Object)((Permission)accessToken.getAuthorization().getPermissions().iterator().next()).getResourceName());
    }

    @Test
    public void testSingleSessionPerUser() throws Exception {
        ClientsResource clients = this.getAdminClient().realm("authz-test-session").clients();
        ClientRepresentation clientRepresentation = (ClientRepresentation)clients.findByClientId("resource-server-test").get(0);
        List userSessions = clients.get(clientRepresentation.getId()).getUserSessions(Integer.valueOf(-1), Integer.valueOf(-1));
        Assert.assertEquals((long)0L, (long)userSessions.size());
        AuthzClient authzClient = this.getAuthzClient("default-session-keycloak.json");
        org.keycloak.authorization.client.resource.AuthorizationResource authorization = authzClient.authorization("marta", "password");
        AuthorizationResponse response = authorization.authorize();
        AccessToken accessToken = this.toAccessToken(response.getToken());
        String sessionState = accessToken.getSessionState();
        Assert.assertEquals((long)1L, (long)accessToken.getAuthorization().getPermissions().size());
        Assert.assertEquals((Object)"Default Resource", (Object)((Permission)accessToken.getAuthorization().getPermissions().iterator().next()).getResourceName());
        userSessions = clients.get(clientRepresentation.getId()).getUserSessions(null, null);
        Assert.assertEquals((long)1L, (long)userSessions.size());
        for (int i = 0; i < 3; ++i) {
            response = authorization.authorize();
            accessToken = this.toAccessToken(response.getToken());
            Assert.assertEquals((Object)sessionState, (Object)accessToken.getSessionState());
            Thread.sleep(1000L);
        }
        userSessions = clients.get(clientRepresentation.getId()).getUserSessions(null, null);
        Assert.assertEquals((long)1L, (long)userSessions.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRefreshToken() throws Exception {
        ClientsResource clients = this.getAdminClient().realm("authz-test-no-rt").clients();
        AuthzClient authzClient = this.getAuthzClient("default-session-keycloak-no-rt.json");
        org.keycloak.authorization.client.resource.AuthorizationResource authorization = authzClient.authorization();
        AuthorizationResponse response = authorization.authorize();
        AccessToken accessToken = this.toAccessToken(response.getToken());
        Assert.assertEquals((long)1L, (long)accessToken.getAuthorization().getPermissions().size());
        Assert.assertEquals((Object)"Default Resource", (Object)((Permission)accessToken.getAuthorization().getPermissions().iterator().next()).getResourceName());
        ProtectionResource protection = authzClient.protection();
        Assert.assertEquals((long)1L, (long)protection.resource().findAll().length);
        try {
            Time.setOffset((int)1000);
            Assert.assertEquals((long)1L, (long)protection.resource().findAll().length);
        }
        finally {
            Time.setOffset((int)0);
        }
    }

    @Test
    public void testFindByName() {
        AuthzClient authzClient = this.getAuthzClient("default-session-keycloak.json");
        ProtectionResource protection = authzClient.protection();
        protection.resource().create(new ResourceRepresentation("Admin Resources", new String[0]));
        protection.resource().create(new ResourceRepresentation("Resource", new String[0]));
        ResourceRepresentation resource = authzClient.protection().resource().findByName("Resource");
        Assert.assertEquals((Object)"Resource", (Object)resource.getName());
        ResourceRepresentation adminResource = authzClient.protection().resource().findByName("Admin Resources");
        Assert.assertEquals((Object)"Admin Resources", (Object)adminResource.getName());
        Assert.assertNotEquals((Object)resource.getId(), (Object)adminResource.getId());
    }

    private RealmBuilder configureRealm(RealmBuilder builder, ClientBuilder clientBuilder) {
        return builder.roles(RolesBuilder.create().realmRole(new RoleRepresentation("uma_authorization", "", false))).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization")).user(UserBuilder.create().username("kolo").password("password")).client(clientBuilder.clientId("resource-server-test").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants());
    }

    private void assertAccessProtectionAPI(ProtectionResource protection) {
        ResourceRepresentation expected = new ResourceRepresentation("Resource A", Collections.emptySet());
        String id = protection.resource().create(expected).getId();
        ResourceRepresentation actual = protection.resource().findById(id);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)id, (Object)actual.getId());
    }

    private AuthzClient getAuthzClient(String adapterConfig) {
        final KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getConfigurationStream(adapterConfig));
        return AuthzClient.create((Configuration)new Configuration(deployment.getAuthServerBaseUrl(), deployment.getRealm(), deployment.getResourceName(), deployment.getResourceCredentials(), deployment.getClient()), (ClientAuthenticator)new ClientAuthenticator(){

            public void configureClientCredentials(Map<String, List<String>> requestParams, Map<String, String> requestHeaders) {
                HashMap formparams = new HashMap();
                ClientCredentialsProviderUtils.setClientCredentials((KeycloakDeployment)deployment, requestHeaders, formparams);
                for (Map.Entry param : formparams.entrySet()) {
                    requestParams.put((String)param.getKey(), Arrays.asList((String)param.getValue()));
                }
            }
        });
    }

    private InputStream getConfigurationStream(String adapterConfig) {
        return this.getClass().getResourceAsStream("/authorization-test/" + adapterConfig);
    }
}

