/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public abstract class AbstractResourceServerTest
extends AbstractAuthzTest {
    protected static final String REALM_NAME = "authz-test";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name(REALM_NAME).roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build()).realmRole(RoleBuilder.create().name("uma_protection").build())).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization", "uma_protection").role("resource-server-test", "uma_protection")).user(UserBuilder.create().username("alice").password("password").addRoles("uma_authorization", "uma_protection").role("resource-server-test", "uma_protection")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants().serviceAccountsEnabled(true)).client(ClientBuilder.create().clientId("test-app").redirectUris("http://localhost:8180/auth/realms/master/app/auth", "https://localhost:8543/auth/realms/master/app/auth").publicClient()).testEventListener().build());
    }

    protected AuthorizationResponse authorize(String resourceName, String[] scopeNames, String claimToken) {
        return this.authorize(null, null, resourceName, scopeNames, null, null, claimToken);
    }

    protected AuthorizationResponse authorize(String resourceName, String[] scopeNames, String claimToken, String tokenFormat) {
        return this.authorize(null, null, null, null, null, claimToken, tokenFormat, new PermissionRequest(resourceName, scopeNames));
    }

    protected AuthorizationResponse authorize(String resourceName, String[] scopeNames) {
        return this.authorize(null, null, resourceName, scopeNames, null, null, null);
    }

    protected AuthorizationResponse authorize(String userName, String password, String resourceName, String[] scopeNames) {
        return this.authorize(userName, password, resourceName, scopeNames, null, null, null);
    }

    protected AuthorizationResponse authorize(String userName, String password, PermissionRequest ... permissions) {
        return this.authorize(userName, password, (String[])null, (String)null, (String)null, (String)null, (String)null, permissions);
    }

    protected AuthorizationResponse authorize(String userName, String password, String resourceName, String[] scopeNames, String rpt) {
        return this.authorize(userName, password, resourceName, scopeNames, null, rpt, null);
    }

    protected AuthorizationResponse authorize(String userName, String password, String resourceName, String[] scopeNames, String[] additionalScopes) {
        return this.authorize(userName, password, resourceName, scopeNames, additionalScopes, null, null);
    }

    protected AuthorizationResponse authorize(String userName, String password, String resourceName, String[] scopeNames, String[] additionalScopes, String rpt, String claimToken) {
        return this.authorize(userName, password, additionalScopes, rpt, null, claimToken, null, new PermissionRequest(resourceName, scopeNames));
    }

    protected AuthorizationResponse authorize(String userName, String password, String[] additionalScopes, String rpt, String accessToken, String claimToken, String tokenFormat, PermissionRequest ... permissions) {
        ProtectionResource protection = userName != null ? this.getAuthzClient().protection(userName, password) : this.getAuthzClient().protection();
        String ticket = protection.permission().create(Arrays.asList(permissions)).getTicket();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(ticket);
        if (additionalScopes != null) {
            StringBuilder builder = new StringBuilder();
            for (String scope : additionalScopes) {
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append(scope);
            }
            authorizationRequest.setScope(builder.toString());
        }
        authorizationRequest.setRpt(rpt);
        authorizationRequest.setClaimTokenFormat(tokenFormat);
        authorizationRequest.setClaimToken(claimToken);
        org.keycloak.authorization.client.resource.AuthorizationResource authorization = userName != null ? this.getAuthzClient().authorization(userName, password) : (accessToken != null ? this.getAuthzClient().authorization(accessToken) : this.getAuthzClient().authorization());
        return authorization.authorize(authorizationRequest);
    }

    protected RealmResource getRealm() {
        return this.adminClient.realm(REALM_NAME);
    }

    protected ClientResource getClient(RealmResource realm) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    protected AuthzClient getAuthzClient() {
        try {
            return AuthzClient.create((InputStream)AbstractResourceServerTest.httpsAwareConfigurationStream(this.getClass().getResourceAsStream("/authorization-test/default-keycloak-uma2.json")));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to create authz client", cause);
        }
    }

    protected void assertPermissions(Collection<Permission> permissions, String expectedResource, String ... expectedScopes) {
        Iterator<Permission> iterator = permissions.iterator();
        while (iterator.hasNext()) {
            Permission permission = iterator.next();
            if (!permission.getResourceName().equalsIgnoreCase(expectedResource) && !permission.getResourceId().equals(expectedResource)) continue;
            Set scopes = permission.getScopes();
            Assert.assertEquals((long)expectedScopes.length, (long)scopes.size());
            if (!scopes.containsAll(Arrays.asList(expectedScopes))) continue;
            iterator.remove();
        }
    }

    protected ResourceRepresentation addResource(String resourceName, String ... scopeNames) throws Exception {
        return this.addResource(resourceName, null, false, scopeNames);
    }

    protected ResourceRepresentation addResource(String resourceName, boolean ownerManagedAccess, String ... scopeNames) throws Exception {
        return this.addResource(resourceName, null, ownerManagedAccess, scopeNames);
    }

    protected ResourceRepresentation addResource(String resourceName, String owner, boolean ownerManagedAccess, String ... scopeNames) throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceRepresentation resource = new ResourceRepresentation(resourceName, new String[0]);
        if (owner != null) {
            resource.setOwner(new ResourceOwnerRepresentation(owner));
        }
        resource.setOwnerManagedAccess(Boolean.valueOf(ownerManagedAccess));
        resource.addScope(scopeNames);
        Response response = authorization.resources().create(resource);
        ResourceRepresentation temp = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        resource.setId(temp.getId());
        response.close();
        return resource;
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }
}

