/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.userprofile;

import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserProfileResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.userprofile.config.UPConfigUtils;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserProfileAdminTest
extends AbstractAdminTest {
    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        if (testRealm.getAttributes() == null) {
            testRealm.setAttributes(new HashMap());
        }
        testRealm.getAttributes().put("userProfileEnabled", Boolean.TRUE.toString());
    }

    @Test
    public void testDefaultConfigIfNoneSet() {
        Assert.assertEquals((Object)UPConfigUtils.readDefaultConfig(), (Object)this.testRealm().users().userProfile().getConfiguration());
    }

    @Test
    public void testSetDefaultConfig() throws IOException {
        String rawConfig = "{\"attributes\": [{\"name\": \"test\"}]}";
        UserProfileResource userProfile = this.testRealm().users().userProfile();
        userProfile.update(rawConfig);
        Assert.assertEquals((Object)rawConfig, (Object)userProfile.getConfiguration());
    }
}

