/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.realm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.runonserver.RunHelpers;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.utils.tls.TLSUtils;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RealmTest
extends AbstractAdminTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    public void beforeAbstractKeycloakTestRealmImport() {
        if (this.testContext.isInitialized()) {
            return;
        }
        this.removeAllRealmsDespiteMaster();
        this.testContext.setInitialized(true);
    }

    @Test
    public void getRealms() {
        List realms = this.adminClient.realms().findAll();
        Assert.assertNames(realms, "master", "test", "admin-client-test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void renameRealm() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId("old");
        rep.setRealm("old");
        try {
            this.adminClient.realms().create(rep);
            rep.setRealm("new");
            this.adminClient.realm("old").update(rep);
            Assert.assertEquals((long)0L, (long)this.adminClient.realm("master").clients().findByClientId("old-realm").size());
            Assert.assertEquals((long)1L, (long)this.adminClient.realm("master").clients().findByClientId("new-realm").size());
            ClientRepresentation adminConsoleClient = (ClientRepresentation)this.adminClient.realm("new").clients().findByClientId("security-admin-console").get(0);
            org.junit.Assert.assertEquals((Object)"${authAdminUrl}", (Object)adminConsoleClient.getRootUrl());
            org.junit.Assert.assertEquals((Object)"/admin/new/console/", (Object)adminConsoleClient.getBaseUrl());
            org.junit.Assert.assertEquals((Object)"/admin/new/console/*", adminConsoleClient.getRedirectUris().get(0));
            ClientRepresentation accountClient = (ClientRepresentation)this.adminClient.realm("new").clients().findByClientId("account").get(0);
            org.junit.Assert.assertEquals((Object)"${authBaseUrl}", (Object)accountClient.getRootUrl());
            org.junit.Assert.assertEquals((Object)"/realms/new/account/", (Object)accountClient.getBaseUrl());
            org.junit.Assert.assertEquals((Object)"/realms/new/account/*", accountClient.getRedirectUris().get(0));
        }
        finally {
            this.adminClient.realms().realm(rep.getRealm()).remove();
        }
    }

    @Test
    public void createRealmEmpty() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        this.adminClient.realms().create(rep);
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test", "admin-client-test", "new-realm");
        List clients = this.adminClient.realms().realm("new-realm").clients().findAll().stream().map(ClientRepresentation::getClientId).collect(Collectors.toList());
        org.junit.Assert.assertThat(clients, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"account", "account-console", "admin-cli", "broker", "realm-management", "security-admin-console"}));
        this.adminClient.realms().realm("new-realm").remove();
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test", "admin-client-test");
    }

    @Test(expected=BadRequestException.class)
    public void createRealmRejectReservedChar() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-re;alm");
        this.adminClient.realms().create(rep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void excludesFieldsFromAttributes() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("attributes");
        this.adminClient.realms().create(rep);
        try {
            RealmRepresentation rep2 = this.adminClient.realm("attributes").toRepresentation();
            if (rep2.getAttributes() != null) {
                Arrays.asList("cibaBackchannelTokenDeliveryMode", "cibaExpiresIn", "cibaInterval", "cibaAuthRequestedUserHint").stream().forEach(i -> rep2.getAttributes().remove(i));
            }
            Map attributes = rep2.getAttributes();
            org.junit.Assert.assertTrue((String)("Attributes expected to be present oauth2DeviceCodeLifespan, oauth2DevicePollingInterval, found: " + String.join((CharSequence)", ", attributes.keySet())), (attributes.size() == 3 && attributes.containsKey(OAuth2DeviceConfig.OAUTH2_DEVICE_CODE_LIFESPAN) && attributes.containsKey(OAuth2DeviceConfig.OAUTH2_DEVICE_POLLING_INTERVAL) && attributes.containsKey("parRequestUriLifespan") ? 1 : 0) != 0);
        }
        finally {
            this.adminClient.realm("attributes").remove();
        }
    }

    @Test
    public void smtpPasswordSecret() {
        RealmRepresentation rep = RealmBuilder.create().testEventListener().testMail().build();
        rep.setRealm("realm-with-smtp");
        rep.getSmtpServer().put("user", "user");
        rep.getSmtpServer().put("password", "secret");
        this.adminClient.realms().create(rep);
        RealmRepresentation returned = this.adminClient.realm("realm-with-smtp").toRepresentation();
        org.junit.Assert.assertEquals((Object)"**********", returned.getSmtpServer().get("password"));
        KeycloakTestingClient.Server serverClient = this.testingClient.server("realm-with-smtp");
        RealmRepresentation internalRep = (RealmRepresentation)serverClient.fetch(RunHelpers.internalRealm());
        org.junit.Assert.assertEquals((Object)"secret", internalRep.getSmtpServer().get("password"));
        this.adminClient.realm("realm-with-smtp").update(rep);
        AdminEventRepresentation event = this.testingClient.testing().pollAdminEvent();
        org.junit.Assert.assertFalse((boolean)event.getRepresentation().contains("some secret value!!"));
        org.junit.Assert.assertTrue((boolean)event.getRepresentation().contains("**********"));
        internalRep = (RealmRepresentation)serverClient.fetch(RunHelpers.internalRealm());
        org.junit.Assert.assertEquals((Object)"secret", internalRep.getSmtpServer().get("password"));
        RealmRepresentation realm = this.adminClient.realms().findAll().stream().filter(r -> r.getRealm().equals("realm-with-smtp")).findFirst().get();
        org.junit.Assert.assertEquals((Object)"**********", realm.getSmtpServer().get("password"));
        this.adminClient.realm("realm-with-smtp").remove();
    }

    @Test
    public void createRealmCheckDefaultPasswordPolicy() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        this.adminClient.realms().create(rep);
        org.junit.Assert.assertEquals(null, (Object)this.adminClient.realm("new-realm").toRepresentation().getPasswordPolicy());
        this.adminClient.realms().realm("new-realm").remove();
        rep.setPasswordPolicy("length(8)");
        this.adminClient.realms().create(rep);
        org.junit.Assert.assertEquals((Object)"length(8)", (Object)this.adminClient.realm("new-realm").toRepresentation().getPasswordPolicy());
        this.adminClient.realms().realm("new-realm").remove();
    }

    @Test
    public void createRealmFromJson() {
        RealmRepresentation rep = RealmTest.loadJson(this.getClass().getResourceAsStream("/admin-test/testrealm.json"), RealmRepresentation.class);
        try {
            this.adminClient.realms().create(rep);
            RealmRepresentation created = this.adminClient.realms().realm("admin-test-1").toRepresentation();
            RealmTest.assertRealm(rep, created);
        }
        finally {
            this.adminClient.realms().realm("admin-test-1").remove();
        }
    }

    @Test
    public void createRealmWithPasswordPolicyFromJsonWithInvalidPasswords() {
        RealmRepresentation rep = RealmTest.loadJson(this.getClass().getResourceAsStream("/import/testrealm-keycloak-6146-error.json"), RealmRepresentation.class);
        this.expectedException.expect(NotFoundException.class);
        this.expectedException.expectMessage(String.valueOf(Response.Status.NOT_FOUND.getStatusCode()));
        try {
            this.adminClient.realms().create(rep);
        }
        catch (BadRequestException ex) {
            this.log.info((Object)"--Caught expected BadRequestException--");
            this.adminClient.realms().realm("secure-app").toRepresentation();
        }
    }

    @Test
    public void createRealmWithPasswordPolicyFromJsonWithValidPasswords() {
        RealmRepresentation rep = RealmTest.loadJson(this.getClass().getResourceAsStream("/import/testrealm-keycloak-6146.json"), RealmRepresentation.class);
        try (Creator c = Creator.create((Keycloak)this.adminClient, (RealmRepresentation)rep);){
            RealmRepresentation created = ((RealmResource)c.resource()).toRepresentation();
            RealmTest.assertRealm(rep, created);
        }
    }

    @Test
    public void removeRealm() {
        this.realm.remove();
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test");
        this.reCreateRealm();
    }

    private void reCreateRealm() {
        RealmRepresentation realmRep = this.testContext.getTestRealmReps().stream().filter(realm -> realm.getRealm().equals("admin-client-test")).findFirst().get();
        this.adminClient.realms().create(realmRep);
    }

    @Test
    public void loginAfterRemoveRealm() {
        this.realm.remove();
        try (Keycloak client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)"admin", (String)"admin", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());){
            client.serverInfo().getInfo();
        }
        this.reCreateRealm();
    }

    @Test
    public void renameRealmTest() throws Exception {
        RealmRepresentation realm1 = new RealmRepresentation();
        realm1.setRealm("test-immutable");
        this.adminClient.realms().create(realm1);
        realm1 = this.adminClient.realms().realm("test-immutable").toRepresentation();
        realm1.setRealm("test-immutable-old");
        this.adminClient.realms().realm("test-immutable").update(realm1);
        org.junit.Assert.assertThat((Object)this.adminClient.realms().realm("test-immutable-old").toRepresentation(), (Matcher)Matchers.notNullValue());
        RealmRepresentation realm2 = new RealmRepresentation();
        realm2.setRealm("test-immutable");
        this.adminClient.realms().create(realm2);
        org.junit.Assert.assertThat((Object)this.adminClient.realms().realm("test-immutable").toRepresentation(), (Matcher)Matchers.notNullValue());
        this.adminClient.realms().realm("test-immutable-old").remove();
        this.adminClient.realms().realm("test-immutable").remove();
    }

    private RealmEventsConfigRepresentation copyRealmEventsConfigRepresentation(RealmEventsConfigRepresentation rep) {
        RealmEventsConfigRepresentation recr = new RealmEventsConfigRepresentation();
        recr.setEnabledEventTypes(rep.getEnabledEventTypes());
        recr.setEventsListeners(rep.getEventsListeners());
        recr.setEventsExpiration(rep.getEventsExpiration());
        recr.setEventsEnabled(rep.isEventsEnabled());
        recr.setAdminEventsEnabled(rep.isAdminEventsEnabled());
        recr.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled());
        return recr;
    }

    private void checkRealmEventsConfigRepresentation(RealmEventsConfigRepresentation expected, RealmEventsConfigRepresentation actual) {
        org.junit.Assert.assertEquals((long)expected.getEnabledEventTypes().size(), (long)actual.getEnabledEventTypes().size());
        org.junit.Assert.assertTrue((boolean)actual.getEnabledEventTypes().containsAll(expected.getEnabledEventTypes()));
        org.junit.Assert.assertEquals((long)expected.getEventsListeners().size(), (long)actual.getEventsListeners().size());
        org.junit.Assert.assertTrue((boolean)actual.getEventsListeners().containsAll(expected.getEventsListeners()));
        org.junit.Assert.assertEquals((Object)expected.getEventsExpiration(), (Object)actual.getEventsExpiration());
        org.junit.Assert.assertEquals((Object)expected.isEventsEnabled(), (Object)actual.isEventsEnabled());
        org.junit.Assert.assertEquals((Object)expected.isAdminEventsEnabled(), (Object)actual.isAdminEventsEnabled());
        org.junit.Assert.assertEquals((Object)expected.isAdminEventsDetailsEnabled(), (Object)actual.isAdminEventsDetailsEnabled());
    }

    @Test
    public void updateRealmEventsConfig() {
        RealmEventsConfigRepresentation rep = this.realm.getRealmEventsConfig();
        RealmEventsConfigRepresentation repOrig = this.copyRealmEventsConfigRepresentation(rep);
        org.junit.Assert.assertTrue((String)"event-queue should be enabled initially", (boolean)rep.getEventsListeners().contains("event-queue"));
        rep.setEnabledEventTypes(Arrays.asList(EventType.LOGIN.name(), EventType.LOGIN_ERROR.name()));
        rep.setEventsListeners(Arrays.asList("jboss-logging"));
        rep.setEventsExpiration(Long.valueOf(36000L));
        rep.setEventsEnabled(true);
        rep.setAdminEventsEnabled(Boolean.valueOf(true));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(true));
        this.adminClient.realms().realm("admin-client-test").updateRealmEventsConfig(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, "events/config", (Object)rep, ResourceType.REALM);
        RealmEventsConfigRepresentation actual = this.realm.getRealmEventsConfig();
        this.checkRealmEventsConfigRepresentation(rep, actual);
        rep.setEnabledEventTypes(Arrays.asList(EventType.LOGIN.name(), EventType.LOGIN_ERROR.name(), EventType.CLIENT_LOGIN.name()));
        this.adminClient.realms().realm("admin-client-test").updateRealmEventsConfig(rep);
        this.assertAdminEvents.assertEmpty();
        actual = this.realm.getRealmEventsConfig();
        this.checkRealmEventsConfigRepresentation(rep, actual);
        this.adminClient.realms().realm("admin-client-test").updateRealmEventsConfig(repOrig);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, "events/config", (Object)repOrig, ResourceType.REALM);
        actual = this.realm.getRealmEventsConfig();
        this.checkRealmEventsConfigRepresentation(repOrig, actual);
    }

    @Test(expected=BadRequestException.class)
    public void updateRealmWithReservedCharInName() {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setRealm("fo#o");
        this.realm.update(rep);
    }

    @Test
    public void updateRealm() {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setSsoSessionIdleTimeout(Integer.valueOf(123));
        rep.setSsoSessionMaxLifespan(Integer.valueOf(12));
        rep.setSsoSessionIdleTimeoutRememberMe(Integer.valueOf(33));
        rep.setSsoSessionMaxLifespanRememberMe(Integer.valueOf(34));
        rep.setAccessCodeLifespanLogin(Integer.valueOf(1234));
        rep.setActionTokenGeneratedByAdminLifespan(Integer.valueOf(2345));
        rep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(3456));
        rep.setRegistrationAllowed(Boolean.valueOf(true));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(true));
        rep.setEditUsernameAllowed(Boolean.valueOf(true));
        rep.setUserManagedAccessAllowed(Boolean.valueOf(true));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((long)123L, (long)rep.getSsoSessionIdleTimeout().intValue());
        org.junit.Assert.assertEquals((long)12L, (long)rep.getSsoSessionMaxLifespan().intValue());
        org.junit.Assert.assertEquals((long)33L, (long)rep.getSsoSessionIdleTimeoutRememberMe().intValue());
        org.junit.Assert.assertEquals((long)34L, (long)rep.getSsoSessionMaxLifespanRememberMe().intValue());
        org.junit.Assert.assertEquals((long)1234L, (long)rep.getAccessCodeLifespanLogin().intValue());
        org.junit.Assert.assertEquals((long)2345L, (long)rep.getActionTokenGeneratedByAdminLifespan().intValue());
        org.junit.Assert.assertEquals((long)3456L, (long)rep.getActionTokenGeneratedByUserLifespan().intValue());
        org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isRegistrationAllowed());
        org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isRegistrationEmailAsUsername());
        org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isEditUsernameAllowed());
        if (ProfileAssume.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION)) {
            org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isUserManagedAccessAllowed());
        } else {
            org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isUserManagedAccessAllowed());
        }
        rep.setRegistrationAllowed(Boolean.valueOf(false));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
        rep.setEditUsernameAllowed(Boolean.valueOf(false));
        rep.setUserManagedAccessAllowed(Boolean.valueOf(false));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isRegistrationAllowed());
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isRegistrationEmailAsUsername());
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isEditUsernameAllowed());
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isUserManagedAccessAllowed());
    }

    @Test
    public void updateRealmWithNewRepresentation() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setEditUsernameAllowed(Boolean.valueOf(true));
        rep.setSupportedLocales(new HashSet<String>(Arrays.asList("en", "de")));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isEditUsernameAllowed());
        org.junit.Assert.assertEquals((long)2L, (long)rep.getSupportedLocales().size());
        rep = new RealmRepresentation();
        rep.setEditUsernameAllowed(Boolean.valueOf(false));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isEditUsernameAllowed());
        org.junit.Assert.assertEquals((long)2L, (long)rep.getSupportedLocales().size());
    }

    @Test
    public void updateRealmAttributes() {
        RealmRepresentation rep = new RealmRepresentation();
        ArrayList<String> webAuthnPolicyAcceptableAaguids = new ArrayList<String>();
        webAuthnPolicyAcceptableAaguids.add("aaguid1");
        webAuthnPolicyAcceptableAaguids.add("aaguid2");
        rep.setAttributes(new HashMap());
        rep.getAttributes().put("foo1", "bar1");
        rep.getAttributes().put("foo2", "bar2");
        rep.setWebAuthnPolicyAcceptableAaguids(webAuthnPolicyAcceptableAaguids);
        rep.setBruteForceProtected(Boolean.valueOf(true));
        rep.setDisplayName("dn1");
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((Object)"bar1", rep.getAttributes().get("foo1"));
        org.junit.Assert.assertEquals((Object)"bar2", rep.getAttributes().get("foo2"));
        org.junit.Assert.assertTrue((boolean)rep.isBruteForceProtected());
        org.junit.Assert.assertEquals((Object)"dn1", (Object)rep.getDisplayName());
        org.junit.Assert.assertEquals(webAuthnPolicyAcceptableAaguids, (Object)rep.getWebAuthnPolicyAcceptableAaguids());
        webAuthnPolicyAcceptableAaguids.clear();
        rep.setBruteForceProtected(Boolean.valueOf(false));
        rep.setDisplayName("dn2");
        rep.getAttributes().put("foo1", "bar11");
        rep.getAttributes().remove("foo2");
        rep.setWebAuthnPolicyAcceptableAaguids(webAuthnPolicyAcceptableAaguids);
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertFalse((boolean)rep.isBruteForceProtected());
        org.junit.Assert.assertEquals((Object)"dn2", (Object)rep.getDisplayName());
        org.junit.Assert.assertEquals((Object)"bar11", rep.getAttributes().get("foo1"));
        org.junit.Assert.assertFalse((boolean)rep.getAttributes().containsKey("foo2"));
        org.junit.Assert.assertTrue((boolean)rep.getWebAuthnPolicyAcceptableAaguids().isEmpty());
    }

    @Test
    public void getRealmRepresentation() {
        RealmRepresentation rep = this.realm.toRepresentation();
        Assert.assertEquals((Object)"admin-client-test", (Object)rep.getRealm());
        org.junit.Assert.assertTrue((boolean)rep.isEnabled());
    }

    @Test
    public void deleteDefaultRole() {
        RoleRepresentation role = new RoleRepresentation("test", "test", false);
        this.realm.roles().create(role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("test"), (Object)role, ResourceType.REALM_ROLE);
        role = this.realm.roles().get("test").toRepresentation();
        org.junit.Assert.assertNotNull((Object)role);
        this.realm.roles().get("default-roles-admin-client-test").addComposites(Collections.singletonList(role));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourceCompositesPath("default-roles-admin-client-test"), Collections.singletonList(role), ResourceType.REALM_ROLE);
        this.realm.roles().deleteRole("test");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleResourcePath("test"), ResourceType.REALM_ROLE);
        try {
            this.realm.roles().get("testsadfsadf").toRepresentation();
            org.junit.Assert.fail((String)"Expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void convertKeycloakClientDescription() throws IOException {
        ClientRepresentation description = new ClientRepresentation();
        description.setClientId("client-id");
        description.setRedirectUris(Collections.singletonList("http://localhost"));
        ClientRepresentation converted = this.realm.convertClientDescription(JsonSerialization.writeValueAsString((Object)description));
        org.junit.Assert.assertEquals((Object)"client-id", (Object)converted.getClientId());
        org.junit.Assert.assertEquals((Object)"http://localhost", converted.getRedirectUris().get(0));
    }

    @Test
    public void convertOIDCClientDescription() throws IOException {
        String description = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/client-descriptions/client-oidc.json"));
        ClientRepresentation converted = this.realm.convertClientDescription(description);
        org.junit.Assert.assertEquals((long)1L, (long)converted.getRedirectUris().size());
        org.junit.Assert.assertEquals((Object)"http://localhost", converted.getRedirectUris().get(0));
    }

    @Test
    public void convertSAMLClientDescription() throws IOException {
        String description = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/client-descriptions/saml-entity-descriptor.xml"));
        ClientRepresentation converted = this.realm.convertClientDescription(description);
        org.junit.Assert.assertEquals((Object)"loadbalancer-9.siroe.com", (Object)converted.getClientId());
        org.junit.Assert.assertEquals((long)2L, (long)converted.getRedirectUris().size());
        org.junit.Assert.assertEquals((Object)"https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp", converted.getRedirectUris().get(0));
        org.junit.Assert.assertEquals((Object)"https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp", converted.getRedirectUris().get(1));
    }

    public static void assertRealm(RealmRepresentation realm, RealmRepresentation storedRealm) {
        if (realm.getId() != null) {
            org.junit.Assert.assertEquals((Object)realm.getId(), (Object)storedRealm.getId());
        }
        if (realm.getRealm() != null) {
            org.junit.Assert.assertEquals((Object)realm.getRealm(), (Object)storedRealm.getRealm());
        }
        if (realm.isEnabled() != null) {
            org.junit.Assert.assertEquals((Object)realm.isEnabled(), (Object)storedRealm.isEnabled());
        }
        if (realm.isBruteForceProtected() != null) {
            org.junit.Assert.assertEquals((Object)realm.isBruteForceProtected(), (Object)storedRealm.isBruteForceProtected());
        }
        if (realm.getMaxFailureWaitSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getMaxFailureWaitSeconds(), (Object)storedRealm.getMaxFailureWaitSeconds());
        }
        if (realm.getMinimumQuickLoginWaitSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getMinimumQuickLoginWaitSeconds(), (Object)storedRealm.getMinimumQuickLoginWaitSeconds());
        }
        if (realm.getWaitIncrementSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getWaitIncrementSeconds(), (Object)storedRealm.getWaitIncrementSeconds());
        }
        if (realm.getQuickLoginCheckMilliSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getQuickLoginCheckMilliSeconds(), (Object)storedRealm.getQuickLoginCheckMilliSeconds());
        }
        if (realm.getMaxDeltaTimeSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getMaxDeltaTimeSeconds(), (Object)storedRealm.getMaxDeltaTimeSeconds());
        }
        if (realm.getFailureFactor() != null) {
            org.junit.Assert.assertEquals((Object)realm.getFailureFactor(), (Object)storedRealm.getFailureFactor());
        }
        if (realm.isRegistrationAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isRegistrationAllowed(), (Object)storedRealm.isRegistrationAllowed());
        }
        if (realm.isRegistrationEmailAsUsername() != null) {
            org.junit.Assert.assertEquals((Object)realm.isRegistrationEmailAsUsername(), (Object)storedRealm.isRegistrationEmailAsUsername());
        }
        if (realm.isRememberMe() != null) {
            org.junit.Assert.assertEquals((Object)realm.isRememberMe(), (Object)storedRealm.isRememberMe());
        }
        if (realm.isVerifyEmail() != null) {
            org.junit.Assert.assertEquals((Object)realm.isVerifyEmail(), (Object)storedRealm.isVerifyEmail());
        }
        if (realm.isLoginWithEmailAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isLoginWithEmailAllowed(), (Object)storedRealm.isLoginWithEmailAllowed());
        }
        if (realm.isDuplicateEmailsAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isDuplicateEmailsAllowed(), (Object)storedRealm.isDuplicateEmailsAllowed());
        }
        if (realm.isResetPasswordAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isResetPasswordAllowed(), (Object)storedRealm.isResetPasswordAllowed());
        }
        if (realm.isEditUsernameAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isEditUsernameAllowed(), (Object)storedRealm.isEditUsernameAllowed());
        }
        if (realm.getSslRequired() != null) {
            org.junit.Assert.assertEquals((Object)realm.getSslRequired(), (Object)storedRealm.getSslRequired());
        }
        if (realm.getAccessCodeLifespan() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccessCodeLifespan(), (Object)storedRealm.getAccessCodeLifespan());
        }
        if (realm.getAccessCodeLifespanUserAction() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccessCodeLifespanUserAction(), (Object)storedRealm.getAccessCodeLifespanUserAction());
        }
        if (realm.getActionTokenGeneratedByAdminLifespan() != null) {
            org.junit.Assert.assertEquals((Object)realm.getActionTokenGeneratedByAdminLifespan(), (Object)storedRealm.getActionTokenGeneratedByAdminLifespan());
        }
        if (realm.getActionTokenGeneratedByUserLifespan() != null) {
            org.junit.Assert.assertEquals((Object)realm.getActionTokenGeneratedByUserLifespan(), (Object)storedRealm.getActionTokenGeneratedByUserLifespan());
        } else {
            org.junit.Assert.assertEquals((Object)realm.getAccessCodeLifespanUserAction(), (Object)storedRealm.getActionTokenGeneratedByUserLifespan());
        }
        if (realm.getNotBefore() != null) {
            org.junit.Assert.assertEquals((Object)realm.getNotBefore(), (Object)storedRealm.getNotBefore());
        }
        if (realm.getAccessTokenLifespan() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccessTokenLifespan(), (Object)storedRealm.getAccessTokenLifespan());
        }
        if (realm.getAccessTokenLifespanForImplicitFlow() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccessTokenLifespanForImplicitFlow(), (Object)storedRealm.getAccessTokenLifespanForImplicitFlow());
        }
        if (realm.getSsoSessionIdleTimeout() != null) {
            org.junit.Assert.assertEquals((Object)realm.getSsoSessionIdleTimeout(), (Object)storedRealm.getSsoSessionIdleTimeout());
        }
        if (realm.getSsoSessionMaxLifespan() != null) {
            org.junit.Assert.assertEquals((Object)realm.getSsoSessionMaxLifespan(), (Object)storedRealm.getSsoSessionMaxLifespan());
        }
        if (realm.getSsoSessionIdleTimeoutRememberMe() != null) {
            Assert.assertEquals((Object)realm.getSsoSessionIdleTimeoutRememberMe(), (Object)storedRealm.getSsoSessionIdleTimeoutRememberMe());
        }
        if (realm.getSsoSessionMaxLifespanRememberMe() != null) {
            Assert.assertEquals((Object)realm.getSsoSessionMaxLifespanRememberMe(), (Object)storedRealm.getSsoSessionMaxLifespanRememberMe());
        }
        if (realm.getClientSessionIdleTimeout() != null) {
            Assert.assertEquals((Object)realm.getClientSessionIdleTimeout(), (Object)storedRealm.getClientSessionIdleTimeout());
        }
        if (realm.getClientSessionMaxLifespan() != null) {
            Assert.assertEquals((Object)realm.getClientSessionMaxLifespan(), (Object)storedRealm.getClientSessionMaxLifespan());
        }
        if (realm.getClientOfflineSessionIdleTimeout() != null) {
            Assert.assertEquals((Object)realm.getClientOfflineSessionIdleTimeout(), (Object)storedRealm.getClientOfflineSessionIdleTimeout());
        }
        if (realm.getClientOfflineSessionMaxLifespan() != null) {
            Assert.assertEquals((Object)realm.getClientOfflineSessionMaxLifespan(), (Object)storedRealm.getClientOfflineSessionMaxLifespan());
        }
        if (realm.getRequiredCredentials() != null) {
            org.junit.Assert.assertNotNull((Object)storedRealm.getRequiredCredentials());
            for (String cred : realm.getRequiredCredentials()) {
                org.junit.Assert.assertTrue((boolean)storedRealm.getRequiredCredentials().contains(cred));
            }
        }
        if (realm.getLoginTheme() != null) {
            org.junit.Assert.assertEquals((Object)realm.getLoginTheme(), (Object)storedRealm.getLoginTheme());
        }
        if (realm.getAccountTheme() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccountTheme(), (Object)storedRealm.getAccountTheme());
        }
        if (realm.getAdminTheme() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAdminTheme(), (Object)storedRealm.getAdminTheme());
        }
        if (realm.getEmailTheme() != null) {
            org.junit.Assert.assertEquals((Object)realm.getEmailTheme(), (Object)storedRealm.getEmailTheme());
        }
        if (realm.getPasswordPolicy() != null) {
            org.junit.Assert.assertEquals((Object)realm.getPasswordPolicy(), (Object)storedRealm.getPasswordPolicy());
        }
        if (realm.getSmtpServer() != null) {
            org.junit.Assert.assertEquals((Object)realm.getSmtpServer(), (Object)storedRealm.getSmtpServer());
        }
        if (realm.getBrowserSecurityHeaders() != null) {
            org.junit.Assert.assertEquals((Object)realm.getBrowserSecurityHeaders(), (Object)storedRealm.getBrowserSecurityHeaders());
        }
        if (realm.getAttributes() != null) {
            HashMap attributes = new HashMap();
            attributes.putAll(storedRealm.getAttributes());
            attributes.entrySet().retainAll(realm.getAttributes().entrySet());
            org.junit.Assert.assertEquals((Object)realm.getAttributes(), attributes);
        }
        if (realm.isUserManagedAccessAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isUserManagedAccessAllowed(), (Object)storedRealm.isUserManagedAccessAllowed());
        }
    }

    @Test
    public void clearRealmCache() {
        RealmRepresentation realmRep = this.realm.toRepresentation();
        org.junit.Assert.assertTrue((boolean)this.testingClient.testing().cache("realms").contains(realmRep.getId()));
        this.realm.clearRealmCache();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "clear-realm-cache", ResourceType.REALM);
        org.junit.Assert.assertFalse((boolean)this.testingClient.testing().cache("realms").contains(realmRep.getId()));
    }

    @Test
    public void clearUserCache() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("clearcacheuser");
        Response response = this.realm.users().create(user);
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(userId), (Object)user, ResourceType.USER);
        this.realm.users().get(userId).toRepresentation();
        org.junit.Assert.assertTrue((boolean)this.testingClient.testing().cache("users").contains(userId));
        this.realm.clearUserCache();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "clear-user-cache", ResourceType.REALM);
        org.junit.Assert.assertFalse((boolean)this.testingClient.testing().cache("users").contains(userId));
    }

    @Test
    public void pushNotBefore() {
        this.setupTestAppAndUser();
        int time = Time.currentTime() - 60;
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setNotBefore(Integer.valueOf(time));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        GlobalRequestResult globalRequestResult = this.realm.pushRevocation();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "push-revocation", (Object)globalRequestResult, ResourceType.REALM);
        Object[] objectArray = new String[1];
        objectArray[0] = OAuthClient.AUTH_SERVER_ROOT + "/realms/master/app/admin";
        org.junit.Assert.assertThat((Object)globalRequestResult.getSuccessRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])objectArray));
        org.junit.Assert.assertNull((Object)globalRequestResult.getFailedRequests());
        PushNotBeforeAction adminPushNotBefore = this.testingClient.testApp().getAdminPushNotBefore();
        org.junit.Assert.assertEquals((long)time, (long)adminPushNotBefore.getNotBefore());
    }

    @Test
    public void pushNotBeforeWithSamlApp() {
        this.setupTestAppAndUser();
        this.setupTestSamlApp();
        int time = Time.currentTime() - 60;
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setNotBefore(Integer.valueOf(time));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        GlobalRequestResult globalRequestResult = this.realm.pushRevocation();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "push-revocation", (Object)globalRequestResult, ResourceType.REALM);
        Object[] objectArray = new String[1];
        objectArray[0] = OAuthClient.AUTH_SERVER_ROOT + "/realms/master/app/admin";
        org.junit.Assert.assertThat((Object)globalRequestResult.getSuccessRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])objectArray));
        Object[] objectArray2 = new String[1];
        objectArray2[0] = OAuthClient.AUTH_SERVER_ROOT + "/realms/master/saml-app/saml";
        org.junit.Assert.assertThat((Object)globalRequestResult.getFailedRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])objectArray2));
        PushNotBeforeAction adminPushNotBefore = this.testingClient.testApp().getAdminPushNotBefore();
        org.junit.Assert.assertEquals((long)time, (long)adminPushNotBefore.getNotBefore());
    }

    @Test
    public void logoutAll() {
        this.setupTestAppAndUser();
        Response response = this.realm.users().create(UserBuilder.create().username("user").build());
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(userId), ResourceType.USER);
        this.realm.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResetPasswordPath(userId), ResourceType.USER);
        this.oauth.doLogin("user", "password");
        GlobalRequestResult globalRequestResult = this.realm.logoutAll();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "logout-all", (Object)globalRequestResult, ResourceType.REALM);
        org.junit.Assert.assertEquals((long)1L, (long)globalRequestResult.getSuccessRequests().size());
        org.junit.Assert.assertEquals((Object)(OAuthClient.AUTH_SERVER_ROOT + "/realms/master/app/admin"), globalRequestResult.getSuccessRequests().get(0));
        org.junit.Assert.assertNull((Object)globalRequestResult.getFailedRequests());
        org.junit.Assert.assertNotNull((Object)this.testingClient.testApp().getAdminLogoutAction());
    }

    @Test
    public void deleteSession() {
        this.setupTestAppAndUser();
        this.oauth.doLogin("testuser", "password");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "secret");
        org.junit.Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        EventRepresentation event = this.events.poll();
        org.junit.Assert.assertNotNull((Object)event);
        this.realm.deleteSession(event.getSessionId());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.deleteSessionPath(event.getSessionId()), ResourceType.USER_SESSION);
        try {
            this.realm.deleteSession(event.getSessionId());
            org.junit.Assert.fail((String)"Expected 404");
        }
        catch (NotFoundException e) {
            this.assertAdminEvents.assertEmpty();
        }
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "secret");
        org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        org.junit.Assert.assertEquals((Object)"Session not active", (Object)tokenResponse.getErrorDescription());
    }

    @Test
    public void clientSessionStats() {
        this.setupTestAppAndUser();
        List sessionStats = this.realm.getClientSessionStats();
        org.junit.Assert.assertTrue((boolean)sessionStats.isEmpty());
        System.out.println(sessionStats.size());
        this.oauth.doLogin("testuser", "password");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "secret");
        org.junit.Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        sessionStats = this.realm.getClientSessionStats();
        org.junit.Assert.assertEquals((long)1L, (long)sessionStats.size());
        org.junit.Assert.assertEquals((Object)"test-app", ((Map)sessionStats.get(0)).get("clientId"));
        org.junit.Assert.assertEquals((Object)"1", ((Map)sessionStats.get(0)).get("active"));
        String clientUuid = (String)((Map)sessionStats.get(0)).get("id");
        this.realm.clients().get(clientUuid).remove();
        sessionStats = this.realm.getClientSessionStats();
        org.junit.Assert.assertEquals((long)0L, (long)sessionStats.size());
    }

    @Test
    public void testDefaultSignatureAlgorithm() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        try {
            this.adminClient.realms().create(rep);
            org.junit.Assert.assertEquals((Object)"RS256", (Object)this.adminClient.realm("master").toRepresentation().getDefaultSignatureAlgorithm());
            org.junit.Assert.assertEquals((Object)"RS256", (Object)this.adminClient.realm("new-realm").toRepresentation().getDefaultSignatureAlgorithm());
        }
        finally {
            this.adminClient.realms().realm(rep.getRealm()).remove();
        }
    }

    private void setupTestAppAndUser() {
        this.testingClient.testApp().clearAdminActions();
        String redirectUri = this.oauth.getRedirectUri().replace("/master/", "/admin-client-test/");
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("test-app");
        client.setAdminUrl(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/app/admin");
        client.setRedirectUris(Collections.singletonList(redirectUri));
        client.setProtocol("openid-connect");
        client.setSecret("secret");
        Response resp = this.realm.clients().create(client);
        String clientDbId = ApiUtil.getCreatedId((Response)resp);
        this.getCleanup().addClientUuid(clientDbId);
        resp.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(clientDbId), (Object)client, ResourceType.CLIENT);
        this.oauth.realm("admin-client-test");
        this.oauth.redirectUri(redirectUri);
        UserRepresentation userRep = UserBuilder.create().username("testuser").build();
        Response response = this.realm.users().create(userRep);
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.getCleanup().addUserId(userId);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(userId), (Object)userRep, ResourceType.USER);
        this.realm.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResetPasswordPath(userId), ResourceType.USER);
        this.testingClient.testApp().clearAdminActions();
    }

    private void setupTestSamlApp() {
        String redirectUri = this.oauth.getRedirectUri().replace("/master/", "/admin-client-test/");
        ClientRepresentation client = ClientBuilder.create().clientId("test-saml-app").protocol("saml").adminUrl(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/saml-app/saml").addRedirectUri(redirectUri).secret("secret").build();
        Response resp = this.realm.clients().create(client);
        String clientDbId = ApiUtil.getCreatedId((Response)resp);
        this.getCleanup().addClientUuid(clientDbId);
        resp.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(clientDbId), (Object)client, ResourceType.CLIENT);
    }
}

