/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.realm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RoleBuilder;

public class RealmRolesTest
extends AbstractAdminTest {
    private static final Map<String, List<String>> ROLE_A_ATTRIBUTES = Collections.singletonMap("role-a-attr-key1", Collections.singletonList("role-a-attr-val1"));
    private RolesResource resource;
    private Map<String, String> ids = new HashMap<String, String>();
    private String clientUuid;

    @Before
    public void before() {
        RoleRepresentation roleA = RoleBuilder.create().name("role-a").description("Role A").attributes(ROLE_A_ATTRIBUTES).build();
        RoleRepresentation roleB = RoleBuilder.create().name("role-b").description("Role B").build();
        RoleRepresentation roleWithUsers = RoleBuilder.create().name("role-with-users").description("Role with users").build();
        RoleRepresentation roleWithoutUsers = RoleBuilder.create().name("role-without-users").description("role-without-users").build();
        this.adminClient.realm("admin-client-test").roles().create(roleA);
        this.adminClient.realm("admin-client-test").roles().create(roleB);
        this.adminClient.realm("admin-client-test").roles().create(roleWithUsers);
        this.adminClient.realm("admin-client-test").roles().create(roleWithoutUsers);
        ClientRepresentation clientRep = ClientBuilder.create().clientId("client-a").build();
        try (Response response = this.adminClient.realm("admin-client-test").clients().create(clientRep);){
            this.clientUuid = ApiUtil.getCreatedId((Response)response);
            this.getCleanup().addClientUuid(this.clientUuid);
        }
        RoleRepresentation roleC = RoleBuilder.create().name("role-c").description("Role C").build();
        this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().create(roleC);
        for (RoleRepresentation r : this.adminClient.realm("admin-client-test").roles().list()) {
            this.ids.put(r.getName(), r.getId());
        }
        for (RoleRepresentation r : this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().list()) {
            this.ids.put(r.getName(), r.getId());
        }
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("test-role-member");
        userRep.setEmail("test-role-member@test-role-member.com");
        userRep.setRequiredActions(Collections.emptyList());
        userRep.setEnabled(Boolean.valueOf(true));
        this.adminClient.realm("admin-client-test").users().create(userRep);
        this.getCleanup().addRoleId(this.ids.get("role-a"));
        this.getCleanup().addRoleId(this.ids.get("role-b"));
        this.getCleanup().addRoleId(this.ids.get("role-c"));
        this.getCleanup().addRoleId(this.ids.get("role-with-users"));
        this.getCleanup().addRoleId(this.ids.get("role-without-users"));
        this.getCleanup().addUserId(((UserRepresentation)this.adminClient.realm("admin-client-test").users().search(userRep.getUsername()).get(0)).getId());
        GroupRepresentation groupRep = new GroupRepresentation();
        groupRep.setName("test-role-group");
        groupRep.setPath("/test-role-group");
        this.adminClient.realm("admin-client-test").groups().add(groupRep);
        this.getCleanup().addGroupId(((GroupRepresentation)this.adminClient.realm("admin-client-test").groups().groups().get(0)).getId());
        this.resource = this.adminClient.realm("admin-client-test").roles();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("role-a"), (Object)roleA, ResourceType.REALM_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("role-b"), (Object)roleB, ResourceType.REALM_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("role-with-users"), (Object)roleWithUsers, ResourceType.REALM_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("role-without-users"), (Object)roleWithoutUsers, ResourceType.REALM_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(this.clientUuid), (Object)clientRep, ResourceType.CLIENT);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientUuid, "role-c"), (Object)roleC, ResourceType.CLIENT_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(((UserRepresentation)this.adminClient.realm("admin-client-test").users().search(userRep.getUsername()).get(0)).getId()), (Object)userRep, ResourceType.USER);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.groupPath(((GroupRepresentation)this.adminClient.realm("admin-client-test").groups().groups().get(0)).getId()), (Object)groupRep, ResourceType.GROUP);
    }

    private RoleRepresentation makeRole(String name) {
        RoleRepresentation role = new RoleRepresentation();
        role.setName(name);
        return role;
    }

    @Test
    public void getRole() {
        RoleRepresentation role = this.resource.get("role-a").toRepresentation();
        org.junit.Assert.assertNotNull((Object)role);
        org.junit.Assert.assertEquals((Object)"role-a", (Object)role.getName());
        org.junit.Assert.assertEquals((Object)"Role A", (Object)role.getDescription());
        org.junit.Assert.assertEquals(ROLE_A_ATTRIBUTES, (Object)role.getAttributes());
        org.junit.Assert.assertFalse((boolean)role.isComposite());
    }

    @Test(expected=ClientErrorException.class)
    public void createRoleWithSameName() {
        this.resource.create(RoleBuilder.create().name("role-a").build());
    }

    @Test
    public void updateRole() {
        RoleRepresentation role = this.resource.get("role-a").toRepresentation();
        role.setName("role-a-new");
        role.setDescription("Role A New");
        Map<String, List<String>> newAttributes = Collections.singletonMap("attrKeyNew", Collections.singletonList("attrValueNew"));
        role.setAttributes(newAttributes);
        this.resource.get("role-a").update(role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.roleResourcePath("role-a"), (Object)role, ResourceType.REALM_ROLE);
        role = this.resource.get("role-a-new").toRepresentation();
        org.junit.Assert.assertNotNull((Object)role);
        org.junit.Assert.assertEquals((Object)"role-a-new", (Object)role.getName());
        org.junit.Assert.assertEquals((Object)"Role A New", (Object)role.getDescription());
        org.junit.Assert.assertEquals(newAttributes, (Object)role.getAttributes());
        org.junit.Assert.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void deleteRole() {
        org.junit.Assert.assertNotNull((Object)this.resource.get("role-a"));
        this.resource.deleteRole("role-a");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleResourcePath("role-a"), ResourceType.REALM_ROLE);
        try {
            this.resource.get("role-a").toRepresentation();
            org.junit.Assert.fail((String)"Expected 404");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void composites() {
        org.junit.Assert.assertFalse((boolean)this.resource.get("role-a").toRepresentation().isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.resource.get("role-a").getRoleComposites().size());
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(RoleBuilder.create().id(this.ids.get("role-b")).build());
        l.add(RoleBuilder.create().id(this.ids.get("role-c")).build());
        this.resource.get("role-a").addComposites(l);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourceCompositesPath("role-a"), l, ResourceType.REALM_ROLE);
        Set composites = this.resource.get("role-a").getRoleComposites();
        org.junit.Assert.assertTrue((boolean)this.resource.get("role-a").toRepresentation().isComposite());
        Assert.assertNames(composites, "role-b", "role-c");
        Set realmComposites = this.resource.get("role-a").getRealmRoleComposites();
        Assert.assertNames(realmComposites, "role-b");
        Set clientComposites = this.resource.get("role-a").getClientRoleComposites(this.clientUuid);
        Assert.assertNames(clientComposites, "role-c");
        this.resource.get("role-a").deleteComposites(l);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleResourceCompositesPath("role-a"), l, ResourceType.REALM_ROLE);
        org.junit.Assert.assertFalse((boolean)this.resource.get("role-a").toRepresentation().isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.resource.get("role-a").getRoleComposites().size());
    }

    @Test
    public void testUsersInRole() {
        RoleResource role = this.resource.get("role-with-users");
        List users = this.adminClient.realm("admin-client-test").users().search("test-role-member", null, null, null, null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        UserResource user = this.adminClient.realm("admin-client-test").users().get(((UserRepresentation)users.get(0)).getId());
        UserRepresentation userRep = user.toRepresentation();
        RoleResource roleResource = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        LinkedList<RoleRepresentation> rolesToAdd = new LinkedList<RoleRepresentation>();
        rolesToAdd.add(roleResource.toRepresentation());
        this.adminClient.realm("admin-client-test").users().get(userRep.getId()).roles().realmLevel().add(rolesToAdd);
        roleResource = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        roleResource.getRoleUserMembers();
        org.junit.Assert.assertEquals((long)1L, (long)roleResource.getRoleUserMembers().size());
    }

    @Test
    public void testUsersNotInRole() {
        RoleResource role = this.resource.get("role-without-users");
        role = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        role.getRoleUserMembers();
        org.junit.Assert.assertEquals((long)0L, (long)role.getRoleUserMembers().size());
    }

    @Test
    public void testGroupsInRole() {
        RoleResource role = this.resource.get("role-with-users");
        List groups = this.adminClient.realm("admin-client-test").groups().groups();
        GroupRepresentation groupRep = groups.stream().filter(g -> g.getPath().equals("/test-role-group")).findFirst().get();
        RoleResource roleResource = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        LinkedList<RoleRepresentation> rolesToAdd = new LinkedList<RoleRepresentation>();
        rolesToAdd.add(roleResource.toRepresentation());
        this.adminClient.realm("admin-client-test").groups().group(groupRep.getId()).roles().realmLevel().add(rolesToAdd);
        roleResource = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        Set groupsInRole = roleResource.getRoleGroupMembers();
        org.junit.Assert.assertTrue((boolean)groupsInRole.stream().filter(g -> g.getPath().equals("/test-role-group")).findFirst().isPresent());
    }

    @Test
    public void testGroupsNotInRole() {
        RoleResource role = this.resource.get("role-without-users");
        role = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        Set groupsInRole = role.getRoleGroupMembers();
        org.junit.Assert.assertTrue((boolean)groupsInRole.isEmpty());
    }

    @Test
    public void roleMembershipAfterUserRemoval() {
        RoleResource role = this.resource.get("role-with-users");
        List users = this.adminClient.realm("admin-client-test").users().search("test-role-member", null, null, null, null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        UserResource user = this.adminClient.realm("admin-client-test").users().get(((UserRepresentation)users.get(0)).getId());
        UserRepresentation userRep = user.toRepresentation();
        RoleResource roleResource = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        LinkedList<RoleRepresentation> rolesToAdd = new LinkedList<RoleRepresentation>();
        rolesToAdd.add(roleResource.toRepresentation());
        this.adminClient.realm("admin-client-test").users().get(userRep.getId()).roles().realmLevel().add(rolesToAdd);
        roleResource = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        roleResource.getRoleUserMembers();
        org.junit.Assert.assertEquals((long)1L, (long)roleResource.getRoleUserMembers().size());
        this.adminClient.realm("admin-client-test").users().delete(userRep.getId());
        roleResource.getRoleUserMembers();
        org.junit.Assert.assertEquals((long)0L, (long)roleResource.getRoleUserMembers().size());
    }

    @Test
    public void testRoleMembershipWithPagination() {
        RoleResource role = this.resource.get("role-with-users");
        UserRepresentation userRep2 = new UserRepresentation();
        userRep2.setUsername("test-role-member2");
        userRep2.setEmail("test-role-member2@test-role-member.com");
        userRep2.setRequiredActions(Collections.emptyList());
        userRep2.setEnabled(Boolean.valueOf(true));
        this.adminClient.realm("admin-client-test").users().create(userRep2);
        List users = this.adminClient.realm("admin-client-test").users().search("test-role-member", null, null, null, null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)IsCollectionWithSize.hasSize((int)2));
        for (UserRepresentation userRepFromList : users) {
            UserResource user = this.adminClient.realm("admin-client-test").users().get(userRepFromList.getId());
            UserRepresentation userRep = user.toRepresentation();
            RoleResource roleResource = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
            LinkedList<RoleRepresentation> rolesToAdd = new LinkedList<RoleRepresentation>();
            rolesToAdd.add(roleResource.toRepresentation());
            this.adminClient.realm("admin-client-test").users().get(userRep.getId()).roles().realmLevel().add(rolesToAdd);
        }
        RoleResource roleResource = this.adminClient.realm("admin-client-test").roles().get(role.toRepresentation().getName());
        Set roleUserMembers = roleResource.getRoleUserMembers(Integer.valueOf(0), Integer.valueOf(1));
        HashSet<String> expectedMembers = new HashSet<String>();
        MatcherAssert.assertThat((Object)roleUserMembers, (Matcher)IsCollectionWithSize.hasSize((int)1));
        expectedMembers.add(((UserRepresentation)roleUserMembers.iterator().next()).getUsername());
        roleUserMembers = roleResource.getRoleUserMembers(Integer.valueOf(1), Integer.valueOf(1));
        MatcherAssert.assertThat((Object)roleUserMembers, (Matcher)IsCollectionWithSize.hasSize((int)1));
        expectedMembers.add(((UserRepresentation)roleUserMembers.iterator().next()).getUsername());
        roleUserMembers = roleResource.getRoleUserMembers(Integer.valueOf(2), Integer.valueOf(1));
        MatcherAssert.assertThat((Object)roleUserMembers, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(expectedMembers, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"test-role-member", "test-role-member2"}));
    }

    @Test
    public void testSearchForRoles() {
        for (int i = 0; i < 15; ++i) {
            String roleName = "testrole" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.resource.create(role);
            this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath(roleName), (Object)role, ResourceType.REALM_ROLE);
        }
        String roleNameA = "abcdefg";
        RoleRepresentation roleA = this.makeRole(roleNameA);
        this.resource.create(roleA);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath(roleNameA), (Object)roleA, ResourceType.REALM_ROLE);
        String roleNameB = "defghij";
        RoleRepresentation roleB = this.makeRole(roleNameB);
        this.resource.create(roleB);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath(roleNameB), (Object)roleB, ResourceType.REALM_ROLE);
        List resultSearch = this.resource.list("defg", Integer.valueOf(-1), Integer.valueOf(-1));
        org.junit.Assert.assertEquals((long)2L, (long)resultSearch.size());
        List resultSearch2 = this.resource.list("testrole", Integer.valueOf(-1), Integer.valueOf(-1));
        org.junit.Assert.assertEquals((long)15L, (long)resultSearch2.size());
        List resultSearchPagination = this.resource.list("testrole", Integer.valueOf(1), Integer.valueOf(5));
        org.junit.Assert.assertEquals((long)5L, (long)resultSearchPagination.size());
    }

    @Test
    public void testPaginationRoles() {
        for (int i = 0; i < 15; ++i) {
            String roleName = "role" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.resource.create(role);
            this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath(roleName), (Object)role, ResourceType.REALM_ROLE);
        }
        List resultSearchPagination = this.resource.list(Integer.valueOf(1), Integer.valueOf(5));
        org.junit.Assert.assertEquals((long)5L, (long)resultSearchPagination.size());
        List resultSearchPagination2 = this.resource.list(Integer.valueOf(5), Integer.valueOf(5));
        org.junit.Assert.assertEquals((long)5L, (long)resultSearchPagination2.size());
        List resultSearchPagination3 = this.resource.list(Integer.valueOf(1), Integer.valueOf(5));
        org.junit.Assert.assertEquals((long)5L, (long)resultSearchPagination3.size());
        List resultSearchPaginationIncoherentParams = this.resource.list(Integer.valueOf(1), null);
        org.junit.Assert.assertTrue((resultSearchPaginationIncoherentParams.size() > 15 ? 1 : 0) != 0);
    }

    @Test
    public void testPaginationRolesCache() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "paginaterole" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.resource.create(role);
            this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath(roleName), (Object)role, ResourceType.REALM_ROLE);
        }
        List resultBeforeAddingRoleToTestCache = this.resource.list(Integer.valueOf(1), Integer.valueOf(1000));
        RoleRepresentation role = this.makeRole("anewrole");
        this.resource.create(role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("anewrole"), (Object)role, ResourceType.REALM_ROLE);
        List resultafterAddingRoleToTestCache = this.resource.list(Integer.valueOf(1), Integer.valueOf(1000));
        org.junit.Assert.assertEquals((long)(resultBeforeAddingRoleToTestCache.size() + 1), (long)resultafterAddingRoleToTestCache.size());
    }

    @Test
    public void getRolesWithFullRepresentation() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "attributesrole" + i;
            RoleRepresentation role = this.makeRole(roleName);
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            attributes.put("attribute1", Arrays.asList("value1", "value2"));
            role.setAttributes(attributes);
            this.resource.create(role);
            this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath(roleName), (Object)role, ResourceType.REALM_ROLE);
        }
        List roles = this.resource.list("attributesrole", false);
        org.junit.Assert.assertTrue((boolean)((RoleRepresentation)roles.get(0)).getAttributes().containsKey("attribute1"));
    }

    @Test
    public void getRolesWithBriefRepresentation() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "attributesrolebrief" + i;
            RoleRepresentation role = this.makeRole(roleName);
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            attributes.put("attribute1", Arrays.asList("value1", "value2"));
            role.setAttributes(attributes);
            this.resource.create(role);
            this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath(roleName), (Object)role, ResourceType.REALM_ROLE);
        }
        List roles = this.resource.list("attributesrolebrief", true);
        org.junit.Assert.assertNull((Object)((RoleRepresentation)roles.get(0)).getAttributes());
    }

    @Test
    public void testDefaultRoles() {
        RoleResource defaultRole = this.adminClient.realm("admin-client-test").roles().get("default-roles-admin-client-test");
        UserRepresentation user = (UserRepresentation)this.adminClient.realm("admin-client-test").users().search("test-role-member").get(0);
        UserResource userResource = this.adminClient.realm("admin-client-test").users().get(user.getId());
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().realmLevel().listAll()), (Matcher)Matchers.hasItem((Object)"default-roles-admin-client-test"));
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().realmLevel().listEffective()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)"default-roles-admin-client-test"), (Matcher)Matchers.hasItem((Object)"offline_access"), (Matcher)Matchers.hasItem((Object)"uma_authorization")));
        defaultRole.addComposites(Collections.singletonList(this.resource.get("role-a").toRepresentation()));
        userResource = this.adminClient.realm("admin-client-test").users().get(user.getId());
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().realmLevel().listAll()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)"default-roles-admin-client-test"), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"role-a"))));
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().realmLevel().listEffective()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)"default-roles-admin-client-test"), (Matcher)Matchers.hasItem((Object)"offline_access"), (Matcher)Matchers.hasItem((Object)"uma_authorization"), (Matcher)Matchers.hasItem((Object)"role-a")));
        MatcherAssert.assertThat((Object)userResource.roles().clientLevel(this.clientUuid).listAll(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)userResource.roles().clientLevel(this.clientUuid).listEffective(), (Matcher)Matchers.empty());
        defaultRole.addComposites(Collections.singletonList(this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().get("role-c").toRepresentation()));
        userResource = this.adminClient.realm("admin-client-test").users().get(user.getId());
        MatcherAssert.assertThat((Object)userResource.roles().clientLevel(this.clientUuid).listAll(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().clientLevel(this.clientUuid).listEffective()), (Matcher)Matchers.hasItem((Object)"role-c"));
    }

    @Test(expected=BadRequestException.class)
    public void testDeleteDefaultRole() {
        this.adminClient.realm("admin-client-test").roles().deleteRole("default-roles-admin-client-test");
    }

    private List<String> convertRolesToNames(List<RoleRepresentation> roles) {
        return roles.stream().map(RoleRepresentation::getName).collect(Collectors.toList());
    }
}

