/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.partialexport;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;

public class PartialExportTest
extends AbstractAdminTest {
    private static final String EXPORT_TEST_REALM = "partial-export-test";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        super.addTestRealms(testRealms);
        RealmRepresentation realmRepresentation = PartialExportTest.loadJson(this.getClass().getResourceAsStream("/export/partialexport-testrealm.json"), RealmRepresentation.class);
        testRealms.add(realmRepresentation);
    }

    @Test
    public void testExport() {
        RealmRepresentation rep = this.adminClient.realm(EXPORT_TEST_REALM).partialExport(Boolean.valueOf(false), Boolean.valueOf(false));
        Assert.assertNull((String)"Users are null", (Object)rep.getUsers());
        Assert.assertNull((String)"Default groups are empty", (Object)rep.getDefaultGroups());
        Assert.assertNull((String)"Groups are empty", (Object)rep.getGroups());
        Assert.assertNull((String)"Realm and client roles are empty", (Object)rep.getRoles());
        Assert.assertNull((String)"Clients are empty", (Object)rep.getClients());
        this.checkScopeMappings(rep.getScopeMappings(), true);
        Assert.assertNull((String)"Client scope mappings empty", (Object)rep.getClientScopeMappings());
        rep = this.adminClient.realm(EXPORT_TEST_REALM).partialExport(Boolean.valueOf(true), Boolean.valueOf(false));
        Assert.assertNull((String)"Users are null", (Object)rep.getUsers());
        Assert.assertNull((String)"Default groups are empty", (Object)rep.getDefaultGroups());
        Assert.assertNotNull((String)"Groups not empty", (Object)rep.getGroups());
        this.checkGroups(rep.getGroups());
        Assert.assertNotNull((String)"Realm and client roles not empty", (Object)rep.getRoles());
        Assert.assertNotNull((String)"Realm roles not empty", (Object)rep.getRoles().getRealm());
        this.checkRealmRoles(rep.getRoles().getRealm());
        Assert.assertNull((String)"Client roles are empty", (Object)rep.getRoles().getClient());
        Assert.assertNull((String)"Clients are empty", (Object)rep.getClients());
        this.checkScopeMappings(rep.getScopeMappings(), true);
        Assert.assertNull((String)"Client scope mappings empty", (Object)rep.getClientScopeMappings());
        rep = this.adminClient.realm(EXPORT_TEST_REALM).partialExport(Boolean.valueOf(false), Boolean.valueOf(true));
        Assert.assertNotNull((String)"The service accout user should be exported", (Object)rep.getUsers());
        Assert.assertEquals((String)"Only one client has a service account", (long)1L, (long)rep.getUsers().size());
        this.checkServiceAccountRoles((UserRepresentation)rep.getUsers().get(0), false);
        Assert.assertNull((String)"Default groups are empty", (Object)rep.getDefaultGroups());
        Assert.assertNull((String)"Groups are empty", (Object)rep.getGroups());
        Assert.assertNull((String)"Realm and client roles are empty", (Object)rep.getRoles());
        Assert.assertNotNull((String)"Clients not empty", (Object)rep.getClients());
        this.checkClients(rep.getClients());
        this.checkScopeMappings(rep.getScopeMappings(), false);
        this.checkClientScopeMappings(rep.getClientScopeMappings());
        rep = this.adminClient.realm(EXPORT_TEST_REALM).partialExport(Boolean.valueOf(true), Boolean.valueOf(true));
        Assert.assertNotNull((String)"The service accout user should be exported", (Object)rep.getUsers());
        Assert.assertEquals((String)"Only one client has a service account", (long)1L, (long)rep.getUsers().size());
        this.checkServiceAccountRoles((UserRepresentation)rep.getUsers().get(0), true);
        Assert.assertNull((String)"Default groups are empty", (Object)rep.getDefaultGroups());
        Assert.assertNotNull((String)"Groups not empty", (Object)rep.getGroups());
        this.checkGroups(rep.getGroups());
        Assert.assertNotNull((String)"Realm and client roles not empty", (Object)rep.getRoles());
        Assert.assertNotNull((String)"Realm roles not empty", (Object)rep.getRoles().getRealm());
        this.checkRealmRoles(rep.getRoles().getRealm());
        Assert.assertNotNull((String)"Client roles not empty", (Object)rep.getRoles().getClient());
        this.checkClientRoles(rep.getRoles().getClient());
        Assert.assertNotNull((String)"Clients not empty", (Object)rep.getClients());
        this.checkClients(rep.getClients());
        this.checkScopeMappings(rep.getScopeMappings(), false);
        this.checkClientScopeMappings(rep.getClientScopeMappings());
        this.checkSecretsAreMasked(rep);
    }

    private void checkServiceAccountRoles(UserRepresentation serviceAccount, boolean rolesExpected) {
        Assert.assertTrue((String)"User is a service account", (boolean)serviceAccount.getUsername().startsWith("service-account-"));
        Assert.assertNull((String)"Password should be null", (Object)serviceAccount.getCredentials());
        if (rolesExpected) {
            List realmRoles = serviceAccount.getRealmRoles();
            Assert.assertThat((String)"Realm roles are OK", (Object)realmRoles, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"uma_authorization", "user", "offline_access"}));
            Map clientRoles = serviceAccount.getClientRoles();
            Assert.assertNotNull((String)"Client roles are exported", (Object)clientRoles);
            Assert.assertThat((String)"Client roles for test-app-service-account are OK", (Object)((List)clientRoles.get("test-app-service-account")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"test-app-service-account", "test-app-service-account-parent"}));
            Assert.assertThat((String)"Client roles for account are OK", (Object)((List)clientRoles.get("account")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"manage-account", "view-profile"}));
        } else {
            Assert.assertNull((String)"Service account should be exported without realm roles", (Object)serviceAccount.getRealmRoles());
            Assert.assertNull((String)"Service account should be exported without client roles", (Object)serviceAccount.getClientRoles());
        }
    }

    private void checkSecretsAreMasked(RealmRepresentation rep) {
        for (ClientRepresentation client : rep.getClients()) {
            if (!Boolean.FALSE.equals(client.isPublicClient()) || !Boolean.FALSE.equals(client.isBearerOnly())) continue;
            Assert.assertEquals((String)"Client secret masked", (Object)"**********", (Object)client.getSecret());
        }
        for (IdentityProviderRepresentation idp : rep.getIdentityProviders()) {
            Assert.assertEquals((String)"IdentityProvider clientSecret masked", (Object)"**********", idp.getConfig().get("clientSecret"));
        }
        Assert.assertEquals((String)"SMTP password masked", (Object)"**********", rep.getSmtpServer().get("password"));
        MultivaluedHashMap components = rep.getComponents();
        List keys = (List)components.get((Object)"org.keycloak.keys.KeyProvider");
        Assert.assertNotNull((String)"Keys not null", (Object)keys);
        Assert.assertTrue((String)"At least one key returned", (keys.size() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (ComponentExportRepresentation component : keys) {
            if (!"rsa".equals(component.getProviderId())) continue;
            Assert.assertEquals((String)"RSA KeyProvider privateKey masked", (Object)"**********", (Object)component.getConfig().getFirst((Object)"privateKey"));
            found = true;
        }
        Assert.assertTrue((String)"Found rsa private key", (boolean)found);
        List userStorage = (List)components.get((Object)"org.keycloak.storage.UserStorageProvider");
        Assert.assertNotNull((String)"UserStorageProvider not null", (Object)userStorage);
        Assert.assertTrue((String)"At least one UserStorageProvider returned", (userStorage.size() > 0 ? 1 : 0) != 0);
        found = false;
        for (ComponentExportRepresentation component : userStorage) {
            if (!"ldap".equals(component.getProviderId())) continue;
            Assert.assertEquals((String)"LDAP provider bindCredential masked", (Object)"**********", (Object)component.getConfig().getFirst((Object)"bindCredential"));
            found = true;
        }
        Assert.assertTrue((String)"Found ldap bindCredential", (boolean)found);
    }

    private void checkClientScopeMappings(Map<String, List<ScopeMappingRepresentation>> mappings) {
        Map<String, Set<String>> map = this.extractScopeMappings(mappings.get("test-app"));
        Set<String> set = map.get("test-app-scope");
        Assert.assertTrue((String)"Client test-app / test-app-scope contains customer-admin-composite-role", (boolean)set.contains("customer-admin-composite-role"));
        set = map.get("third-party");
        Assert.assertTrue((String)"Client test-app / third-party contains customer-user", (boolean)set.contains("customer-user"));
        map = this.extractScopeMappings(mappings.get("test-app-scope"));
        set = map.get("test-app-scope");
        Assert.assertTrue((String)"Client test-app-scope / test-app-scope contains test-app-allowed-by-scope", (boolean)set.contains("test-app-allowed-by-scope"));
    }

    private void checkScopeMappings(List<ScopeMappingRepresentation> scopeMappings, boolean expectOnlyOfflineAccess) {
        ScopeMappingRepresentation offlineAccessScope = scopeMappings.stream().filter(rep -> "offline_access".equals(rep.getClientScope())).findFirst().get();
        Assert.assertTrue((boolean)offlineAccessScope.getRoles().contains("offline_access"));
        if (expectOnlyOfflineAccess) {
            Assert.assertEquals((long)1L, (long)scopeMappings.size());
            return;
        }
        Map<String, Set<String>> map = this.extractScopeMappings(scopeMappings);
        Set<String> set = map.get("test-app");
        Assert.assertTrue((String)"Client test-app contains user", (boolean)set.contains("user"));
        set = map.get("test-app-scope");
        Assert.assertTrue((String)"Client test-app contains user", (boolean)set.contains("user"));
        Assert.assertTrue((String)"Client test-app contains admin", (boolean)set.contains("admin"));
        set = map.get("third-party");
        Assert.assertTrue((String)"Client test-app contains third-party", (boolean)set.contains("user"));
    }

    private Map<String, Set<String>> extractScopeMappings(List<ScopeMappingRepresentation> scopeMappings) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (ScopeMappingRepresentation r : scopeMappings) {
            map.put(r.getClient(), r.getRoles());
        }
        return map;
    }

    private void checkClientRoles(Map<String, List<RoleRepresentation>> clientRoles) {
        Map<String, RoleRepresentation> roles = this.collectRoles(clientRoles.get("test-app"));
        Assert.assertTrue((String)"Client role customer-admin for test-app", (boolean)roles.containsKey("customer-admin"));
        Assert.assertTrue((String)"Client role sample-client-role for test-app", (boolean)roles.containsKey("sample-client-role"));
        Assert.assertTrue((String)"Client role customer-user for test-app", (boolean)roles.containsKey("customer-user"));
        Assert.assertTrue((String)"Client role customer-admin-composite-role for test-app", (boolean)roles.containsKey("customer-admin-composite-role"));
        RoleRepresentation.Composites cmp = roles.get("customer-admin-composite-role").getComposites();
        Assert.assertTrue((String)"customer-admin-composite-role / realm / customer-user-premium", (boolean)cmp.getRealm().contains("customer-user-premium"));
        Assert.assertTrue((String)"customer-admin-composite-role / client['test-app'] / customer-admin", (boolean)((List)cmp.getClient().get("test-app")).contains("customer-admin"));
        roles = this.collectRoles(clientRoles.get("test-app-scope"));
        Assert.assertTrue((String)"Client role test-app-disallowed-by-scope for test-app-scope", (boolean)roles.containsKey("test-app-disallowed-by-scope"));
        Assert.assertTrue((String)"Client role test-app-allowed-by-scope for test-app-scope", (boolean)roles.containsKey("test-app-allowed-by-scope"));
        roles = this.collectRoles(clientRoles.get("test-app-service-account"));
        Assert.assertThat((String)"Client roles are OK for test-app-service-account", roles.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"test-app-service-account", "test-app-service-account-parent", "test-app-service-account-child"}));
    }

    private Map<String, RoleRepresentation> collectRoles(List<RoleRepresentation> roles) {
        HashMap<String, RoleRepresentation> map = new HashMap<String, RoleRepresentation>();
        if (roles == null) {
            return map;
        }
        for (RoleRepresentation r : roles) {
            map.put(r.getName(), r);
        }
        return map;
    }

    private void checkClients(List<ClientRepresentation> clients) {
        HashSet<String> set = new HashSet<String>();
        for (ClientRepresentation c : clients) {
            set.add(c.getClientId());
        }
        Assert.assertTrue((String)"Client test-app", (boolean)set.contains("test-app"));
        Assert.assertTrue((String)"Client test-app-scope", (boolean)set.contains("test-app-scope"));
        Assert.assertTrue((String)"Client third-party", (boolean)set.contains("third-party"));
    }

    private void checkRealmRoles(List<RoleRepresentation> realmRoles) {
        HashSet<String> set = new HashSet<String>();
        for (RoleRepresentation r : realmRoles) {
            set.add(r.getName());
        }
        Assert.assertTrue((String)"Role sample-realm-role", (boolean)set.contains("sample-realm-role"));
        Assert.assertTrue((String)"Role realm-composite-role", (boolean)set.contains("realm-composite-role"));
        Assert.assertTrue((String)"Role customer-user-premium", (boolean)set.contains("customer-user-premium"));
        Assert.assertTrue((String)"Role admin", (boolean)set.contains("admin"));
        Assert.assertTrue((String)"Role user", (boolean)set.contains("user"));
    }

    private void checkGroups(List<GroupRepresentation> groups) {
        HashSet<String> set = new HashSet<String>();
        for (GroupRepresentation g : groups) {
            this.compileGroups(set, g);
        }
        Assert.assertTrue((String)"Group /roleRichGroup", (boolean)set.contains("/roleRichGroup"));
        Assert.assertTrue((String)"Group /roleRichGroup/level2group", (boolean)set.contains("/roleRichGroup/level2group"));
        Assert.assertTrue((String)"Group /topGroup", (boolean)set.contains("/topGroup"));
        Assert.assertTrue((String)"Group /topGroup/level2group", (boolean)set.contains("/topGroup/level2group"));
    }

    private void compileGroups(Set<String> found, GroupRepresentation g) {
        found.add(g.getPath());
        if (g.getSubGroups() != null) {
            for (GroupRepresentation s : g.getSubGroups()) {
                this.compileGroups(found, s);
            }
        }
    }

    private void checkDefaultRoles(List<String> defaultRoles) {
        HashSet<String> roles = new HashSet<String>(defaultRoles);
        Assert.assertTrue((String)"Default role 'uma_authorization'", (boolean)roles.contains("uma_authorization"));
        Assert.assertTrue((String)"Default role 'offline_access'", (boolean)roles.contains("offline_access"));
        Assert.assertTrue((String)"Default role 'user'", (boolean)roles.contains("user"));
    }
}

