/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.testsuite.admin.event.AbstractEventTest;

public class EventConfigTest
extends AbstractEventTest {
    @Test
    public void defaultEventConfigTest() {
        Assert.assertFalse((boolean)this.configRep.isAdminEventsDetailsEnabled());
        Assert.assertFalse((boolean)this.configRep.isAdminEventsEnabled());
        Assert.assertFalse((boolean)this.configRep.isEventsEnabled());
        List eventListeners = this.configRep.getEventsListeners();
        Assert.assertEquals((long)1L, (long)eventListeners.size());
        Assert.assertEquals((Object)"jboss-logging", eventListeners.get(0));
    }

    @Test
    public void enableEventsTest() {
        this.enableEvents();
        Assert.assertTrue((boolean)this.configRep.isEventsEnabled());
        Assert.assertTrue((boolean)this.configRep.isAdminEventsEnabled());
    }

    @Test
    public void addRemoveListenerTest() {
        this.configRep.setEventsListeners(Collections.EMPTY_LIST);
        this.saveConfig();
        Assert.assertEquals((long)0L, (long)this.configRep.getEventsListeners().size());
        this.configRep.setEventsListeners(Arrays.asList("email"));
        this.saveConfig();
        List eventListeners = this.configRep.getEventsListeners();
        Assert.assertEquals((long)1L, (long)eventListeners.size());
        Assert.assertEquals((Object)"email", eventListeners.get(0));
    }

    @Test
    public void loginEventSettingsTest() {
        this.enableEvents();
        Assert.assertTrue((boolean)this.hasEventType("LOGIN"));
        Assert.assertTrue((boolean)this.hasEventType("LOGOUT"));
        Assert.assertTrue((boolean)this.hasEventType("CLIENT_DELETE_ERROR"));
        int defaultEventCount = this.configRep.getEnabledEventTypes().size();
        this.configRep.setEnabledEventTypes(Arrays.asList("CLIENT_DELETE", "CLIENT_DELETE_ERROR"));
        this.saveConfig();
        List enabledEventTypes = this.configRep.getEnabledEventTypes();
        Assert.assertEquals((long)2L, (long)enabledEventTypes.size());
        this.configRep.setEnabledEventTypes(Collections.EMPTY_LIST);
        this.saveConfig();
        Assert.assertEquals((long)defaultEventCount, (long)this.configRep.getEnabledEventTypes().size());
    }

    private boolean hasEventType(String eventType) {
        for (String event : this.configRep.getEnabledEventTypes()) {
            if (!eventType.equals(event)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void includeRepresentationTest() {
        this.enableEvents();
        Assert.assertTrue((boolean)this.configRep.isAdminEventsEnabled());
        Assert.assertFalse((boolean)this.configRep.isAdminEventsDetailsEnabled());
        this.configRep.setAdminEventsDetailsEnabled(Boolean.TRUE);
        this.saveConfig();
        Assert.assertTrue((boolean)this.configRep.isAdminEventsDetailsEnabled());
    }

    @Test
    public void setLoginEventExpirationTest() {
        this.enableEvents();
        Assert.assertNull((Object)this.configRep.getEventsExpiration());
        Long oneHour = 3600L;
        this.configRep.setEventsExpiration(oneHour);
        this.saveConfig();
        Assert.assertEquals((Object)oneHour, (Object)this.configRep.getEventsExpiration());
    }
}

