/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.concurrency;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.concurrency.AbstractConcurrencyTest;
import org.keycloak.testsuite.util.UserBuilder;

public class ConcurrencyTest
extends AbstractConcurrencyTest {
    public void concurrentTest(AbstractConcurrencyTest.KeycloakRunnable ... tasks) throws Throwable {
        System.out.println("***************************");
        long start = System.currentTimeMillis();
        this.run(tasks);
        long end = System.currentTimeMillis() - start;
        System.out.println("took " + end + " ms");
    }

    @Test
    @Ignore
    public void createUserAttributes() throws Throwable {
        AtomicInteger c = new AtomicInteger();
        UsersResource users = this.testRealm().users();
        UserRepresentation u = UserBuilder.create().username("attributes").build();
        Response response = users.create(u);
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        UserResource user = users.get(userId);
        this.concurrentTest((threadIndex, keycloak, realm) -> {
            UserRepresentation rep = user.toRepresentation();
            rep.singleAttribute("a-" + c.getAndIncrement(), "value");
            user.update(rep);
        });
        UserRepresentation rep = user.toRepresentation();
        Assert.assertTrue((rep.getAttributes().size() <= c.get() ? 1 : 0) != 0);
        for (Map.Entry e : rep.getAttributes().entrySet()) {
            Assert.assertEquals((long)1L, (long)((List)e.getValue()).size());
        }
    }

    @Test
    public void testAllConcurrently() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger(100000);
        this.concurrentTest(new CreateClient(uniqueCounter), new CreateRemoveClient(uniqueCounter), new CreateGroup(uniqueCounter), new CreateRole(uniqueCounter));
    }

    @Test
    public void createClient() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.concurrentTest(new CreateClient(uniqueCounter));
    }

    @Test
    public void createGroup() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.concurrentTest(new CreateGroup(uniqueCounter));
    }

    @Test
    public void createRemoveClient() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.concurrentTest(new CreateRemoveClient(uniqueCounter));
    }

    @Test
    public void createClientRole() throws Throwable {
        ClientRepresentation c = new ClientRepresentation();
        c.setClientId("client");
        Response response = this.adminClient.realm("test").clients().create(c);
        String clientId = ApiUtil.getCreatedId((Response)response);
        response.close();
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.concurrentTest(new CreateClientRole(uniqueCounter, clientId));
    }

    @Test
    public void createRole() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.run(new CreateRole(uniqueCounter));
    }

    private class CreateRole
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger uniqueCounter;

        public CreateRole(AtomicInteger uniqueCounter) {
            this.uniqueCounter = uniqueCounter;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String name = "r-" + this.uniqueCounter.getAndIncrement();
            RoleRepresentation r = new RoleRepresentation(name, null, false);
            RolesResource roles = realm.roles();
            roles.create(r);
            Assert.assertNotNull((Object)roles.get(name).toRepresentation());
        }
    }

    private class CreateClientRole
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger uniqueCounter;
        private final String clientId;

        public CreateClientRole(AtomicInteger uniqueCounter, String clientId) {
            this.uniqueCounter = uniqueCounter;
            this.clientId = clientId;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String name = "cr-" + this.uniqueCounter.getAndIncrement();
            RoleRepresentation r = new RoleRepresentation(name, null, false);
            RolesResource roles = realm.clients().get(this.clientId).roles();
            roles.create(r);
            Assert.assertNotNull((Object)roles.get(name).toRepresentation());
        }
    }

    private class CreateGroup
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger uniqueIndex;

        public CreateGroup(AtomicInteger uniqueIndex) {
            this.uniqueIndex = uniqueIndex;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String name = "g-" + this.uniqueIndex.getAndIncrement();
            GroupRepresentation c = new GroupRepresentation();
            c.setName(name);
            Response response = realm.groups().add(c);
            String id = ApiUtil.getCreatedId((Response)response);
            response.close();
            c = realm.groups().group(id).toRepresentation();
            Assert.assertNotNull((Object)c);
            Assert.assertTrue((String)("Group " + name + " [" + id + "]  not found in group list"), (boolean)realm.groups().groups().stream().map(GroupRepresentation::getName).filter(Objects::nonNull).anyMatch(name::equals));
        }
    }

    private class CreateRemoveClient
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger clientIndex;

        public CreateRemoveClient(AtomicInteger clientIndex) {
            this.clientIndex = clientIndex;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String name = "c-" + this.clientIndex.getAndIncrement();
            ClientRepresentation c = new ClientRepresentation();
            c.setClientId(name);
            ClientsResource clients = realm.clients();
            Response response = clients.create(c);
            String id = ApiUtil.getCreatedId((Response)response);
            response.close();
            ClientResource client = clients.get(id);
            c = client.toRepresentation();
            Assert.assertNotNull((Object)c);
            Assert.assertTrue((String)("Client " + name + " not found in client list"), (boolean)clients.findAll().stream().map(ClientRepresentation::getClientId).filter(Objects::nonNull).anyMatch(name::equals));
            client.remove();
            try {
                client.toRepresentation();
                Assert.fail((String)("Client " + name + " should not be found.  Should throw a 404"));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            Assert.assertFalse((String)("Client " + name + " should now not present in client list"), (boolean)clients.findAll().stream().map(ClientRepresentation::getClientId).filter(Objects::nonNull).anyMatch(name::equals));
        }
    }

    private class CreateClient
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger clientIndex;

        public CreateClient(AtomicInteger clientIndex) {
            this.clientIndex = clientIndex;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String name = "c-" + this.clientIndex.getAndIncrement();
            ClientRepresentation c = new ClientRepresentation();
            c.setClientId(name);
            Response response = realm.clients().create(c);
            String id = ApiUtil.getCreatedId((Response)response);
            response.close();
            c = realm.clients().get(id).toRepresentation();
            Assert.assertNotNull((Object)c);
            Assert.assertTrue((String)("Client " + name + " not found in client list"), (boolean)realm.clients().findAll().stream().map(ClientRepresentation::getClientId).filter(Objects::nonNull).anyMatch(name::equals));
        }
    }
}

