/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.concurrency;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.utils.tls.TLSUtils;

public abstract class AbstractConcurrencyTest
extends AbstractTestRealmKeycloakTest {
    private static final int DEFAULT_THREADS = 4;
    private static final int DEFAULT_NUMBER_OF_EXECUTIONS = 80;
    public static final String REALM_NAME = "test";
    private static final boolean SYNCHRONIZED = false;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    protected void run(KeycloakRunnable ... runnables) {
        this.run(4, 80, runnables);
    }

    protected void run(int numThreads, int totalNumberOfExecutions, KeycloakRunnable ... runnables) {
        AbstractConcurrencyTest.run(numThreads, totalNumberOfExecutions, this, runnables);
    }

    public static void run(int numThreads, int totalNumberOfExecutions, final AbstractKeycloakTest testImpl, KeycloakRunnable ... runnables) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        ThreadLocal<Keycloak> keycloaks = new ThreadLocal<Keycloak>(){

            @Override
            protected Keycloak initialValue() {
                return Keycloak.getInstance((String)testImpl.getAuthServerRoot().toString(), (String)"master", (String)"admin", (String)"admin", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
            }
        };
        AtomicInteger currentThreadIndex = new AtomicInteger();
        LinkedList tasks = new LinkedList();
        ConcurrentLinkedQueue<Exception> failures = new ConcurrentLinkedQueue<Exception>();
        LinkedList<Callable<Void>> runnablesToTasks = new LinkedList<Callable<Void>>();
        Set<Keycloak> usedKeycloaks = Collections.synchronizedSet(new HashSet());
        for (KeycloakRunnable runnable : runnables) {
            runnablesToTasks.add(() -> {
                int arrayIndex = currentThreadIndex.getAndIncrement() % numThreads;
                try {
                    Keycloak keycloak = (Keycloak)keycloaks.get();
                    usedKeycloaks.add(keycloak);
                    runnable.run(arrayIndex % numThreads, keycloak, keycloak.realm(REALM_NAME));
                }
                catch (Throwable ex) {
                    failures.add((Exception)ex);
                }
                return null;
            });
        }
        for (int i = 0; i < totalNumberOfExecutions; ++i) {
            runnablesToTasks.forEach(tasks::add);
        }
        try {
            service.invokeAll(tasks);
            service.shutdown();
            service.awaitTermination(3L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            for (Keycloak keycloak : usedKeycloaks) {
                try {
                    keycloak.close();
                }
                catch (Exception e2) {
                    failures.add(e2);
                }
            }
        }
        if (!failures.isEmpty()) {
            RuntimeException ex = new RuntimeException("There were failures in threads. Failures count: " + failures.size());
            failures.forEach(ex::addSuppressed);
            failures.forEach(e -> testImpl.getLogger().error((Object)e.getMessage(), e));
            throw ex;
        }
    }

    public static interface KeycloakRunnable {
        public void run(int var1, Keycloak var2, RealmResource var3) throws Throwable;
    }
}

