/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Collections;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.PolicyResource;
import org.keycloak.admin.client.resource.RolePoliciesResource;
import org.keycloak.admin.client.resource.RolePolicyResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RolesBuilder;

public class RolePolicyManagementTest
extends AbstractPolicyManagementTest {
    @Override
    protected RealmBuilder createTestRealm() {
        return super.createTestRealm().roles(RolesBuilder.create().realmRole(new RoleRepresentation("Role A", "Role A description", false)).realmRole(new RoleRepresentation("Role B", "Role B description", false)).realmRole(new RoleRepresentation("Role C", "Role C description", false)));
    }

    @Test
    public void testCreateRealmRolePolicy() {
        AuthorizationResource authorization = this.getClient().authorization();
        RolePolicyRepresentation representation = new RolePolicyRepresentation();
        representation.setName("Realm Role Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addRole("Role A", false);
        representation.addRole("Role B", true);
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testCreateClientRolePolicy() {
        ClientResource client = this.getClient();
        AuthorizationResource authorization = client.authorization();
        RolePolicyRepresentation representation = new RolePolicyRepresentation();
        representation.setName("Realm Client Role Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        RolesResource roles = client.roles();
        roles.create(new RoleRepresentation("Client Role A", "desc", false));
        ClientRepresentation clientRep = client.toRepresentation();
        roles.create(new RoleRepresentation("Client Role B", "desc", false));
        representation.addRole("resource-server-test/Client Role A");
        representation.addClientRole(clientRep.getClientId(), "Client Role B", true);
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        RolePolicyRepresentation representation = new RolePolicyRepresentation();
        representation.setName("Update Test Role Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addRole("Role A", false);
        representation.addRole("Role B", true);
        representation.addRole("Role C", false);
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.setRoles(representation.getRoles().stream().filter(roleDefinition -> !roleDefinition.getId().equals("Resource A")).collect(Collectors.toSet()));
        RolePoliciesResource policies = authorization.policies().role();
        RolePolicyResource permission = policies.findById(representation.getId());
        permission.update(representation);
        this.assertRepresentation(representation, permission);
        for (RolePolicyRepresentation.RoleDefinition roleDefinition2 : representation.getRoles()) {
            if (roleDefinition2.getId().equals("Role B")) {
                roleDefinition2.setRequired(false);
            }
            if (!roleDefinition2.getId().equals("Role C")) continue;
            roleDefinition2.setRequired(true);
        }
        permission.update(representation);
        this.assertRepresentation(representation, permission);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        RolePolicyRepresentation representation = new RolePolicyRepresentation();
        representation.setName("Test Delete Permission");
        representation.addRole("Role A", false);
        RolePoliciesResource policies = authorization.policies().role();
        try (Response response = policies.create(representation);){
            RolePolicyRepresentation created = (RolePolicyRepresentation)response.readEntity(RolePolicyRepresentation.class);
            policies.findById(created.getId()).remove();
            RolePolicyResource removed = policies.findById(created.getId());
            try {
                removed.toRepresentation();
                Assert.fail((String)"Permission not removed");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGenericConfig() {
        AuthorizationResource authorization = this.getClient().authorization();
        RolePolicyRepresentation representation = new RolePolicyRepresentation();
        representation.setName("Test Generic Config  Permission");
        representation.addRole("Role A", false);
        RolePoliciesResource policies = authorization.policies().role();
        try (Response response = policies.create(representation);){
            RolePolicyRepresentation created = (RolePolicyRepresentation)response.readEntity(RolePolicyRepresentation.class);
            PolicyResource policy = authorization.policies().policy(created.getId());
            PolicyRepresentation genericConfig = policy.toRepresentation();
            Assert.assertNotNull((Object)genericConfig.getConfig());
            Assert.assertNotNull(genericConfig.getConfig().get("roles"));
            RoleRepresentation role = this.getRealm().roles().get("Role A").toRepresentation();
            Assert.assertTrue((boolean)((String)genericConfig.getConfig().get("roles")).contains(role.getId()));
        }
    }

    private void assertCreated(AuthorizationResource authorization, RolePolicyRepresentation representation) {
        RolePoliciesResource permissions = authorization.policies().role();
        try (Response response = permissions.create(representation);){
            RolePolicyRepresentation created = (RolePolicyRepresentation)response.readEntity(RolePolicyRepresentation.class);
            RolePolicyResource permission = permissions.findById(created.getId());
            this.assertRepresentation(representation, permission);
        }
    }

    private void assertRepresentation(RolePolicyRepresentation representation, RolePolicyResource permission) {
        RolePolicyRepresentation actual = permission.toRepresentation();
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)actual, () -> permission.resources(), () -> Collections.emptyList(), () -> permission.associatedPolicies());
        Assert.assertEquals((long)representation.getRoles().size(), (long)actual.getRoles().size());
        ClientRepresentation clientRep = this.getClient().toRepresentation();
        Assert.assertEquals((long)0L, (long)actual.getRoles().stream().filter(actualDefinition -> !representation.getRoles().stream().filter(roleDefinition -> (this.getRoleName(actualDefinition.getId()).equals(roleDefinition.getId()) || (clientRep.getClientId() + "/" + this.getRoleName(actualDefinition.getId())).equals(roleDefinition.getId())) && actualDefinition.isRequired() == roleDefinition.isRequired()).findFirst().isPresent()).count());
    }

    private String getRoleName(String id) {
        return this.getRealm().rolesById().getRole(id).getName();
    }
}

