/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.admin.client.authorization.ResourceManagementTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ResourceManagementWithAuthzClientTest
extends ResourceManagementTest {
    private AuthzClient authzClient;

    @Test
    public void testFindMatchingUri() {
        this.doCreateResource(new ResourceRepresentation("/*", Collections.emptySet(), "/*", null));
        this.doCreateResource(new ResourceRepresentation("/resources/*", Collections.emptySet(), "/resources/*", null));
        this.doCreateResource(new ResourceRepresentation("/resources-a/*", Collections.emptySet(), "/resources-a/*", null));
        this.doCreateResource(new ResourceRepresentation("/resources-b/{pattern}", Collections.emptySet(), "/resources-b/{pattern}", null));
        this.doCreateResource(new ResourceRepresentation("/resources-c/{pattern}/*", Collections.emptySet(), "/resources-c/{pattern}/*", null));
        this.doCreateResource(new ResourceRepresentation("/resources/{pattern}/{pattern}/*", Collections.emptySet(), "/resources/{pattern}/{pattern}/*", null));
        this.doCreateResource(new ResourceRepresentation("/resources/{pattern}/sub-resources/{pattern}/*", Collections.emptySet(), "/resources/{pattern}/sub-resources/{pattern}/*", null));
        this.doCreateResource(new ResourceRepresentation("/resources/{pattern}/sub-resource", Collections.emptySet(), "/resources/{pattern}/sub-resources/{pattern}/*", null));
        this.doCreateResource(new ResourceRepresentation("/rest/{version}/loader/loadTwo", Collections.emptySet(), "/rest/{version}/loader/loadTwo", null));
        this.doCreateResource(new ResourceRepresentation("/rest/{version}/loader/load", Collections.emptySet(), "/rest/{version}/loader/load", null));
        this.doCreateResource(new ResourceRepresentation("/rest/{version}/carts/{cartId}/cartactions/{actionId}", Collections.emptySet(), "/rest/{version}/carts/{cartId}/cartactions/{actionId}", null));
        this.doCreateResource(new ResourceRepresentation("/rest/v1/carts/{cartId}/cartactions/123", Collections.emptySet(), "/rest/v1/carts/{cartId}/cartactions/123", null));
        this.doCreateResource(new ResourceRepresentation("Dummy Name", Collections.emptySet(), new HashSet<String>(Arrays.asList("/dummy/605dc7ff310256017a2ec84f", "/dummy/605dc7ff310256017a2ec84f/*")), null));
        AuthzClient authzClient = this.getAuthzClient();
        List resources = authzClient.protection().resource().findByMatchingUri("/test");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/resources-a/test");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/resources-a/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/resources");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/resources/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/resources/");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/resources/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/resources-b/a");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/resources-b/{pattern}", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/resources-c/a/b");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/resources-c/{pattern}/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/resources/a/b/c");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/resources/{pattern}/{pattern}/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/resources/a/sub-resources/c/d");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/resources/{pattern}/sub-resources/{pattern}/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/v1/loader/load");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/{version}/loader/load", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/v2/carts/123/cartactions/123");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/{version}/carts/{cartId}/cartactions/{actionId}", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/v2/carts/{cartId}/cartactions/123");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/{version}/carts/{cartId}/cartactions/{actionId}", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/{version}/carts/123/cartactions/123");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/{version}/carts/{cartId}/cartactions/{actionId}", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/{version}/carts/{cartId}/cartactions/123");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/{version}/carts/{cartId}/cartactions/{actionId}", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/v1/carts/123/cartactions/123");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/v1/carts/{cartId}/cartactions/123", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/v1/carts/{cartId}/cartactions/123");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/v1/carts/{cartId}/cartactions/123", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/v1/carts/345/cartactions/123");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/v1/carts/{cartId}/cartactions/123", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/rest/v2/carts/345/cartactions/123");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/rest/{version}/carts/{cartId}/cartactions/{actionId}", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        resources = authzClient.protection().resource().findByMatchingUri("/dummy/605dc7ff310256017a2ec84f/nestedObject/605dc7fe310256017a2ec84c");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"Dummy Name", (Object)((ResourceRepresentation)resources.get(0)).getName());
    }

    @Test
    public void testUpdateUri() {
        this.doCreateResource(new ResourceRepresentation("/api/v1/*", Collections.emptySet(), "/api/v1/*", null));
        AuthzClient authzClient = this.getAuthzClient();
        List resources = authzClient.protection().resource().findByMatchingUri("/api/v1/servers");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/api/v1/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
        ((ResourceRepresentation)resources.get(0)).getUris().clear();
        ((ResourceRepresentation)resources.get(0)).getUris().add("/api/v2/*");
        authzClient.protection().resource().update((ResourceRepresentation)resources.get(0));
        resources = authzClient.protection().resource().findByMatchingUri("/api/v1/servers");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)0L, (long)resources.size());
        resources = authzClient.protection().resource().findByMatchingUri("/api/v2");
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"/api/v2/*", (Object)((ResourceRepresentation)resources.get(0)).getUri());
    }

    @Test
    public void testFindDeep() {
        ResourceRepresentation resource1 = new ResourceRepresentation("/*", new HashSet());
        resource1.addScope(new String[]{"a", "b", "c"});
        resource1.setType("type");
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("a", Arrays.asList("a"));
        attributes.put("b", Arrays.asList("b"));
        attributes.put("c", Arrays.asList("c"));
        resource1.setAttributes(attributes);
        resource1.setIconUri("icon");
        resource1.setUris(new HashSet<String>(Arrays.asList("/a", "/b", "/c")));
        ResourceRepresentation resource = this.doCreateResource(resource1);
        AuthzClient authzClient = this.getAuthzClient();
        List representations = (List)authzClient.protection().resource().find(resource.getId(), null, null, null, null, null, false, true, null, null);
        Assert.assertEquals((long)1L, (long)representations.size());
        Assert.assertEquals((Object)resource.getId(), (Object)((ResourceRepresentation)representations.get(0)).getId());
        Assert.assertEquals((Object)resource.getName(), (Object)((ResourceRepresentation)representations.get(0)).getName());
        Assert.assertEquals((Object)resource.getIconUri(), (Object)((ResourceRepresentation)representations.get(0)).getIconUri());
        Assert.assertThat((Object)resource.getUris(), (Matcher)Matchers.containsInAnyOrder((Object[])((ResourceRepresentation)representations.get(0)).getUris().toArray()));
        Assert.assertThat(resource.getAttributes().entrySet(), (Matcher)Matchers.containsInAnyOrder((Object[])((ResourceRepresentation)representations.get(0)).getAttributes().entrySet().toArray()));
    }

    @Override
    protected ResourceRepresentation doCreateResource(ResourceRepresentation newResource) {
        ResourceRepresentation resource = this.toResourceRepresentation(newResource);
        AuthzClient authzClient = this.getAuthzClient();
        ResourceRepresentation response = authzClient.protection().resource().create(resource);
        return this.toResourceRepresentation(authzClient, response.getId());
    }

    @Override
    protected ResourceRepresentation doUpdateResource(ResourceRepresentation resource) {
        AuthzClient authzClient = this.getAuthzClient();
        authzClient.protection().resource().update(this.toResourceRepresentation(resource));
        return this.toResourceRepresentation(authzClient, resource.getId());
    }

    @Override
    protected void doRemoveResource(ResourceRepresentation resource) {
        this.getAuthzClient().protection().resource().delete(resource.getId());
    }

    private ResourceRepresentation toResourceRepresentation(AuthzClient authzClient, String id) {
        ResourceRepresentation created = authzClient.protection().resource().findById(id);
        ResourceRepresentation resourceRepresentation = new ResourceRepresentation();
        resourceRepresentation.setId(created.getId());
        resourceRepresentation.setName(created.getName());
        resourceRepresentation.setIconUri(created.getIconUri());
        resourceRepresentation.setUris(created.getUris());
        resourceRepresentation.setType(created.getType());
        resourceRepresentation.setOwner(created.getOwner());
        resourceRepresentation.setScopes(created.getScopes().stream().map(scopeRepresentation -> {
            ScopeRepresentation scope = new ScopeRepresentation();
            scope.setId(scopeRepresentation.getId());
            scope.setName(scopeRepresentation.getName());
            scope.setIconUri(scopeRepresentation.getIconUri());
            return scope;
        }).collect(Collectors.toSet()));
        resourceRepresentation.setAttributes(created.getAttributes());
        return resourceRepresentation;
    }

    private ResourceRepresentation toResourceRepresentation(ResourceRepresentation newResource) {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setId(newResource.getId());
        resource.setName(newResource.getName());
        resource.setIconUri(newResource.getIconUri());
        if (newResource.getUris() != null && !newResource.getUris().isEmpty()) {
            resource.setUris(newResource.getUris());
        } else {
            resource.setUri(newResource.getUri());
        }
        resource.setType(newResource.getType());
        if (newResource.getOwner() != null) {
            resource.setOwner(newResource.getOwner().getId());
        }
        resource.setScopes(newResource.getScopes().stream().map(scopeRepresentation -> {
            ScopeRepresentation scope = new ScopeRepresentation();
            scope.setName(scopeRepresentation.getName());
            scope.setIconUri(scopeRepresentation.getIconUri());
            return scope;
        }).collect(Collectors.toSet()));
        resource.setAttributes(newResource.getAttributes());
        return resource;
    }

    private AuthzClient getAuthzClient() {
        if (this.authzClient == null) {
            this.authzClient = AuthzClient.create((InputStream)this.getClass().getResourceAsStream("/authorization-test/default-keycloak.json"));
        }
        return this.authzClient;
    }
}

