/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ResourceResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;

public class ResourceManagementTest
extends AbstractAuthorizationTest {
    @Test
    public void testCreate() {
        ResourceRepresentation newResource = this.createResource();
        Assert.assertEquals((Object)"Test Resource", (Object)newResource.getName());
        Assert.assertEquals((Object)"/test/*", (Object)newResource.getUri());
        Assert.assertEquals((Object)"test-resource", (Object)newResource.getType());
        Assert.assertEquals((Object)"icon-test-resource", (Object)newResource.getIconUri());
        Map attributes = newResource.getAttributes();
        Assert.assertEquals((long)2L, (long)attributes.size());
        Assert.assertTrue((boolean)attributes.containsKey("a"));
        Assert.assertTrue((boolean)attributes.containsKey("b"));
        Assert.assertTrue((boolean)((List)attributes.get("a")).containsAll(Arrays.asList("a1", "a2", "a3")));
        Assert.assertEquals((long)3L, (long)((List)attributes.get("a")).size());
        Assert.assertTrue((boolean)((List)attributes.get("b")).containsAll(Arrays.asList("b1")));
        Assert.assertEquals((long)1L, (long)((List)attributes.get("b")).size());
    }

    @Test
    public void failCreateWithSameName() {
        ResourceRepresentation newResource = this.createResource();
        try {
            this.doCreateResource(newResource);
            Assert.fail((String)"Can not create resources with the same name and owner");
        }
        catch (Exception e) {
            Assert.assertEquals(HttpResponseException.class, e.getCause().getClass());
            Assert.assertEquals((long)409L, (long)((HttpResponseException)HttpResponseException.class.cast(e.getCause())).getStatusCode());
        }
        newResource.setName(newResource.getName() + " Another");
        newResource = this.doCreateResource(newResource);
        Assert.assertNotNull((Object)newResource.getId());
        Assert.assertEquals((Object)"Test Resource Another", (Object)newResource.getName());
    }

    @Test
    public void failCreateWithSameNameDifferentOwner() {
        ResourceRepresentation martaResource = this.createResource("Resource A", "marta", null, null, null);
        ResourceRepresentation koloResource = this.createResource("Resource A", "kolo", null, null, null);
        Assert.assertNotNull((Object)martaResource.getId());
        Assert.assertNotNull((Object)koloResource.getId());
        Assert.assertNotEquals((Object)martaResource.getId(), (Object)koloResource.getId());
        Assert.assertEquals((long)2L, (long)this.getClientResource().authorization().resources().findByName(martaResource.getName()).size());
        List martaResources = this.getClientResource().authorization().resources().findByName(martaResource.getName(), "marta");
        Assert.assertEquals((long)1L, (long)martaResources.size());
        Assert.assertEquals((Object)martaResource.getId(), (Object)((ResourceRepresentation)martaResources.get(0)).getId());
        List koloResources = this.getClientResource().authorization().resources().findByName(martaResource.getName(), "kolo");
        Assert.assertEquals((long)1L, (long)koloResources.size());
        Assert.assertEquals((Object)koloResource.getId(), (Object)((ResourceRepresentation)koloResources.get(0)).getId());
    }

    @Test
    public void testUpdate() {
        ResourceRepresentation resource = this.createResource();
        resource.setType("changed");
        resource.setIconUri("changed");
        resource.setUri("changed");
        Map attributes = resource.getAttributes();
        attributes.remove("a");
        attributes.put("c", Arrays.asList("c1", "c2"));
        attributes.put("b", Arrays.asList("changed"));
        resource = this.doUpdateResource(resource);
        Assert.assertEquals((Object)"changed", (Object)resource.getIconUri());
        Assert.assertEquals((Object)"changed", (Object)resource.getType());
        Assert.assertEquals((Object)"changed", (Object)resource.getUri());
        attributes = resource.getAttributes();
        Assert.assertEquals((long)2L, (long)attributes.size());
        Assert.assertFalse((boolean)attributes.containsKey("a"));
        Assert.assertTrue((boolean)attributes.containsKey("b"));
        Assert.assertTrue((boolean)((List)attributes.get("b")).containsAll(Arrays.asList("changed")));
        Assert.assertEquals((long)1L, (long)((List)attributes.get("b")).size());
        Assert.assertTrue((boolean)((List)attributes.get("c")).containsAll(Arrays.asList("c1", "c2")));
        Assert.assertEquals((long)2L, (long)((List)attributes.get("c")).size());
    }

    @Test(expected=NotFoundException.class)
    public void testDelete() {
        ResourceRepresentation resource = this.createResource();
        this.doRemoveResource(resource);
        this.getClientResource().authorization().resources().resource(resource.getId()).toRepresentation();
    }

    @Test
    public void testAssociateScopes() {
        ResourceRepresentation updated = this.createResourceWithDefaultScopes();
        Assert.assertEquals((long)3L, (long)updated.getScopes().size());
        Assert.assertTrue((boolean)this.containsScope("Scope A", updated));
        Assert.assertTrue((boolean)this.containsScope("Scope B", updated));
        Assert.assertTrue((boolean)this.containsScope("Scope C", updated));
    }

    @Test
    public void testUpdateScopes() {
        ResourceRepresentation resource = this.createResourceWithDefaultScopes();
        HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>(resource.getScopes());
        Assert.assertEquals((long)3L, (long)scopes.size());
        Assert.assertTrue((boolean)scopes.removeIf(scopeRepresentation -> scopeRepresentation.getName().equals("Scope B")));
        resource.setScopes(scopes);
        ResourceRepresentation updated = this.doUpdateResource(resource);
        Assert.assertEquals((long)2L, (long)resource.getScopes().size());
        Assert.assertFalse((boolean)this.containsScope("Scope B", updated));
        Assert.assertTrue((boolean)this.containsScope("Scope A", updated));
        Assert.assertTrue((boolean)this.containsScope("Scope C", updated));
        scopes = new HashSet(updated.getScopes());
        Assert.assertTrue((boolean)scopes.removeIf(scopeRepresentation -> scopeRepresentation.getName().equals("Scope A")));
        Assert.assertTrue((boolean)scopes.removeIf(scopeRepresentation -> scopeRepresentation.getName().equals("Scope C")));
        updated.setScopes(scopes);
        updated = this.doUpdateResource(updated);
        Assert.assertEquals((long)0L, (long)updated.getScopes().size());
    }

    private ResourceRepresentation createResourceWithDefaultScopes() {
        ResourceRepresentation resource = this.createResource();
        Assert.assertEquals((long)0L, (long)resource.getScopes().size());
        HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>();
        scopes.add(this.createScope("Scope A", "").toRepresentation());
        scopes.add(this.createScope("Scope B", "").toRepresentation());
        scopes.add(this.createScope("Scope C", "").toRepresentation());
        resource.setScopes(scopes);
        return this.doUpdateResource(resource);
    }

    private boolean containsScope(String scopeName, ResourceRepresentation resource) {
        Set scopes = resource.getScopes();
        if (scopes != null) {
            for (ScopeRepresentation scope : scopes) {
                if (!scope.getName().equals(scopeName)) continue;
                return true;
            }
        }
        return false;
    }

    private ResourceRepresentation createResource() {
        return this.createResource("Test Resource", null, "/test/*", "test-resource", "icon-test-resource");
    }

    private ResourceRepresentation createResource(String name, String owner, String uri, String type, String iconUri) {
        ResourceRepresentation newResource = new ResourceRepresentation();
        newResource.setName(name);
        newResource.setUri(uri);
        newResource.setType(type);
        newResource.setIconUri(iconUri);
        newResource.setOwner(owner != null ? new ResourceOwnerRepresentation(owner) : null);
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("a", Arrays.asList("a1", "a2", "a3"));
        attributes.put("b", Arrays.asList("b1"));
        newResource.setAttributes(attributes);
        return this.doCreateResource(newResource);
    }

    protected ResourceRepresentation doCreateResource(ResourceRepresentation newResource) {
        ResourcesResource resources = this.getClientResource().authorization().resources();
        try (Response response = resources.create(newResource);){
            int status = response.getStatus();
            if (status != Response.Status.CREATED.getStatusCode()) {
                throw new RuntimeException((Throwable)new HttpResponseException("Error", status, "", null));
            }
            ResourceRepresentation stored = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
            ResourceRepresentation resourceRepresentation = resources.resource(stored.getId()).toRepresentation();
            return resourceRepresentation;
        }
    }

    protected ResourceRepresentation doUpdateResource(ResourceRepresentation resource) {
        ResourcesResource resources = this.getClientResource().authorization().resources();
        ResourceResource existing = resources.resource(resource.getId());
        existing.update(resource);
        return resources.resource(resource.getId()).toRepresentation();
    }

    protected void doRemoveResource(ResourceRepresentation resource) {
        ResourcesResource resources = this.getClientResource().authorization().resources();
        resources.resource(resource.getId()).remove();
    }
}

