/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.cert.X509Certificate;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.AuthorizationContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.common.Profile;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
public class PolicyEnforcerClaimsTest
extends AbstractKeycloakTest {
    protected static final String REALM_NAME = "authz-test";

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name(REALM_NAME).roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build()).realmRole(RoleBuilder.create().name("uma_protection").build())).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization", "uma_protection").role("resource-server-test", "uma_protection")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId("resource-server-uma-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-uma-test").defaultRoles("uma_protection").directAccessGrants()).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).client(ClientBuilder.create().clientId("public-client-test").publicClient().redirectUris("http://localhost:8180/auth/realms/master/app/auth/*", "https://localhost:8543/auth/realms/master/app/auth/*").directAccessGrants()).build());
    }

    @Test
    public void testEnforceUMAAccessWithClaimsUsingBearerToken() {
        this.initAuthorizationSettings(this.getClientResource("resource-server-uma-test"));
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-uma-claims-test.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("withdrawal.amount", Arrays.asList("50"));
        AuthzClient authzClient = this.getAuthzClient("enforcer-uma-claims-test.json");
        String token = authzClient.obtainAccessToken("marta", "password").getToken();
        headers.put("Authorization", Arrays.asList("Bearer " + token));
        AuthorizationContext context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", "POST", token, headers, parameters));
        Assert.assertFalse((boolean)context.isGranted());
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(this.extractTicket(headers));
        AuthorizationResponse response = authzClient.authorization("marta", "password").authorize(request);
        token = response.getToken();
        Assert.assertNotNull((Object)token);
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", "POST", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("200"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", "POST", token, headers, parameters));
        Assert.assertFalse((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("50"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", "POST", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("10"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", "POST", token, headers, parameters));
        request = new AuthorizationRequest();
        request.setTicket(this.extractTicket(headers));
        response = authzClient.authorization("marta", "password").authorize(request);
        token = response.getToken();
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", "POST", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        request = new AuthorizationRequest();
        request.setTicket(this.extractTicket(headers));
        response = authzClient.authorization("marta", "password").authorize(request);
        token = response.getToken();
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", "GET", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        Assert.assertEquals((long)1L, (long)context.getPermissions().size());
        Permission permission = (Permission)context.getPermissions().get(0);
        Assert.assertEquals((Object)parameters.get("withdrawal.amount").get(0), ((Set)permission.getClaims().get("withdrawal.amount")).iterator().next());
    }

    @Test
    public void testEnforceEntitlementAccessWithClaimsWithoutBearerToken() {
        this.initAuthorizationSettings(this.getClientResource("resource-server-test"));
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-entitlement-claims-test.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        AuthzClient authzClient = this.getAuthzClient("enforcer-entitlement-claims-test.json");
        String token = authzClient.obtainAccessToken("marta", "password").getToken();
        AuthorizationContext context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertFalse((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("50"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        Assert.assertEquals((long)1L, (long)context.getPermissions().size());
        Permission permission = (Permission)context.getPermissions().get(0);
        Assert.assertEquals((Object)parameters.get("withdrawal.amount").get(0), ((Set)permission.getClaims().get("withdrawal.amount")).iterator().next());
        parameters.put("withdrawal.amount", Arrays.asList("200"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertFalse((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("50"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("10"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        Assert.assertEquals((long)1L, (long)context.getPermissions().size());
        permission = (Permission)context.getPermissions().get(0);
        Assert.assertEquals((Object)parameters.get("withdrawal.amount").get(0), ((Set)permission.getClaims().get("withdrawal.amount")).iterator().next());
    }

    @Test
    public void testEnforceEntitlementAccessWithClaimsWithBearerToken() {
        this.initAuthorizationSettings(this.getClientResource("resource-server-test"));
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-entitlement-claims-test.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        AuthzClient authzClient = this.getAuthzClient("enforcer-entitlement-claims-test.json");
        String token = authzClient.obtainAccessToken("marta", "password").getToken();
        headers.put("Authorization", Arrays.asList("Bearer " + token));
        AuthorizationContext context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertFalse((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("50"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("200"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertFalse((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("50"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("10"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
    }

    @Test
    public void testEnforceEntitlementAccessWithClaimsWithBearerTokenFromPublicClient() {
        this.initAuthorizationSettings(this.getClientResource("resource-server-test"));
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-entitlement-claims-test.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        headers.put("Authorization", Arrays.asList("Bearer " + token));
        AuthorizationContext context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertFalse((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("50"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("200"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertFalse((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("50"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
        parameters.put("withdrawal.amount", Arrays.asList("10"));
        context = policyEnforcer.enforce(this.createHttpFacade("/api/bank/account/1/withdrawal", token, headers, parameters));
        Assert.assertTrue((boolean)context.isGranted());
    }

    private String extractTicket(HashMap<String, List<String>> headers) {
        List<String> wwwAuthenticateHeader = headers.get("WWW-Authenticate");
        Assert.assertNotNull(wwwAuthenticateHeader);
        Assert.assertFalse((boolean)wwwAuthenticateHeader.isEmpty());
        String wwwAuthenticate = wwwAuthenticateHeader.get(0);
        return wwwAuthenticate.substring(wwwAuthenticate.indexOf("ticket=") + "ticket=\"".length(), wwwAuthenticate.lastIndexOf(34));
    }

    private void initAuthorizationSettings(ClientResource clientResource) {
        if (clientResource.authorization().resources().findByName("Bank Account").isEmpty()) {
            JSPolicyRepresentation policy = new JSPolicyRepresentation();
            policy.setName("Withdrawal Limit Policy");
            StringBuilder code = new StringBuilder();
            code.append("var context = $evaluation.getContext();");
            code.append("var attributes = context.getAttributes();");
            code.append("var withdrawalAmount = attributes.getValue('withdrawal.amount');");
            code.append("if (withdrawalAmount && withdrawalAmount.asDouble(0) <= 100) {");
            code.append("   $evaluation.grant();");
            code.append("}");
            policy.setCode(code.toString());
            clientResource.authorization().policies().js().create(policy).close();
            this.createResource(clientResource, "Bank Account", "/api/bank/account/{id}/withdrawal", "withdrawal");
            ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
            permission.setName("Withdrawal Permission");
            permission.addScope(new String[]{"withdrawal"});
            permission.addPolicy(new String[]{policy.getName()});
            clientResource.authorization().permissions().scope().create(permission).close();
        }
    }

    private InputStream getAdapterConfiguration(String fileName) {
        try {
            return PolicyEnforcerClaimsTest.httpsAwareConfigurationStream(this.getClass().getResourceAsStream("/authorization-test/" + fileName));
        }
        catch (IOException e) {
            throw new AssertionError("Could not load keycloak configuration", e);
        }
    }

    private ResourceRepresentation createResource(ClientResource clientResource, String name, String uri, String ... scopes) {
        ResourceRepresentation representation = new ResourceRepresentation();
        representation.setName(name);
        representation.setUri(uri);
        representation.setScopes(Arrays.asList(scopes).stream().map(ScopeRepresentation::new).collect(Collectors.toSet()));
        try (Response response = clientResource.authorization().resources().create(representation);){
            representation.setId(((ResourceRepresentation)response.readEntity(ResourceRepresentation.class)).getId());
            ResourceRepresentation resourceRepresentation = representation;
            return resourceRepresentation;
        }
    }

    private ClientResource getClientResource(String name) {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation representation = (ClientRepresentation)clients.findByClientId(name).get(0);
        return clients.get(representation.getId());
    }

    private OIDCHttpFacade createHttpFacade(final String path, final String method, final String token, final Map<String, List<String>> headers, final Map<String, List<String>> parameters, final InputStream requestBody) {
        return new OIDCHttpFacade(){
            HttpFacade.Request request;
            HttpFacade.Response response;

            public KeycloakSecurityContext getSecurityContext() {
                AccessToken accessToken;
                try {
                    accessToken = (AccessToken)new JWSInput(token).readJsonContent(AccessToken.class);
                }
                catch (JWSInputException cause) {
                    throw new RuntimeException(cause);
                }
                return new KeycloakSecurityContext(token, accessToken, null, null);
            }

            public HttpFacade.Request getRequest() {
                if (this.request == null) {
                    this.request = PolicyEnforcerClaimsTest.this.createHttpRequest(path, method, headers, parameters, requestBody);
                }
                return this.request;
            }

            public HttpFacade.Response getResponse() {
                if (this.response == null) {
                    this.response = PolicyEnforcerClaimsTest.this.createHttpResponse(headers);
                }
                return this.response;
            }

            public X509Certificate[] getCertificateChain() {
                return new X509Certificate[0];
            }
        };
    }

    private OIDCHttpFacade createHttpFacade(String path, String token, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
        return this.createHttpFacade(path, null, token, headers, parameters, null);
    }

    private OIDCHttpFacade createHttpFacade(String path, String method, String token, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
        return this.createHttpFacade(path, method, token, headers, parameters, null);
    }

    private HttpFacade.Response createHttpResponse(final Map<String, List<String>> headers) {
        return new HttpFacade.Response(){
            private int status;

            public void setStatus(int status) {
                this.status = status;
            }

            public void addHeader(String name, String value) {
                this.setHeader(name, value);
            }

            public void setHeader(String name, String value) {
                headers.put(name, Arrays.asList(value));
            }

            public void resetCookie(String name, String path) {
            }

            public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            }

            public OutputStream getOutputStream() {
                return null;
            }

            public void sendError(int code) {
            }

            public void sendError(int code, String message) {
            }

            public void end() {
            }
        };
    }

    private HttpFacade.Request createHttpRequest(final String path, final String method, final Map<String, List<String>> headers, final Map<String, List<String>> parameters, final InputStream requestBody) {
        return new HttpFacade.Request(){
            private InputStream inputStream;

            public String getMethod() {
                return method == null ? "GET" : method;
            }

            public String getURI() {
                return path;
            }

            public String getRelativePath() {
                return path;
            }

            public boolean isSecure() {
                return true;
            }

            public String getFirstParam(String param) {
                List values = parameters.getOrDefault(param, Collections.emptyList());
                if (!values.isEmpty()) {
                    return (String)values.get(0);
                }
                return null;
            }

            public String getQueryParamValue(String param) {
                return this.getFirstParam(param);
            }

            public HttpFacade.Cookie getCookie(String cookieName) {
                return null;
            }

            public String getHeader(String name) {
                List<String> headers2 = this.getHeaders(name);
                if (!headers2.isEmpty()) {
                    return headers2.get(0);
                }
                return null;
            }

            public List<String> getHeaders(String name) {
                return headers.getOrDefault(name, Collections.emptyList());
            }

            public InputStream getInputStream() {
                return this.getInputStream(false);
            }

            public InputStream getInputStream(boolean buffer) {
                if (requestBody == null) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                if (this.inputStream != null) {
                    return this.inputStream;
                }
                if (buffer) {
                    this.inputStream = new BufferedInputStream(requestBody);
                    return this.inputStream;
                }
                return requestBody;
            }

            public String getRemoteAddr() {
                return "user-remote-addr";
            }

            public void setError(AuthenticationError error) {
            }

            public void setError(LogoutError error) {
            }
        };
    }

    protected AuthzClient getAuthzClient(String fileName) {
        return AuthzClient.create((InputStream)this.getAdapterConfiguration(fileName));
    }
}

