/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Collections;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.JSPoliciesResource;
import org.keycloak.admin.client.resource.JSPolicyResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;

@EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
public class JSPolicyManagementTest
extends AbstractPolicyManagementTest {
    @Test
    public void testCreate() {
        AuthorizationResource authorization = this.getClient().authorization();
        JSPolicyRepresentation representation = new JSPolicyRepresentation();
        representation.setName("JS Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.setCode("$evaluation.grant();");
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        JSPolicyRepresentation representation = new JSPolicyRepresentation();
        representation.setName("Update JS Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.setCode("$evaluation.grant();");
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.setCode("$evaluation.deny()");
        JSPoliciesResource policies = authorization.policies().js();
        JSPolicyResource permission = policies.findById(representation.getId());
        permission.update(representation);
        this.assertRepresentation(representation, permission);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        JSPolicyRepresentation representation = new JSPolicyRepresentation();
        representation.setName("Test Delete Policy");
        representation.setCode("$evaluation.grant()");
        JSPoliciesResource policies = authorization.policies().js();
        try (Response response = policies.create(representation);){
            JSPolicyRepresentation created = (JSPolicyRepresentation)response.readEntity(JSPolicyRepresentation.class);
            policies.findById(created.getId()).remove();
            JSPolicyResource removed = policies.findById(created.getId());
            try {
                removed.toRepresentation();
                Assert.fail((String)"Permission not removed");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private void assertCreated(AuthorizationResource authorization, JSPolicyRepresentation representation) {
        JSPoliciesResource permissions = authorization.policies().js();
        try (Response response = permissions.create(representation);){
            JSPolicyRepresentation created = (JSPolicyRepresentation)response.readEntity(JSPolicyRepresentation.class);
            JSPolicyResource permission = permissions.findById(created.getId());
            this.assertRepresentation(representation, permission);
        }
    }

    private void assertRepresentation(JSPolicyRepresentation representation, JSPolicyResource permission) {
        JSPolicyRepresentation actual = permission.toRepresentation();
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)actual, () -> permission.resources(), () -> Collections.emptyList(), () -> permission.associatedPolicies());
        Assert.assertEquals((Object)representation.getCode(), (Object)actual.getCode());
    }
}

