/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

public class ImportAuthorizationSettingsTest
extends AbstractAuthorizationTest {
    @Before
    public void createRole() {
        ClientResource clientResource = this.getClientResource();
        RoleRepresentation role = new RoleRepresentation();
        role.setName("admin");
        clientResource.roles().create(role);
        this.testRealmResource().users().create(UserBuilder.create().username("alice").build());
    }

    @Test
    public void testImportUnorderedSettings() throws Exception {
        ClientResource clientResource = this.getClientResource();
        ResourceServerRepresentation toImport = (ResourceServerRepresentation)JsonSerialization.readValue((InputStream)this.getClass().getResourceAsStream("/authorization-test/import-authorization-unordered-settings.json"), ResourceServerRepresentation.class);
        this.realmsResouce().realm(this.getRealmId()).roles().create(new RoleRepresentation("user", null, false));
        clientResource.roles().create(new RoleRepresentation("manage-albums", null, false));
        AuthorizationResource authorizationResource = clientResource.authorization();
        authorizationResource.importSettings(toImport);
        Assert.assertEquals((long)13L, (long)authorizationResource.policies().policies().size());
    }
}

