/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.PoliciesResource;
import org.keycloak.admin.client.resource.PolicyResource;
import org.keycloak.admin.client.resource.ResourceResource;
import org.keycloak.admin.client.resource.ResourceScopeResource;
import org.keycloak.admin.client.resource.ResourceScopesResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyProviderRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;

public class GenericPolicyManagementTest
extends AbstractAuthorizationTest {
    private static final String[] EXPECTED_BUILTIN_POLICY_PROVIDERS = new String[]{"test", "user", "role", "js", "time", "aggregate", "scope", "resource"};

    @Test
    public void testCreate() {
        PolicyRepresentation newPolicy = this.createTestingPolicy().toRepresentation();
        Assert.assertEquals((Object)"Test Generic Policy", (Object)newPolicy.getName());
        Assert.assertEquals((Object)"scope", (Object)newPolicy.getType());
        Assert.assertEquals((Object)Logic.POSITIVE, (Object)newPolicy.getLogic());
        Assert.assertEquals((Object)DecisionStrategy.UNANIMOUS, (Object)newPolicy.getDecisionStrategy());
        Assert.assertEquals((Object)"configuration for A", newPolicy.getConfig().get("configA"));
        Assert.assertEquals((Object)"configuration for B", newPolicy.getConfig().get("configB"));
        Assert.assertEquals((Object)"configuration for C", newPolicy.getConfig().get("configC"));
        List policies = this.getClientResource().authorization().policies().policies();
        Assert.assertEquals((long)6L, (long)policies.size());
        this.assertAssociatedPolicy("Test Associated A", newPolicy);
        this.assertAssociatedPolicy("Test Associated B", newPolicy);
        this.assertAssociatedPolicy("Test Associated C", newPolicy);
        this.assertAssociatedResource("Test Resource A", newPolicy);
        this.assertAssociatedResource("Test Resource B", newPolicy);
        this.assertAssociatedResource("Test Resource C", newPolicy);
        this.assertAssociatedScope("Test Scope A", newPolicy);
        this.assertAssociatedScope("Test Scope B", newPolicy);
        this.assertAssociatedScope("Test Scope C", newPolicy);
    }

    @Test
    public void testUpdate() {
        PolicyResource policyResource = this.createTestingPolicy();
        PolicyRepresentation policy = policyResource.toRepresentation();
        policy.setName("changed");
        policy.setLogic(Logic.NEGATIVE);
        policy.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        policy.getConfig().put("configA", "changed configuration for A");
        policy.getConfig().remove("configB");
        policy.getConfig().put("configC", "changed configuration for C");
        policyResource.update(policy);
        policy = policyResource.toRepresentation();
        Assert.assertEquals((Object)"changed", (Object)policy.getName());
        Assert.assertEquals((Object)Logic.NEGATIVE, (Object)policy.getLogic());
        Assert.assertEquals((Object)DecisionStrategy.AFFIRMATIVE, (Object)policy.getDecisionStrategy());
        Assert.assertEquals((Object)"changed configuration for A", policy.getConfig().get("configA"));
        Assert.assertNull(policy.getConfig().get("configB"));
        Assert.assertEquals((Object)"changed configuration for C", policy.getConfig().get("configC"));
        Map config = policy.getConfig();
        config.put("applyPolicies", this.buildConfigOption(this.findPolicyByName("Test Associated C").getId()));
        config.put("resources", this.buildConfigOption(this.findResourceByName("Test Resource B").getId()));
        config.put("scopes", this.buildConfigOption(this.findScopeByName("Test Scope A").getId()));
        policyResource.update(policy);
        policy = policyResource.toRepresentation();
        config = policy.getConfig();
        this.assertAssociatedPolicy("Test Associated C", policy);
        List associatedPolicies = this.getClientResource().authorization().policies().policy(policy.getId()).associatedPolicies();
        Assert.assertFalse((boolean)associatedPolicies.stream().filter(associated -> associated.getId().equals(this.findPolicyByName("Test Associated A").getId())).findFirst().isPresent());
        Assert.assertFalse((boolean)associatedPolicies.stream().filter(associated -> associated.getId().equals(this.findPolicyByName("Test Associated B").getId())).findFirst().isPresent());
        this.assertAssociatedResource("Test Resource B", policy);
        List resources = policyResource.resources();
        Assert.assertFalse((boolean)resources.contains(this.findResourceByName("Test Resource A")));
        Assert.assertFalse((boolean)resources.contains(this.findResourceByName("Test Resource C")));
        this.assertAssociatedScope("Test Scope A", policy);
        List scopes = this.getClientResource().authorization().policies().policy(policy.getId()).scopes();
        Assert.assertFalse((boolean)scopes.contains(this.findScopeByName("Test Scope B").getId()));
        Assert.assertFalse((boolean)scopes.contains(this.findScopeByName("Test Scope C").getId()));
    }

    @Test
    public void testDefaultPolicyProviders() {
        List providers = this.getClientResource().authorization().policies().policyProviders().stream().map(PolicyProviderRepresentation::getType).collect(Collectors.toList());
        Assert.assertFalse((boolean)providers.isEmpty());
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList(EXPECTED_BUILTIN_POLICY_PROVIDERS));
        Assert.assertTrue((boolean)providers.containsAll(expected));
    }

    @Test
    public void testQueryPolicyByIdAllFields() {
        PolicyResource policy = this.createTestingPolicy();
        PolicyRepresentation representation = policy.toRepresentation("*");
        Set resources = representation.getResourcesData();
        Assert.assertEquals((long)3L, (long)resources.size());
        representation = policy.toRepresentation();
        Assert.assertNull((Object)representation.getResourcesData());
    }

    @Test
    public void testQueryPolicyAllFields() {
        AuthorizationResource authorization = this.getClientResource().authorization();
        authorization.resources().create(new ResourceRepresentation("Resource A", new String[0]));
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("Permission A");
        permission.addResource("Resource A");
        authorization.permissions().resource().create(permission);
        List policies = authorization.policies().policies(null, "Permission A", null, null, null, Boolean.valueOf(true), null, "*", Integer.valueOf(-1), Integer.valueOf(-1));
        Assert.assertEquals((long)1L, (long)policies.size());
        Assert.assertEquals((long)1L, (long)((PolicyRepresentation)policies.get(0)).getResourcesData().size());
        policies = authorization.policies().policies(null, "Permission A", null, null, null, Boolean.valueOf(true), null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assert.assertEquals((long)1L, (long)policies.size());
        Assert.assertNull((Object)((PolicyRepresentation)policies.get(0)).getResourcesData());
    }

    private PolicyResource createTestingPolicy() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("configA", "configuration for A");
        config.put("configB", "configuration for B");
        config.put("configC", "configuration for C");
        config.put("applyPolicies", this.buildConfigOption(this.createPolicy("Test Associated A", new HashMap<String, String>()).toRepresentation().getId(), this.createPolicy("Test Associated B", new HashMap<String, String>()).toRepresentation().getId(), this.createPolicy("Test Associated C", new HashMap<String, String>()).toRepresentation().getId()));
        config.put("resources", this.buildConfigOption(this.createResource("Test Resource A").toRepresentation().getId(), this.createResource("Test Resource B").toRepresentation().getId(), this.createResource("Test Resource C").toRepresentation().getId()));
        config.put("scopes", this.buildConfigOption(this.createScope("Test Scope A").toRepresentation().getId(), this.createScope("Test Scope B").toRepresentation().getId(), this.createScope("Test Scope C").toRepresentation().getId()));
        return this.createPolicy("Test Generic Policy", config);
    }

    private PolicyResource createPolicy(String name, Map<String, String> config) {
        PolicyRepresentation newPolicy = new PolicyRepresentation();
        newPolicy.setName(name);
        newPolicy.setType("scope");
        newPolicy.setConfig(config);
        PoliciesResource policies = this.getClientResource().authorization().policies();
        try (Response response = policies.create(newPolicy);){
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
            PolicyRepresentation stored = (PolicyRepresentation)response.readEntity(PolicyRepresentation.class);
            PolicyResource policyResource = policies.policy(stored.getId());
            return policyResource;
        }
    }

    private ResourceResource createResource(String name) {
        ResourceRepresentation newResource = new ResourceRepresentation();
        newResource.setName(name);
        ResourcesResource resources = this.getClientResource().authorization().resources();
        try (Response response = resources.create(newResource);){
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
            ResourceRepresentation stored = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
            ResourceResource resourceResource = resources.resource(stored.getId());
            return resourceResource;
        }
    }

    private ResourceScopeResource createScope(String name) {
        ScopeRepresentation newScope = new ScopeRepresentation();
        newScope.setName(name);
        ResourceScopesResource scopes = this.getClientResource().authorization().scopes();
        try (Response response = scopes.create(newScope);){
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
            ScopeRepresentation stored = (ScopeRepresentation)response.readEntity(ScopeRepresentation.class);
            ResourceScopeResource resourceScopeResource = scopes.scope(stored.getId());
            return resourceScopeResource;
        }
    }

    private String buildConfigOption(String ... values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append("\"" + value + "\"");
        }
        return builder.insert(0, "[").append("]").toString();
    }

    private PolicyRepresentation findPolicyByName(String name) {
        return this.getClientResource().authorization().policies().policies().stream().filter(policyRepresentation -> policyRepresentation.getName().equals(name)).findFirst().orElse(null);
    }

    private ResourceRepresentation findResourceByName(String name) {
        return this.getClientResource().authorization().resources().resources().stream().filter(resource -> resource.getName().equals(name)).findFirst().orElse(null);
    }

    private ScopeRepresentation findScopeByName(String name) {
        return this.getClientResource().authorization().scopes().scopes().stream().filter(scope -> scope.getName().equals(name)).findFirst().orElse(null);
    }

    private void assertAssociatedPolicy(String associatedPolicyName, PolicyRepresentation dependentPolicy) {
        PolicyRepresentation associatedPolicy = this.findPolicyByName(associatedPolicyName);
        PoliciesResource policies = this.getClientResource().authorization().policies();
        associatedPolicy = policies.policy(associatedPolicy.getId()).toRepresentation();
        Assert.assertNotNull((Object)associatedPolicy);
        PolicyRepresentation finalAssociatedPolicy = associatedPolicy;
        PolicyResource policyResource = policies.policy(dependentPolicy.getId());
        List associatedPolicies = policyResource.associatedPolicies();
        Assert.assertTrue((boolean)associatedPolicies.stream().filter(associated -> associated.getId().equals(finalAssociatedPolicy.getId())).findFirst().isPresent());
        List dependentPolicies = policies.policy(associatedPolicy.getId()).dependentPolicies();
        Assert.assertEquals((long)1L, (long)dependentPolicies.size());
        Assert.assertEquals((Object)dependentPolicy.getId(), (Object)((PolicyRepresentation)dependentPolicies.get(0)).getId());
    }

    private void assertAssociatedResource(String resourceName, PolicyRepresentation policy) {
        ResourceRepresentation resource = this.findResourceByName(resourceName);
        Assert.assertNotNull((Object)resource);
        List resources = this.getClientResource().authorization().policies().policy(policy.getId()).resources();
        Assert.assertTrue((boolean)resources.contains(resource));
        List policies = this.getClientResource().authorization().resources().resource(resource.getId()).permissions();
        Assert.assertEquals((long)1L, (long)policies.size());
        Assert.assertTrue((boolean)policies.stream().map(AbstractPolicyRepresentation::getId).collect(Collectors.toList()).contains(policy.getId()));
    }

    private void assertAssociatedScope(String scopeName, PolicyRepresentation policy) {
        ScopeRepresentation scope = this.findScopeByName(scopeName);
        scope = this.getClientResource().authorization().scopes().scope(scope.getId()).toRepresentation();
        Assert.assertNotNull((Object)scope);
        List scopes = this.getClientResource().authorization().policies().policy(policy.getId()).scopes();
        Assert.assertTrue((boolean)scopes.stream().map(rep -> rep.getId()).collect(Collectors.toList()).contains(scope.getId()));
        List permissions = this.getClientResource().authorization().scopes().scope(scope.getId()).permissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.stream().map(AbstractPolicyRepresentation::getId).collect(Collectors.toList()).contains(policy.getId()));
    }
}

