/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.common.Profile;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.utils.io.IOUtil;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class EnforcerConfigTest
extends AbstractKeycloakTest {
    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = IOUtil.loadRealm((InputStream)this.getClass().getResourceAsStream("/authorization-test/test-authz-realm.json"));
        testRealms.add(realm);
    }

    @Test
    public void testMultiplePathsWithSameName() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getClass().getResourceAsStream("/authorization-test/enforcer-config-paths-same-name.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        Map paths = policyEnforcer.getPaths();
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((long)4L, (long)((PolicyEnforcerConfig.PathConfig)paths.values().iterator().next()).getMethods().size());
    }

    @Test
    public void testPathConfigClaimInformationPoint() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getClass().getResourceAsStream("/authorization-test/enforcer-config-path-cip.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        Map paths = policyEnforcer.getPaths();
        Assert.assertEquals((long)1L, (long)paths.size());
        PolicyEnforcerConfig.PathConfig pathConfig = (PolicyEnforcerConfig.PathConfig)paths.values().iterator().next();
        Map cipConfig = pathConfig.getClaimInformationPointConfig();
        Assert.assertEquals((long)1L, (long)cipConfig.size());
        Map claims = (Map)cipConfig.get("claims");
        Assert.assertNotNull((Object)claims);
        Assert.assertEquals((long)3L, (long)claims.size());
        Assert.assertEquals((Object)"{request.parameter['a']}", claims.get("claim-a"));
        Assert.assertEquals((Object)"{request.header['b']}", claims.get("claim-b"));
        Assert.assertEquals((Object)"{request.cookie['c']}", claims.get("claim-c"));
    }
}

