/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Collections;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientPoliciesResource;
import org.keycloak.admin.client.resource.ClientPolicyResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.PolicyResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;

public class ClientPolicyManagementTest
extends AbstractPolicyManagementTest {
    @Override
    protected RealmBuilder createTestRealm() {
        return super.createTestRealm().client(ClientBuilder.create().clientId("Client A")).client(ClientBuilder.create().clientId("Client B")).client(ClientBuilder.create().clientId("Client C")).client(ClientBuilder.create().clientId("Client D")).client(ClientBuilder.create().clientId("Client E")).client(ClientBuilder.create().clientId("Client F"));
    }

    @Test
    public void testCreate() {
        AuthorizationResource authorization = this.getClient().authorization();
        ClientPolicyRepresentation representation = new ClientPolicyRepresentation();
        representation.setName("Realm Client Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addClient(new String[]{"Client A"});
        representation.addClient(new String[]{"Client B"});
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        ClientPolicyRepresentation representation = new ClientPolicyRepresentation();
        representation.setName("Update Test Client Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addClient(new String[]{"Client A"});
        representation.addClient(new String[]{"Client B"});
        representation.addClient(new String[]{"Client C"});
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.setClients(representation.getClients().stream().filter(userName -> !userName.equals("Client A")).collect(Collectors.toSet()));
        ClientPoliciesResource policies = authorization.policies().client();
        ClientPolicyResource permission = policies.findById(representation.getId());
        permission.update(representation);
        this.assertRepresentation(representation, permission);
        representation.setClients(representation.getClients().stream().filter(userName -> !userName.equals("Client C")).collect(Collectors.toSet()));
        permission.update(representation);
        this.assertRepresentation(representation, permission);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        ClientPolicyRepresentation representation = new ClientPolicyRepresentation();
        representation.setName("Test Delete Permission");
        representation.addClient(new String[]{"Client A"});
        ClientPoliciesResource policies = authorization.policies().client();
        try (Response response = policies.create(representation);){
            ClientPolicyRepresentation created = (ClientPolicyRepresentation)response.readEntity(ClientPolicyRepresentation.class);
            policies.findById(created.getId()).remove();
            ClientPolicyResource removed = policies.findById(created.getId());
            try {
                removed.toRepresentation();
                Assert.fail((String)"Permission not removed");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDeleteClient() {
        AuthorizationResource authorization = this.getClient().authorization();
        ClientPolicyRepresentation representation = new ClientPolicyRepresentation();
        representation.setName("Update Test Client Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addClient(new String[]{"Client D"});
        representation.addClient(new String[]{"Client E"});
        representation.addClient(new String[]{"Client F"});
        this.assertCreated(authorization, representation);
        ClientsResource clients = this.getRealm().clients();
        ClientRepresentation client = (ClientRepresentation)clients.findByClientId("Client D").get(0);
        clients.get(client.getId()).remove();
        representation = authorization.policies().client().findById(representation.getId()).toRepresentation();
        Assert.assertEquals((long)2L, (long)representation.getClients().size());
        Assert.assertFalse((boolean)representation.getClients().contains(client.getId()));
        client = (ClientRepresentation)clients.findByClientId("Client E").get(0);
        clients.get(client.getId()).remove();
        representation = authorization.policies().client().findById(representation.getId()).toRepresentation();
        Assert.assertEquals((long)1L, (long)representation.getClients().size());
        Assert.assertFalse((boolean)representation.getClients().contains(client.getId()));
        client = (ClientRepresentation)clients.findByClientId("Client F").get(0);
        clients.get(client.getId()).remove();
        try {
            authorization.policies().client().findById(representation.getId()).toRepresentation();
            Assert.fail((String)"Client policy should be removed");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGenericConfig() {
        AuthorizationResource authorization = this.getClient().authorization();
        ClientPolicyRepresentation representation = new ClientPolicyRepresentation();
        representation.setName("Test Generic Config Permission");
        representation.addClient(new String[]{"Client A"});
        ClientPoliciesResource policies = authorization.policies().client();
        try (Response response = policies.create(representation);){
            ClientPolicyRepresentation created = (ClientPolicyRepresentation)response.readEntity(ClientPolicyRepresentation.class);
            PolicyResource policy = authorization.policies().policy(created.getId());
            PolicyRepresentation genericConfig = policy.toRepresentation();
            Assert.assertNotNull((Object)genericConfig.getConfig());
            Assert.assertNotNull(genericConfig.getConfig().get("clients"));
            ClientRepresentation user = (ClientRepresentation)this.getRealm().clients().findByClientId("Client A").get(0);
            Assert.assertTrue((boolean)((String)genericConfig.getConfig().get("clients")).contains(user.getId()));
        }
    }

    private void assertCreated(AuthorizationResource authorization, ClientPolicyRepresentation representation) {
        ClientPoliciesResource permissions = authorization.policies().client();
        try (Response response = permissions.create(representation);){
            ClientPolicyRepresentation created = (ClientPolicyRepresentation)response.readEntity(ClientPolicyRepresentation.class);
            ClientPolicyResource permission = permissions.findById(created.getId());
            this.assertRepresentation(representation, permission);
        }
    }

    private void assertRepresentation(ClientPolicyRepresentation representation, ClientPolicyResource permission) {
        ClientPolicyRepresentation actual = permission.toRepresentation();
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)actual, () -> permission.resources(), () -> Collections.emptyList(), () -> permission.associatedPolicies());
        Assert.assertEquals((long)representation.getClients().size(), (long)actual.getClients().size());
        Assert.assertEquals((long)0L, (long)actual.getClients().stream().filter(clientId -> !representation.getClients().stream().filter(userName -> this.getClientName((String)clientId).equalsIgnoreCase((String)userName)).findFirst().isPresent()).count());
    }

    private String getClientName(String id) {
        return this.getRealm().clients().get(id).toRepresentation().getClientId();
    }
}

