/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ResourceScopeResource;
import org.keycloak.admin.client.resource.ResourceScopesResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
public abstract class AbstractAuthorizationTest
extends AbstractClientTest {
    protected static final String RESOURCE_SERVER_CLIENT_ID = "resource-server-test";

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("authz-test");
    }

    @Override
    protected String getRealmId() {
        return "authz-test";
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(this.createTestRealm().build());
        super.addTestRealms(testRealms);
    }

    @After
    public void onAfterReenableAuthorization() {
        this.enableAuthorizationServices(false);
        this.enableAuthorizationServices(true);
    }

    protected ClientResource getClientResource() {
        return this.findClientResource(RESOURCE_SERVER_CLIENT_ID);
    }

    protected ClientRepresentation getResourceServer() {
        return this.findClientRepresentation(RESOURCE_SERVER_CLIENT_ID);
    }

    protected void enableAuthorizationServices(boolean enable) {
        ClientRepresentation resourceServer = this.getResourceServer();
        resourceServer.setAuthorizationServicesEnabled(Boolean.valueOf(enable));
        resourceServer.setServiceAccountsEnabled(Boolean.valueOf(true));
        resourceServer.setPublicClient(Boolean.valueOf(false));
        resourceServer.setSecret("secret");
        this.getClientResource().update(resourceServer);
        if (enable) {
            AuthorizationResource authorization = this.getClientResource().authorization();
            ResourceServerRepresentation settings = authorization.exportSettings();
            settings.setAllowRemoteResourceManagement(true);
            authorization.update(settings);
        }
    }

    protected ResourceScopeResource createDefaultScope() {
        return this.createScope("Test Scope", "Scope Icon");
    }

    protected ResourceScopeResource createScope(String name, String iconUri) {
        ScopeRepresentation newScope = new ScopeRepresentation();
        newScope.setName(name);
        newScope.setIconUri(iconUri);
        ResourceScopesResource resources = this.getClientResource().authorization().scopes();
        try (Response response = resources.create(newScope);){
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
            ScopeRepresentation stored = (ScopeRepresentation)response.readEntity(ScopeRepresentation.class);
            ResourceScopeResource resourceScopeResource = resources.scope(stored.getId());
            return resourceScopeResource;
        }
    }

    private RealmBuilder createTestRealm() {
        return RealmBuilder.create().name("authz-test").user(UserBuilder.create().username("marta").password("password")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId(RESOURCE_SERVER_CLIENT_ID).name(RESOURCE_SERVER_CLIENT_ID).secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants());
    }
}

