/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ServerURLs;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InstallationTest
extends AbstractClientTest {
    private static final String OIDC_NAME = "oidcInstallationClient";
    private static final String OIDC_NAME_BEARER_ONLY_NAME = "oidcInstallationClientBearerOnly";
    private static final String OIDC_NAME_BEARER_ONLY_WITH_AUTHZ_NAME = "oidcInstallationClientBearerOnlyWithAuthz";
    private static final String SAML_NAME = "samlInstallationClient";
    private ClientResource oidcClient;
    private String oidcClientId;
    private ClientResource oidcBearerOnlyClient;
    private String oidcBearerOnlyClientId;
    private ClientResource oidcBearerOnlyClientWithAuthz;
    private String oidcBearerOnlyClientWithAuthzId;
    private ClientResource samlClient;
    private String samlClientId;

    @Before
    public void createClients() {
        this.oidcClientId = this.createOidcClient(OIDC_NAME);
        this.oidcBearerOnlyClientId = this.createOidcBearerOnlyClient(OIDC_NAME_BEARER_ONLY_NAME);
        this.oidcClient = this.findClientResource(OIDC_NAME);
        this.oidcBearerOnlyClient = this.findClientResource(OIDC_NAME_BEARER_ONLY_NAME);
        this.samlClientId = this.createSamlClient(SAML_NAME);
        this.samlClient = this.findClientResource(SAML_NAME);
    }

    @After
    public void tearDown() {
        this.removeClient(this.oidcClientId);
        this.removeClient(this.oidcBearerOnlyClientId);
        this.removeClient(this.samlClientId);
    }

    private String authServerUrl() {
        return ServerURLs.getAuthServerContextRoot() + "/auth";
    }

    private String samlUrl() {
        return this.authServerUrl() + "/realms/test/protocol/saml";
    }

    @Test
    public void testOidcJBossXml() {
        String xml = this.oidcClient.getInstallationProvider("keycloak-oidc-jboss-subsystem");
        this.assertOidcInstallationConfig(xml);
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"<secure-deployment"));
    }

    @Test
    public void testOidcJson() {
        String json = this.oidcClient.getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
    }

    @Test
    public void testOidcJBossCli() {
        String cli = this.oidcClient.getInstallationProvider("keycloak-oidc-jboss-subsystem-cli");
        this.assertOidcInstallationConfig(cli);
        Assert.assertThat((Object)cli, (Matcher)Matchers.containsString((String)"/subsystem=keycloak/secure-deployment=\"WAR MODULE NAME.war\""));
    }

    @Test
    public void testOidcBearerOnlyJson() {
        String json = this.oidcBearerOnlyClient.getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"bearer-only"));
        Assert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"public-client")));
        Assert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"credentials")));
        Assert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"verify-token-audience")));
    }

    @Test
    public void testOidcBearerOnlyJsonWithAudienceClientScope() {
        String clientScopeId = this.testingClient.testing().generateAudienceClientScope("test", OIDC_NAME_BEARER_ONLY_NAME);
        String json = this.oidcBearerOnlyClient.getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"bearer-only"));
        Assert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"public-client")));
        Assert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"credentials")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"verify-token-audience"));
        this.testRealmResource().clientScopes().get(clientScopeId).remove();
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientScopeResourcePath(clientScopeId), null, ResourceType.CLIENT_SCOPE);
    }

    @Test
    public void testOidcBearerOnlyWithAuthzJson() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        this.oidcBearerOnlyClientWithAuthzId = this.createOidcConfidentialClientWithAuthz(OIDC_NAME_BEARER_ONLY_WITH_AUTHZ_NAME);
        this.oidcBearerOnlyClientWithAuthz = this.findClientResource(OIDC_NAME_BEARER_ONLY_WITH_AUTHZ_NAME);
        String json = this.oidcBearerOnlyClientWithAuthz.getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
        Assert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"bearer-only")));
        Assert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"public-client")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"credentials"));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"secret"));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"policy-enforcer"));
        this.removeClient(this.oidcBearerOnlyClientWithAuthzId);
    }

    private void assertOidcInstallationConfig(String config) {
        Assert.assertThat((Object)config, (Matcher)Matchers.containsString((String)"test"));
        Assert.assertThat((Object)config, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)ApiUtil.findActiveSigningKey((RealmResource)this.testRealmResource()).getPublicKey())));
        Assert.assertThat((Object)config, (Matcher)Matchers.containsString((String)this.authServerUrl()));
    }

    @Test(expected=NotFoundException.class)
    public void testSamlMetadataIdpDescriptor() {
        this.samlClient.getInstallationProvider("saml-idp-descriptor");
    }

    @Test
    public void testSamlAdapterXml() {
        String xml = this.samlClient.getInstallationProvider("keycloak-saml");
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"<keycloak-saml-adapter>"));
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"SPECIFY YOUR entityID!"));
        Assert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)ApiUtil.findActiveSigningKey((RealmResource)this.testRealmResource()).getCertificate())));
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)this.samlUrl()));
    }

    @Test
    public void testSamlAdapterCli() {
        String cli = this.samlClient.getInstallationProvider("keycloak-saml-subsystem-cli");
        Assert.assertThat((Object)cli, (Matcher)Matchers.containsString((String)"/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/"));
        Assert.assertThat((Object)cli, (Matcher)Matchers.containsString((String)"SPECIFY YOUR entityID!"));
        Assert.assertThat((Object)cli, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)ApiUtil.findActiveSigningKey((RealmResource)this.testRealmResource()).getCertificate())));
        Assert.assertThat((Object)cli, (Matcher)Matchers.containsString((String)this.samlUrl()));
    }

    @Test
    public void testSamlMetadataSpDescriptor() throws Exception {
        String xml = this.samlClient.getInstallationProvider("saml-sp-descriptor");
        Document doc = this.getDocumentFromXmlString(xml);
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "EntityDescriptor", null);
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SPSSODescriptor", null);
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)SAML_NAME));
    }

    @Test
    public void testSamlJBossXml() {
        String xml = this.samlClient.getInstallationProvider("keycloak-saml-subsystem");
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"<secure-deployment"));
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"SPECIFY YOUR entityID!"));
        Assert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)ApiUtil.findActiveSigningKey((RealmResource)this.testRealmResource()).getCertificate())));
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)this.samlUrl()));
    }

    @Test
    public void testSamlMetadataSpDescriptorPost() throws Exception {
        try (ClientAttributeUpdater updater = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.getRealmId(), (String)SAML_NAME);){
            Assert.assertThat((Object)((String)((ClientResource)updater.getResource()).toRepresentation().getAttributes().get("saml.force.post.binding")), (Matcher)Matchers.equalTo((Object)"true"));
            Document doc = this.getDocumentFromXmlString(((ClientResource)updater.getResource()).getInstallationProvider("saml-sp-descriptor"));
            HashMap<String, String> attrNamesAndValues = new HashMap<String, String>();
            attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get());
            attrNamesAndValues.put("Location", "ERROR:ENDPOINT_NOT_SET");
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
            attrNamesAndValues.clear();
            updater.setAdminUrl("admin-url").update();
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientResourcePath(this.samlClientId), ResourceType.CLIENT);
            doc = this.getDocumentFromXmlString(((ClientResource)updater.getResource()).getInstallationProvider("saml-sp-descriptor"));
            attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get());
            attrNamesAndValues.put("Location", "admin-url");
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
            attrNamesAndValues.clear();
            updater.setAttribute("saml_assertion_consumer_url_post", "saml-assertion-post-url").setAttribute("saml_single_logout_service_url_post", "saml-logout-post-url").setAttribute("saml_assertion_consumer_url_redirect", "saml-assertion-redirect-url").setAttribute("saml_single_logout_service_url_redirect", "saml-logout-redirect-url").update();
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientResourcePath(this.samlClientId), ResourceType.CLIENT);
            doc = this.getDocumentFromXmlString(((ClientResource)updater.getResource()).getInstallationProvider("saml-sp-descriptor"));
            attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get());
            attrNamesAndValues.put("Location", "saml-logout-post-url");
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
            attrNamesAndValues.clear();
            attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get());
            attrNamesAndValues.put("Location", "saml-assertion-post-url");
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
        }
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientResourcePath(this.samlClientId), ResourceType.CLIENT);
    }

    @Test
    public void testSamlMetadataSpDescriptorRedirect() throws Exception {
        try (ClientAttributeUpdater updater = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.getRealmId(), (String)SAML_NAME).setAttribute("saml.force.post.binding", "false").update();){
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientResourcePath(this.samlClientId), ResourceType.CLIENT);
            Assert.assertThat((Object)((String)((ClientResource)updater.getResource()).toRepresentation().getAttributes().get("saml.force.post.binding")), (Matcher)Matchers.equalTo((Object)"false"));
            Document doc = this.getDocumentFromXmlString(((ClientResource)updater.getResource()).getInstallationProvider("saml-sp-descriptor"));
            HashMap<String, String> attrNamesAndValues = new HashMap<String, String>();
            attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
            attrNamesAndValues.put("Location", "ERROR:ENDPOINT_NOT_SET");
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
            attrNamesAndValues.clear();
            updater.setAdminUrl("admin-url").update();
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientResourcePath(this.samlClientId), ResourceType.CLIENT);
            doc = this.getDocumentFromXmlString(((ClientResource)updater.getResource()).getInstallationProvider("saml-sp-descriptor"));
            attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
            attrNamesAndValues.put("Location", "admin-url");
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
            attrNamesAndValues.clear();
            updater.setAttribute("saml_assertion_consumer_url_post", "saml-assertion-post-url").setAttribute("saml_single_logout_service_url_post", "saml-logout-post-url").setAttribute("saml_assertion_consumer_url_redirect", "saml-assertion-redirect-url").setAttribute("saml_single_logout_service_url_redirect", "saml-logout-redirect-url").update();
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientResourcePath(this.samlClientId), ResourceType.CLIENT);
            doc = this.getDocumentFromXmlString(((ClientResource)updater.getResource()).getInstallationProvider("saml-sp-descriptor"));
            attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
            attrNamesAndValues.put("Location", "saml-logout-redirect-url");
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
            attrNamesAndValues.clear();
            attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
            attrNamesAndValues.put("Location", "saml-assertion-redirect-url");
            this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
        }
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientResourcePath(this.samlClientId), ResourceType.CLIENT);
    }

    private Document getDocumentFromXmlString(String xml) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        return db.parse(is);
    }

    private void assertElements(Document doc, String tagNamespace, String tagName, Map<String, String> attrNamesAndValues) {
        NodeList elementsByTagName = doc.getElementsByTagNameNS(tagNamespace, tagName);
        Assert.assertThat((String)("Expected exactly one " + tagName + " element!"), (Object)elementsByTagName.getLength(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Node element = elementsByTagName.item(0);
        if (attrNamesAndValues != null) {
            for (String attrName : attrNamesAndValues.keySet()) {
                Assert.assertThat((Object)element.getAttributes().getNamedItem(attrName).getNodeValue(), (Matcher)Matchers.containsString((String)attrNamesAndValues.get(attrName)));
            }
        }
    }
}

