/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.models.ClientProvider;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.containers.KeycloakQuarkusServerDeployableContainer;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClientSearchTest
extends AbstractClientTest {
    @ArquillianResource
    protected ContainerController controller;
    private static final String CLIENT1 = "client1";
    private static final String CLIENT2 = "client2";
    private static final String CLIENT3 = "client3";
    private String client1Id;
    private String client2Id;
    private String client3Id;
    private static final String ATTR_ORG_NAME = "org";
    private static final String ATTR_ORG_VAL = "Test_\"organisation\"";
    private static final String ATTR_URL_NAME = "url";
    private static final String ATTR_URL_VAL = "https://foo.bar/clflds";
    private static final String ATTR_QUOTES_NAME = "test \"123\"";
    private static final String ATTR_QUOTES_NAME_ESCAPED = "\"test \\\"123\\\"\"";
    private static final String ATTR_QUOTES_VAL = "field=\"blah blah\"";
    private static final String ATTR_QUOTES_VAL_ESCAPED = "\"field=\\\"blah blah\\\"\"";
    private static final String ATTR_FILTERED_NAME = "filtered";
    private static final String ATTR_FILTERED_VAL = "does_not_matter";
    private static final String SEARCHABLE_ATTRS_PROP = "keycloak.client.searchableAttributes";

    @Before
    public void init() {
        ClientRepresentation client1 = this.createOidcClientRep(CLIENT1);
        ClientRepresentation client2 = this.createOidcClientRep(CLIENT2);
        ClientRepresentation client3 = this.createOidcClientRep(CLIENT3);
        client1.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put(ClientSearchTest.ATTR_ORG_NAME, ClientSearchTest.ATTR_ORG_VAL);
                this.put(ClientSearchTest.ATTR_URL_NAME, ClientSearchTest.ATTR_URL_VAL);
            }
        });
        client2.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put(ClientSearchTest.ATTR_URL_NAME, ClientSearchTest.ATTR_URL_VAL);
                this.put(ClientSearchTest.ATTR_FILTERED_NAME, ClientSearchTest.ATTR_FILTERED_VAL);
            }
        });
        client3.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put(ClientSearchTest.ATTR_ORG_NAME, "fake val");
                this.put(ClientSearchTest.ATTR_QUOTES_NAME, ClientSearchTest.ATTR_QUOTES_VAL);
            }
        });
        this.client1Id = this.createClient(client1);
        this.client2Id = this.createClient(client2);
        this.client3Id = this.createClient(client3);
    }

    @After
    public void teardown() {
        this.removeClient(this.client1Id);
        this.removeClient(this.client2Id);
        this.removeClient(this.client3Id);
    }

    @Test
    public void testQuerySearch() throws Exception {
        try {
            String[] stringArray;
            this.configureSearchableAttributes(ATTR_URL_NAME, ATTR_ORG_NAME, ATTR_QUOTES_NAME);
            this.search(String.format("%s:%s", ATTR_ORG_NAME, ATTR_ORG_VAL), CLIENT1);
            this.search(String.format("%s:%s", ATTR_URL_NAME, ATTR_URL_VAL), CLIENT1, CLIENT2);
            this.search(String.format("%s:%s %s:%s", ATTR_ORG_NAME, ATTR_ORG_VAL, ATTR_URL_NAME, ATTR_URL_VAL), CLIENT1);
            this.search(String.format("%s:%s %s:%s", ATTR_ORG_NAME, "wrong val", ATTR_URL_NAME, ATTR_URL_VAL), new String[0]);
            this.search(String.format("%s:%s", ATTR_QUOTES_NAME_ESCAPED, ATTR_QUOTES_VAL_ESCAPED), CLIENT3);
            if (this.isJpaStore()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = CLIENT1;
                stringArray = stringArray2;
                stringArray2[1] = CLIENT2;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = CLIENT2;
            }
            String[] expectedRes = stringArray;
            this.search(String.format("%s:%s %s:%s", ATTR_URL_NAME, ATTR_URL_VAL, ATTR_FILTERED_NAME, ATTR_FILTERED_VAL), expectedRes);
        }
        finally {
            this.resetSearchableAttributes();
        }
    }

    @Test
    public void testJpaSearchableAttributesUnset() {
        Object[] expectedRes = new String[]{CLIENT1};
        if (this.isJpaStore()) {
            expectedRes = (String[])ArrayUtils.addAll((Object[])expectedRes, (Object[])new String[]{CLIENT2, CLIENT3, "account", "account-console", "admin-cli", "broker", "realm-management", "security-admin-console"});
        }
        this.search(String.format("%s:%s", ATTR_ORG_NAME, ATTR_ORG_VAL), (String[])expectedRes);
    }

    private void search(String searchQuery, String ... expectedClientIds) {
        List found = this.testRealmResource().clients().query(searchQuery).stream().map(ClientRepresentation::getClientId).collect(Collectors.toList());
        MatcherAssert.assertThat(found, (Matcher)Matchers.containsInAnyOrder((Object[])expectedClientIds));
    }

    void configureSearchableAttributes(String ... searchableAttributes) throws Exception {
        this.log.infov("Configuring searchableAttributes", new Object[0]);
        if (this.suiteContext.getAuthServerInfo().isUndertow()) {
            this.controller.stop(this.suiteContext.getAuthServerInfo().getQualifier());
            System.setProperty(SEARCHABLE_ATTRS_PROP, String.join((CharSequence)",", searchableAttributes));
            this.controller.start(this.suiteContext.getAuthServerInfo().getQualifier());
        } else if (this.suiteContext.getAuthServerInfo().isJBossBased()) {
            searchableAttributes = (String[])Arrays.stream(searchableAttributes).map(a -> a.replace("\"", "\\\\\\\"")).toArray(String[]::new);
            String s = "\\\"" + String.join((CharSequence)"\\\",\\\"", searchableAttributes) + "\\\"";
            this.executeCli("/subsystem=keycloak-server/spi=client:add()", "/subsystem=keycloak-server/spi=client/provider=jpa/:add(properties={searchableAttributes => \"[" + s + "]\"},enabled=true)");
        } else if (this.suiteContext.getAuthServerInfo().isQuarkus()) {
            searchableAttributes = (String[])Arrays.stream(searchableAttributes).map(a -> a.replace(" ", "\\ ").replace("\"", "\\\\\\\"")).toArray(String[]::new);
            String s = String.join((CharSequence)",", searchableAttributes);
            this.controller.stop(this.suiteContext.getAuthServerInfo().getQualifier());
            KeycloakQuarkusServerDeployableContainer container = (KeycloakQuarkusServerDeployableContainer)this.suiteContext.getAuthServerInfo().getArquillianContainer().getDeployableContainer();
            container.setAdditionalBuildArgs(Collections.singletonList("--spi-client-jpa-searchable-attributes=\"" + s + "\""));
            this.controller.start(this.suiteContext.getAuthServerInfo().getQualifier());
        } else {
            throw new RuntimeException("Don't know how to config");
        }
        this.reconnectAdminClient();
    }

    void resetSearchableAttributes() throws Exception {
        this.log.info((Object)"Reset searchableAttributes");
        if (this.suiteContext.getAuthServerInfo().isUndertow()) {
            this.controller.stop(this.suiteContext.getAuthServerInfo().getQualifier());
            System.clearProperty(SEARCHABLE_ATTRS_PROP);
            this.controller.start(this.suiteContext.getAuthServerInfo().getQualifier());
        } else if (this.suiteContext.getAuthServerInfo().isJBossBased()) {
            this.executeCli("/subsystem=keycloak-server/spi=client:remove");
        } else if (this.suiteContext.getAuthServerInfo().isQuarkus()) {
            KeycloakQuarkusServerDeployableContainer container = (KeycloakQuarkusServerDeployableContainer)this.suiteContext.getAuthServerInfo().getArquillianContainer().getDeployableContainer();
            container.setAdditionalBuildArgs(Collections.emptyList());
            container.restartServer();
        } else {
            throw new RuntimeException("Don't know how to config");
        }
        this.reconnectAdminClient();
    }

    private void executeCli(String ... commands) throws Exception {
        OnlineManagementClient client = AuthServerTestEnricher.getManagementClient();
        Administration administration = new Administration(client);
        this.log.debug((Object)"Running CLI commands:");
        for (String c : commands) {
            this.log.debug((Object)c);
            client.execute(c).assertSuccess();
        }
        this.log.debug((Object)"Done");
        administration.reload();
        client.close();
    }

    private boolean isJpaStore() {
        String providerId = this.testingClient.server().fetchString((FetchOnServer & Serializable)s -> s.getKeycloakSessionFactory().getProviderFactory(ClientProvider.class).getId());
        this.log.info((Object)("Detected store: " + providerId));
        return "\"jpa\"".equals(providerId);
    }
}

