/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.RoleBuilder;

public class ClientScopeTest
extends AbstractClientTest {
    @Test
    public void testAddDuplicatedClientScope() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        String scopeId = this.createClientScope(scopeRep);
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        Response response = this.clientScopes().create(scopeRep);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"Client Scope scope1 already exists", (Object)error.getErrorMessage());
        this.removeClientScope(scopeId);
    }

    @Test(expected=NotFoundException.class)
    public void testGetUnknownScope() {
        String unknownId = UUID.randomUUID().toString();
        this.clientScopes().get(unknownId).toRepresentation();
    }

    private List<String> getClientScopeNames(List<ClientScopeRepresentation> scopes) {
        return scopes.stream().map(clientScope -> clientScope.getName()).collect(Collectors.toList());
    }

    @Test
    public void testRemoveClientScope() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        String scope1Id = this.createClientScope(scopeRep);
        List clientScopes = this.clientScopes().findAll();
        org.junit.Assert.assertTrue((boolean)this.getClientScopeNames(clientScopes).contains("scope1"));
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope2");
        String scope2Id = this.createClientScope(scopeRep);
        clientScopes = this.clientScopes().findAll();
        org.junit.Assert.assertTrue((boolean)this.getClientScopeNames(clientScopes).contains("scope2"));
        this.removeClientScope(scope1Id);
        clientScopes = this.clientScopes().findAll();
        org.junit.Assert.assertFalse((boolean)this.getClientScopeNames(clientScopes).contains("scope1"));
        org.junit.Assert.assertTrue((boolean)this.getClientScopeNames(clientScopes).contains("scope2"));
        this.removeClientScope(scope2Id);
        clientScopes = this.clientScopes().findAll();
        org.junit.Assert.assertFalse((boolean)this.getClientScopeNames(clientScopes).contains("scope1"));
        org.junit.Assert.assertFalse((boolean)this.getClientScopeNames(clientScopes).contains("scope2"));
    }

    @Test
    public void testUpdateScopeScope() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        scopeRep.setDescription("scope1-desc");
        scopeRep.setProtocol("openid-connect");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("someAttr", "someAttrValue");
        attrs.put("emptyAttr", "");
        scopeRep.setAttributes(attrs);
        String scope1Id = this.createClientScope(scopeRep);
        scopeRep = this.clientScopes().get(scope1Id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"scope1", (Object)scopeRep.getName());
        org.junit.Assert.assertEquals((Object)"scope1-desc", (Object)scopeRep.getDescription());
        org.junit.Assert.assertEquals((Object)"someAttrValue", scopeRep.getAttributes().get("someAttr"));
        org.junit.Assert.assertTrue((boolean)ObjectUtil.isBlank((CharSequence)((CharSequence)scopeRep.getAttributes().get("emptyAttr"))));
        org.junit.Assert.assertEquals((Object)"openid-connect", (Object)scopeRep.getProtocol());
        scopeRep.setName("scope1-updated");
        scopeRep.setDescription("scope1-desc-updated");
        scopeRep.setProtocol("saml");
        scopeRep.getAttributes().put("emptyAttr", "someValue");
        this.clientScopes().get(scope1Id).update(scopeRep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientScopeResourcePath(scope1Id), (Object)scopeRep, ResourceType.CLIENT_SCOPE);
        scopeRep = this.clientScopes().get(scope1Id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"scope1-updated", (Object)scopeRep.getName());
        org.junit.Assert.assertEquals((Object)"scope1-desc-updated", (Object)scopeRep.getDescription());
        org.junit.Assert.assertEquals((Object)"saml", (Object)scopeRep.getProtocol());
        org.junit.Assert.assertEquals((Object)"someAttrValue", scopeRep.getAttributes().get("someAttr"));
        org.junit.Assert.assertEquals((Object)"someValue", scopeRep.getAttributes().get("emptyAttr"));
        this.clientScopes().get(scope1Id).remove();
    }

    @Test
    public void testRenameScope() {
        ClientScopeRepresentation scope1Rep = new ClientScopeRepresentation();
        scope1Rep.setName("scope1");
        scope1Rep.setDescription("scope1-desc");
        scope1Rep.setProtocol("openid-connect");
        this.createClientScope(scope1Rep);
        ClientScopeRepresentation scope2Rep = new ClientScopeRepresentation();
        scope2Rep.setName("scope2");
        scope2Rep.setDescription("scope2-desc");
        scope2Rep.setProtocol("openid-connect");
        String scope2Id = this.createClientScope(scope2Rep);
        scope2Rep.setName("scope1");
        try {
            this.clientScopes().get(scope2Id).update(scope2Rep);
        }
        catch (ClientErrorException ex) {
            org.junit.Assert.assertThat((Object)ex.getResponse(), (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.CONFLICT));
        }
    }

    @Test
    public void testScopes() {
        RoleRepresentation realmCompositeRole = this.createRealmRole("realm-composite");
        RoleRepresentation realmChildRole = this.createRealmRole("realm-child");
        this.testRealmResource().roles().get("realm-composite").addComposites(Collections.singletonList(realmChildRole));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.roleResourceCompositesPath("realm-composite"), Collections.singletonList(realmChildRole), ResourceType.REALM_ROLE);
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("bar-scope");
        String scopeId = this.createClientScope(scopeRep);
        String accountMgmtId = ((ClientRepresentation)this.testRealmResource().clients().findByClientId("account").get(0)).getId();
        RoleRepresentation viewAccountRoleRep = this.testRealmResource().clients().get(accountMgmtId).roles().get("view-profile").toRepresentation();
        RoleMappingResource scopesResource = this.clientScopes().get(scopeId).getScopeMappings();
        scopesResource.realmLevel().add(Collections.singletonList(realmCompositeRole));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeRoleMappingsRealmLevelPath(scopeId), Collections.singletonList(realmCompositeRole), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).add(Collections.singletonList(viewAccountRoleRep));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeRoleMappingsClientLevelPath(scopeId, accountMgmtId), Collections.singletonList(viewAccountRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        List allRealm = scopesResource.realmLevel().listAll();
        List availableRealm = scopesResource.realmLevel().listAvailable();
        List effectiveRealm = scopesResource.realmLevel().listEffective();
        List accountRoles = scopesResource.clientLevel(accountMgmtId).listAll();
        Assert.assertNames(allRealm, "realm-composite");
        Assert.assertNames(availableRealm, "realm-child", "offline_access", "uma_authorization", "default-roles-test");
        Assert.assertNames(effectiveRealm, "realm-composite", "realm-child");
        Assert.assertNames(accountRoles, "view-profile");
        MappingsRepresentation mappingsRep = this.clientScopes().get(scopeId).getScopeMappings().getAll();
        Assert.assertNames(mappingsRep.getRealmMappings(), "realm-composite");
        Assert.assertNames(((ClientMappingsRepresentation)mappingsRep.getClientMappings().get("account")).getMappings(), "view-profile");
        scopesResource.realmLevel().remove(Collections.singletonList(realmCompositeRole));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientScopeRoleMappingsRealmLevelPath(scopeId), Collections.singletonList(realmCompositeRole), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).remove(Collections.singletonList(viewAccountRoleRep));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientScopeRoleMappingsClientLevelPath(scopeId, accountMgmtId), Collections.singletonList(viewAccountRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        allRealm = scopesResource.realmLevel().listAll();
        availableRealm = scopesResource.realmLevel().listAvailable();
        effectiveRealm = scopesResource.realmLevel().listEffective();
        accountRoles = scopesResource.clientLevel(accountMgmtId).listAll();
        Assert.assertNames(allRealm, new String[0]);
        Assert.assertNames(availableRealm, "realm-composite", "realm-child", "offline_access", "uma_authorization", "default-roles-test");
        Assert.assertNames(effectiveRealm, new String[0]);
        Assert.assertNames(accountRoles, new String[0]);
        this.removeClientScope(scopeId);
    }

    @Test
    public void rolesCanBeAddedToScopeEvenWhenTheyAreAlreadyIndirectlyAssigned() {
        RealmResource realm = this.testRealmResource();
        ClientScopeRepresentation clientScopeRep = new ClientScopeRepresentation();
        clientScopeRep.setName("my-scope");
        String clientScopeId = this.createClientScope(clientScopeRep);
        this.createRealmRole("realm-composite");
        this.createRealmRole("realm-child");
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        Response response = realm.clients().create(ClientBuilder.create().clientId("role-container-client").build());
        String roleContainerClientUuid = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(roleContainerClientUuid);
        response.close();
        RoleRepresentation clientCompositeRole = RoleBuilder.create().name("client-composite").build();
        realm.clients().get(roleContainerClientUuid).roles().create(clientCompositeRole);
        realm.clients().get(roleContainerClientUuid).roles().create(RoleBuilder.create().name("client-child").build());
        realm.clients().get(roleContainerClientUuid).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(roleContainerClientUuid).roles().get("client-child").toRepresentation()));
        RoleMappingResource scopesResource = realm.clientScopes().get(clientScopeId).getScopeMappings();
        scopesResource.realmLevel().add(Collections.singletonList(realm.roles().get("realm-composite").toRepresentation()));
        scopesResource.clientLevel(roleContainerClientUuid).add(Collections.singletonList(realm.clients().get(roleContainerClientUuid).roles().get("client-composite").toRepresentation()));
        Assert.assertNames(scopesResource.realmLevel().listAll(), "realm-composite");
        Assert.assertNames(scopesResource.realmLevel().listAvailable(), "realm-child", "offline_access", "uma_authorization", "default-roles-test");
        Assert.assertNames(scopesResource.realmLevel().listEffective(), "realm-composite", "realm-child");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listAll(), "client-composite");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listAvailable(), "client-child");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listEffective(), "client-composite", "client-child");
        scopesResource.realmLevel().add(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        scopesResource.clientLevel(roleContainerClientUuid).add(Collections.singletonList(realm.clients().get(roleContainerClientUuid).roles().get("client-child").toRepresentation()));
        Assert.assertNames(scopesResource.realmLevel().listAll(), "realm-composite", "realm-child");
        Assert.assertNames(scopesResource.realmLevel().listAvailable(), "offline_access", "uma_authorization", "default-roles-test");
        Assert.assertNames(scopesResource.realmLevel().listEffective(), "realm-composite", "realm-child");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listAll(), "client-composite", "client-child");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listAvailable(), new String[0]);
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listEffective(), "client-composite", "client-child");
    }

    @Test
    public void testRemoveScopedRole() {
        RoleRepresentation roleRep = this.createRealmRole("foo-role");
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("bar-scope");
        String scopeId = this.createClientScope(scopeRep);
        this.clientScopes().get(scopeId).getScopeMappings().realmLevel().add(Collections.singletonList(roleRep));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeRoleMappingsRealmLevelPath(scopeId), Collections.singletonList(roleRep), ResourceType.REALM_SCOPE_MAPPING);
        List roleReps = this.clientScopes().get(scopeId).getScopeMappings().realmLevel().listAll();
        org.junit.Assert.assertEquals((long)1L, (long)roleReps.size());
        org.junit.Assert.assertEquals((Object)"foo-role", (Object)((RoleRepresentation)roleReps.get(0)).getName());
        this.testRealmResource().roles().deleteRole("foo-role");
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.roleResourcePath("foo-role"), ResourceType.REALM_ROLE);
        roleReps = this.clientScopes().get(scopeId).getScopeMappings().realmLevel().listAll();
        org.junit.Assert.assertEquals((long)0L, (long)roleReps.size());
        this.removeClientScope(scopeId);
    }

    private RoleRepresentation createRealmRole(String roleName) {
        RoleRepresentation roleRep = new RoleRepresentation();
        roleRep.setName(roleName);
        this.testRealmResource().roles().create(roleRep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.roleResourcePath(roleName), (Object)roleRep, ResourceType.REALM_ROLE);
        RoleRepresentation createdRole = this.testRealmResource().roles().get(roleName).toRepresentation();
        this.getCleanup().addRoleId(createdRole.getId());
        return createdRole;
    }

    @Test
    public void testRemoveClientScopeInUse() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("foo-scope");
        scopeRep.setProtocol("openid-connect");
        String scopeId = this.createClientScope(scopeRep);
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client");
        clientRep.setName("bar-client");
        clientRep.setProtocol("openid-connect");
        clientRep.setDefaultClientScopes(Collections.singletonList("foo-scope"));
        String clientDbId = this.createClient(clientRep);
        this.removeClientScope(scopeId);
        this.removeClient(clientDbId);
    }

    @Test
    public void testRealmDefaultClientScopes() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-def");
        scopeRep.setProtocol("openid-connect");
        String scopeDefId = this.createClientScope(scopeRep);
        this.getCleanup().addClientScopeId(scopeDefId);
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-opt");
        scopeRep.setProtocol("openid-connect");
        String scopeOptId = this.createClientScope(scopeRep);
        this.getCleanup().addClientScopeId(scopeOptId);
        this.testRealmResource().addDefaultDefaultClientScope(scopeDefId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.defaultDefaultClientScopePath(scopeDefId), ResourceType.CLIENT_SCOPE);
        this.testRealmResource().addDefaultOptionalClientScope(scopeOptId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.defaultOptionalClientScopePath(scopeOptId), ResourceType.CLIENT_SCOPE);
        List<String> realmDefaultScopes = this.getClientScopeNames(this.testRealmResource().getDefaultDefaultClientScopes());
        List<String> realmOptionalScopes = this.getClientScopeNames(this.testRealmResource().getDefaultOptionalClientScopes());
        org.junit.Assert.assertTrue((boolean)realmDefaultScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)realmOptionalScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)realmDefaultScopes.contains("scope-opt"));
        org.junit.Assert.assertTrue((boolean)realmOptionalScopes.contains("scope-opt"));
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client");
        clientRep.setProtocol("openid-connect");
        String clientUuid = this.createClient(clientRep);
        this.getCleanup().addClientUuid(clientUuid);
        List<String> clientDefaultScopes = this.getClientScopeNames(this.testRealmResource().clients().get(clientUuid).getDefaultClientScopes());
        List<String> clientOptionalScopes = this.getClientScopeNames(this.testRealmResource().clients().get(clientUuid).getOptionalClientScopes());
        org.junit.Assert.assertTrue((boolean)clientDefaultScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)clientOptionalScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)clientDefaultScopes.contains("scope-opt"));
        org.junit.Assert.assertTrue((boolean)clientOptionalScopes.contains("scope-opt"));
        this.testRealmResource().removeDefaultDefaultClientScope(scopeDefId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.defaultDefaultClientScopePath(scopeDefId), ResourceType.CLIENT_SCOPE);
        this.testRealmResource().removeDefaultOptionalClientScope(scopeOptId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.defaultOptionalClientScopePath(scopeOptId), ResourceType.CLIENT_SCOPE);
        realmDefaultScopes = this.getClientScopeNames(this.testRealmResource().getDefaultDefaultClientScopes());
        realmOptionalScopes = this.getClientScopeNames(this.testRealmResource().getDefaultOptionalClientScopes());
        org.junit.Assert.assertFalse((boolean)realmDefaultScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)realmOptionalScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)realmDefaultScopes.contains("scope-opt"));
        org.junit.Assert.assertFalse((boolean)realmOptionalScopes.contains("scope-opt"));
        clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client-2");
        clientRep.setProtocol("openid-connect");
        clientUuid = this.createClient(clientRep);
        this.getCleanup().addClientUuid(clientUuid);
        clientDefaultScopes = this.getClientScopeNames(this.testRealmResource().clients().get(clientUuid).getDefaultClientScopes());
        clientOptionalScopes = this.getClientScopeNames(this.testRealmResource().clients().get(clientUuid).getOptionalClientScopes());
        org.junit.Assert.assertFalse((boolean)clientDefaultScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)clientOptionalScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)clientDefaultScopes.contains("scope-opt"));
        org.junit.Assert.assertFalse((boolean)clientOptionalScopes.contains("scope-opt"));
    }

    @Test
    public void defaultOptionalClientScopeCanBeAssignedToClientAsDefaultScope() {
        ClientScopeRepresentation optionalClientScope = new ClientScopeRepresentation();
        optionalClientScope.setName("optional-client-scope");
        optionalClientScope.setProtocol("openid-connect");
        String optionalClientScopeId = this.createClientScope(optionalClientScope);
        this.getCleanup().addClientScopeId(optionalClientScopeId);
        this.testRealmResource().addDefaultOptionalClientScope(optionalClientScopeId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.defaultOptionalClientScopePath(optionalClientScopeId), ResourceType.CLIENT_SCOPE);
        List<String> realmOptionalScopes = this.getClientScopeNames(this.testRealmResource().getDefaultOptionalClientScopes());
        org.junit.Assert.assertTrue((boolean)realmOptionalScopes.contains("optional-client-scope"));
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("test-client");
        client.setDefaultClientScopes(Collections.singletonList("optional-client-scope"));
        String clientUuid = this.createClient(client);
        this.getCleanup().addClientUuid(clientUuid);
        List<String> clientDefaultScopes = this.getClientScopeNames(this.testRealmResource().clients().get(clientUuid).getDefaultClientScopes());
        org.junit.Assert.assertTrue((boolean)clientDefaultScopes.contains("optional-client-scope"));
        List<String> clientOptionalScopes = this.getClientScopeNames(this.testRealmResource().clients().get(clientUuid).getOptionalClientScopes());
        org.junit.Assert.assertTrue((boolean)clientOptionalScopes.isEmpty());
        this.testRealmResource().removeDefaultOptionalClientScope(optionalClientScopeId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.defaultOptionalClientScopePath(optionalClientScopeId), ResourceType.CLIENT_SCOPE);
    }

    @Test
    public void scopesRemainAfterClientUpdate() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-def");
        scopeRep.setProtocol("openid-connect");
        String scopeDefId = this.createClientScope(scopeRep);
        this.getCleanup().addClientScopeId(scopeDefId);
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-opt");
        scopeRep.setProtocol("openid-connect");
        String scopeOptId = this.createClientScope(scopeRep);
        this.getCleanup().addClientScopeId(scopeOptId);
        this.testRealmResource().addDefaultDefaultClientScope(scopeDefId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.defaultDefaultClientScopePath(scopeDefId), ResourceType.CLIENT_SCOPE);
        this.testRealmResource().addDefaultOptionalClientScope(scopeOptId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.defaultOptionalClientScopePath(scopeOptId), ResourceType.CLIENT_SCOPE);
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client");
        clientRep.setProtocol("openid-connect");
        String clientUuid = this.createClient(clientRep);
        ClientResource client = this.testRealmResource().clients().get(clientUuid);
        this.getCleanup().addClientUuid(clientUuid);
        org.junit.Assert.assertTrue((boolean)this.getClientScopeNames(client.getDefaultClientScopes()).contains("scope-def"));
        org.junit.Assert.assertTrue((boolean)this.getClientScopeNames(client.getOptionalClientScopes()).contains("scope-opt"));
        client.removeDefaultClientScope(scopeDefId);
        client.removeOptionalClientScope(scopeOptId);
        List<String> expectedDefScopes = this.getClientScopeNames(client.getDefaultClientScopes());
        List<String> expectedOptScopes = this.getClientScopeNames(client.getOptionalClientScopes());
        org.junit.Assert.assertFalse((boolean)expectedDefScopes.contains("scope-def"));
        org.junit.Assert.assertFalse((boolean)expectedOptScopes.contains("scope-opt"));
        clientRep = client.toRepresentation();
        clientRep.setDescription("desc");
        client.update(clientRep);
        org.junit.Assert.assertEquals(expectedDefScopes, this.getClientScopeNames(client.getDefaultClientScopes()));
        org.junit.Assert.assertEquals(expectedOptScopes, this.getClientScopeNames(client.getOptionalClientScopes()));
    }

    @Test
    public void testUpdateProtocolMappers() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("testUpdateProtocolMappers");
        scopeRep.setProtocol("openid-connect");
        String scopeId = this.createClientScope(scopeRep);
        ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
        mapper.setName("test");
        mapper.setProtocol("openid-connect");
        mapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user.attribute", "test");
        m.put("claim.name", "");
        m.put("jsonType.label", "");
        mapper.setConfig(m);
        ProtocolMappersResource protocolMappers = this.clientScopes().get(scopeId).getProtocolMappers();
        Response response = protocolMappers.createMapper(mapper);
        String mapperId = ApiUtil.getCreatedId((Response)response);
        mapper = protocolMappers.getMapperById(mapperId);
        mapper.getConfig().put("claim.name", "claim");
        protocolMappers.update(mapperId, mapper);
        List mappers = protocolMappers.getMappers();
        org.junit.Assert.assertEquals((long)1L, (long)mappers.size());
        org.junit.Assert.assertEquals((long)2L, (long)((ProtocolMapperRepresentation)mappers.get(0)).getConfig().size());
        org.junit.Assert.assertEquals((Object)"test", ((ProtocolMapperRepresentation)mappers.get(0)).getConfig().get("user.attribute"));
        org.junit.Assert.assertEquals((Object)"claim", ((ProtocolMapperRepresentation)mappers.get(0)).getConfig().get("claim.name"));
        this.clientScopes().get(scopeId).remove();
    }

    @Test
    public void updateClientWithDefaultScopeAssignedAsOptionalAndOpposite() {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client");
        clientRep.setProtocol("openid-connect");
        String clientUuid = this.createClient(clientRep);
        this.getCleanup().addClientUuid(clientUuid);
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-def");
        scopeRep.setProtocol("openid-connect");
        String scopeDefId = this.createClientScope(scopeRep);
        this.getCleanup().addClientScopeId(scopeDefId);
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-opt");
        scopeRep.setProtocol("openid-connect");
        String scopeOptId = this.createClientScope(scopeRep);
        this.getCleanup().addClientScopeId(scopeOptId);
        this.testRealmResource().clients().get(clientUuid).addOptionalClientScope(scopeDefId);
        this.testRealmResource().clients().get(clientUuid).addDefaultClientScope(scopeOptId);
        this.testRealmResource().addDefaultDefaultClientScope(scopeDefId);
        this.testRealmResource().addDefaultOptionalClientScope(scopeOptId);
        clientRep.setDescription("new_description");
        this.testRealmResource().clients().get(clientUuid).update(clientRep);
    }

    private ClientScopesResource clientScopes() {
        return this.testRealmResource().clientScopes();
    }

    private String createClientScope(ClientScopeRepresentation clientScopeRep) {
        Response resp = this.clientScopes().create(clientScopeRep);
        org.junit.Assert.assertEquals((long)201L, (long)resp.getStatus());
        resp.close();
        String clientScopeId = ApiUtil.getCreatedId((Response)resp);
        this.getCleanup().addClientScopeId(clientScopeId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeResourcePath(clientScopeId), (Object)clientScopeRep, ResourceType.CLIENT_SCOPE);
        return clientScopeId;
    }

    private void removeClientScope(String clientScopeId) {
        this.clientScopes().get(clientScopeId).remove();
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientScopeResourcePath(clientScopeId), ResourceType.CLIENT_SCOPE);
    }
}

