/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.client.AbstractProtocolMapperTest;
import org.keycloak.testsuite.util.AdminEventPaths;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ClientScopeProtocolMapperTest
extends AbstractProtocolMapperTest {
    private String oidcClientScopeId;
    private ProtocolMappersResource oidcMappersRsc;
    private String samlClientScopeId;
    private ProtocolMappersResource samlMappersRsc;

    @Before
    public void init() {
        this.oidcClientScopeId = this.createClientScope("oidcMapperClient-scope", "openid-connect");
        this.oidcMappersRsc = this.clientScopes().get(this.oidcClientScopeId).getProtocolMappers();
        this.samlClientScopeId = this.createClientScope("samlMapperClient-scope", "saml");
        this.samlMappersRsc = this.clientScopes().get(this.samlClientScopeId).getProtocolMappers();
        super.initBuiltinMappers();
    }

    @After
    public void tearDown() {
        this.removeClientScope(this.oidcClientScopeId);
        this.removeClientScope(this.samlClientScopeId);
    }

    @Test
    public void test01GetMappersList() {
        Assert.assertTrue((boolean)this.oidcMappersRsc.getMappers().isEmpty());
        Assert.assertTrue((boolean)this.samlMappersRsc.getMappers().isEmpty());
    }

    @Test
    public void test02CreateOidcMappersFromList() {
        this.testAddAllBuiltinMappers(this.oidcMappersRsc, "openid-connect", AdminEventPaths.clientScopeProtocolMappersPath(this.oidcClientScopeId));
    }

    @Test
    public void test03CreateSamlMappersFromList() {
        this.testAddAllBuiltinMappers(this.samlMappersRsc, "saml", AdminEventPaths.clientScopeProtocolMappersPath(this.samlClientScopeId));
    }

    @Test
    public void test04CreateSamlProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper");
        int totalMappers = this.samlMappersRsc.getMappers().size();
        int totalSamlMappers = this.samlMappersRsc.getMappersPerProtocol("saml").size();
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeProtocolMapperPath(this.samlClientScopeId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        Assert.assertEquals((long)(totalMappers + 1), (long)this.samlMappersRsc.getMappers().size());
        Assert.assertEquals((long)(totalSamlMappers + 1), (long)this.samlMappersRsc.getMappersPerProtocol("saml").size());
        ProtocolMapperRepresentation created = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test05CreateOidcProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper");
        int totalMappers = this.oidcMappersRsc.getMappers().size();
        int totalOidcMappers = this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size();
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeProtocolMapperPath(this.oidcClientScopeId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        Assert.assertEquals((long)(totalMappers + 1), (long)this.oidcMappersRsc.getMappers().size());
        Assert.assertEquals((long)(totalOidcMappers + 1), (long)this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size());
        ProtocolMapperRepresentation created = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test06UpdateSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper2");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeProtocolMapperPath(this.samlClientScopeId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "account.manage-account");
        rep.setId(createdId);
        this.samlMappersRsc.update(createdId, rep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientScopeProtocolMapperPath(this.samlClientScopeId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void test07UpdateOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper2");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeProtocolMapperPath(this.oidcClientScopeId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "myotherrole");
        rep.setId(createdId);
        this.oidcMappersRsc.update(createdId, rep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientScopeProtocolMapperPath(this.oidcClientScopeId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void testDeleteSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper3");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeProtocolMapperPath(this.samlClientScopeId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        this.samlMappersRsc.delete(createdId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientScopeProtocolMapperPath(this.samlClientScopeId, createdId), ResourceType.PROTOCOL_MAPPER);
        try {
            this.samlMappersRsc.getMapperById(createdId);
            Assert.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper3");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeProtocolMapperPath(this.oidcClientScopeId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        this.oidcMappersRsc.delete(createdId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientScopeProtocolMapperPath(this.oidcClientScopeId, createdId), ResourceType.PROTOCOL_MAPPER);
        try {
            this.oidcMappersRsc.getMapperById(createdId);
            Assert.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private ClientScopesResource clientScopes() {
        return this.testRealmResource().clientScopes();
    }

    private String createClientScope(String clientScopeName, String protocol) {
        ClientScopeRepresentation rep = new ClientScopeRepresentation();
        rep.setName(clientScopeName);
        rep.setProtocol(protocol);
        Response resp = this.clientScopes().create(rep);
        Assert.assertEquals((long)201L, (long)resp.getStatus());
        resp.close();
        String scopeId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientScopeResourcePath(scopeId), (Object)rep, ResourceType.CLIENT_SCOPE);
        return scopeId;
    }

    private void removeClientScope(String clientScopeId) {
        this.clientScopes().get(clientScopeId).remove();
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientScopeResourcePath(clientScopeId), ResourceType.CLIENT_SCOPE);
    }
}

