/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.testsuite.util.RealmBuilder;

public abstract class AbstractClientTest
extends AbstractAuthTest {
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("test");
        this.accountPage.setAuthRealm("test");
    }

    @Before
    public void setupAdminEvents() {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        if (realm.getEventsListeners() == null || !realm.getEventsListeners().contains("event-queue")) {
            realm = RealmBuilder.edit(this.testRealmResource().toRepresentation()).testEventListener().build();
            this.testRealmResource().update(realm);
        }
    }

    @After
    public void tearDownAdminEvents() {
        RealmRepresentation realm = RealmBuilder.edit(this.testRealmResource().toRepresentation()).removeTestEventListener().build();
        this.testRealmResource().update(realm);
    }

    protected RealmRepresentation realmRep() {
        return this.testRealmResource().toRepresentation();
    }

    protected String getRealmId() {
        return "test";
    }

    protected UserRepresentation getFullUserRep(String userName) {
        List results = this.testRealmResource().users().search(userName, null, null, null, null, null);
        UserRepresentation result = null;
        for (UserRepresentation user : results) {
            if (!userName.equals(user.getUsername())) continue;
            result = user;
        }
        Assert.assertNotNull((String)("Did not find user with username " + userName), result);
        return result;
    }

    protected String createOidcClient(String name) {
        return this.createClient(this.createOidcClientRep(name));
    }

    protected String createOidcBearerOnlyClient(String name) {
        ClientRepresentation clientRep = this.createOidcClientRep(name);
        clientRep.setBearerOnly(Boolean.TRUE);
        clientRep.setPublicClient(Boolean.FALSE);
        return this.createClient(clientRep);
    }

    protected String createOidcConfidentialClientWithAuthz(String name) {
        ClientRepresentation clientRep = this.createOidcClientRep(name);
        clientRep.setBearerOnly(Boolean.FALSE);
        clientRep.setPublicClient(Boolean.FALSE);
        clientRep.setAuthorizationServicesEnabled(Boolean.TRUE);
        clientRep.setServiceAccountsEnabled(Boolean.TRUE);
        String id = this.createClient(clientRep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientResourcePath(id), ResourceType.AUTHORIZATION_RESOURCE_SERVER);
        return id;
    }

    protected ClientRepresentation createOidcClientRep(String name) {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId(name);
        clientRep.setName(name);
        clientRep.setProtocol("openid-connect");
        return clientRep;
    }

    protected String createSamlClient(String name) {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId(name);
        clientRep.setName(name);
        clientRep.setProtocol("saml");
        return this.createClient(clientRep);
    }

    protected String createClient(ClientRepresentation clientRep) {
        Response resp = this.testRealmResource().clients().create(clientRep);
        resp.close();
        String id = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientResourcePath(id), (Object)clientRep, ResourceType.CLIENT);
        return id;
    }

    protected void removeClient(String clientDbId) {
        this.testRealmResource().clients().get(clientDbId).remove();
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientResourcePath(clientDbId), ResourceType.CLIENT);
    }

    protected ClientRepresentation findClientRepresentation(String name) {
        ClientResource clientRsc = this.findClientResource(name);
        if (clientRsc == null) {
            return null;
        }
        return this.findClientResource(name).toRepresentation();
    }

    protected ClientResource findClientResource(String name) {
        return ApiUtil.findClientResourceByName((RealmResource)this.testRealmResource(), (String)name);
    }

    protected ClientResource findClientResourceById(String id) {
        return ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)id);
    }
}

