/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.AdminClientUtil;

public class UsersTest
extends AbstractAdminTest {
    @Before
    public void cleanUsers() {
        List userRepresentations = this.realm.users().list();
        for (UserRepresentation user : userRepresentations) {
            this.realm.users().delete(user.getId());
        }
    }

    @Test
    public void findUsersByEmailVerifiedStatus() {
        this.createUser(this.realmId, "user1", "password", "user1FirstName", "user1LastName", "user1@example.com", (UserRepresentation rep) -> rep.setEmailVerified(Boolean.valueOf(true)));
        this.createUser(this.realmId, "user2", "password", "user2FirstName", "user2LastName", "user2@example.com", (UserRepresentation rep) -> rep.setEmailVerified(Boolean.valueOf(false)));
        boolean emailVerified = true;
        List usersEmailVerified = this.realm.users().search(null, null, null, null, Boolean.valueOf(emailVerified), null, null, null, Boolean.valueOf(true));
        Assert.assertThat((Object)usersEmailVerified, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Assert.assertThat((Object)((UserRepresentation)usersEmailVerified.get(0)).getUsername(), (Matcher)CoreMatchers.is((Object)"user1"));
        emailVerified = false;
        List usersEmailNotVerified = this.realm.users().search(null, null, null, null, Boolean.valueOf(emailVerified), null, null, null, Boolean.valueOf(true));
        Assert.assertThat((Object)usersEmailNotVerified, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Assert.assertThat((Object)((UserRepresentation)usersEmailNotVerified.get(0)).getUsername(), (Matcher)CoreMatchers.is((Object)"user2"));
    }

    @Test
    public void countUsersByEmailVerifiedStatus() {
        this.createUser(this.realmId, "user1", "password", "user1FirstName", "user1LastName", "user1@example.com", (UserRepresentation rep) -> rep.setEmailVerified(Boolean.valueOf(true)));
        this.createUser(this.realmId, "user2", "password", "user2FirstName", "user2LastName", "user2@example.com", (UserRepresentation rep) -> rep.setEmailVerified(Boolean.valueOf(false)));
        this.createUser(this.realmId, "user3", "password", "user3FirstName", "user3LastName", "user3@example.com", (UserRepresentation rep) -> rep.setEmailVerified(Boolean.valueOf(true)));
        boolean emailVerified = true;
        Assert.assertThat((Object)this.realm.users().countEmailVerified(Boolean.valueOf(emailVerified)), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null, null, null, Boolean.valueOf(emailVerified), null), (Matcher)CoreMatchers.is((Object)2));
        emailVerified = false;
        Assert.assertThat((Object)this.realm.users().countEmailVerified(Boolean.valueOf(emailVerified)), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count(null, null, null, Boolean.valueOf(emailVerified), null), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void countUsersWithViewPermission() {
        this.createUser(this.realmId, "user1", "password", "user1FirstName", "user1LastName", "user1@example.com");
        this.createUser(this.realmId, "user2", "password", "user2FirstName", "user2LastName", "user2@example.com");
        Assert.assertThat((Object)this.realm.users().count(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void countUsersBySearchWithViewPermission() {
        this.createUser(this.realmId, "user1", "password", "user1FirstName", "user1LastName", "user1@example.com");
        this.createUser(this.realmId, "user2", "password", "user2FirstName", "user2LastName", "user2@example.com");
        Assert.assertThat((Object)this.realm.users().count("user"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("FirstName"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("user2FirstName"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count("LastName"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("user2LastName"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count("@example.com"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("user1@example.com"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count("notExisting"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.realm.users().count(""), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void countUsersByFiltersWithViewPermission() {
        this.createUser(this.realmId, "user1", "password", "user1FirstName", "user1LastName", "user1@example.com");
        this.createUser(this.realmId, "user2", "password", "user2FirstName", "user2LastName", "user2@example.com");
        Assert.assertThat((Object)this.realm.users().count(null, null, null, "user"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null, null, null, "user1"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count(null, null, null, "notExisting"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.realm.users().count(null, null, null, ""), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null, "FirstName", null, null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null, "user2FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count(null, "notExisting", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.realm.users().count(null, "", null, null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("LastName", null, null, null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("user2LastName", null, null, null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count("notExisting", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.realm.users().count("", null, null, null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null, null, "@example.com", null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null, null, "user1@example.com", null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count(null, null, "user1@test.com", null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.realm.users().count(null, null, "", null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("user1LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count("user1LastName", "", null, null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.realm.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null, null, "@example.com", "user"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count(null, null, null, null), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.realm.users().count("", "", "", ""), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void countUsersWithGroupViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        Assert.assertThat((Object)testRealmResource.users().count(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void countUsersBySearchWithGroupViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        Assert.assertThat((Object)testRealmResource.users().count("user"), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("FirstName"), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("user2FirstName"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count("LastName"), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("user2LastName"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count("@example.com"), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("user1@example.com"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count("notExisting"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(""), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count(null), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void countUsersByFiltersWithGroupViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, "user"), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, "user1"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, "notExisting"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, ""), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count(null, "FirstName", null, null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count(null, "user2FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count(null, "notExisting", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, "", null, null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("LastName", null, null, null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("user2LastName", null, null, null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count("notExisting", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("", null, null, null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "user1@example.com", null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "user1@test.com", null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "", null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("user1LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count("user1LastName", "", null, null), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", "user"), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, null), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testRealmResource.users().count("", "", "", ""), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void countUsersWithNoViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        Assert.assertThat((Object)testRealmResource.users().count(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void countUsersBySearchWithNoViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        Assert.assertThat((Object)testRealmResource.users().count("user"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("FirstName"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("user2FirstName"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("LastName"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("user2LastName"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("@example.com"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("user1@example.com"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("notExisting"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(""), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void countUsersByFiltersWithNoViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, "user"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, "user1"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, "notExisting"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, ""), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, "user2FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, "notExisting", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, "", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("LastName", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("user2LastName", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("notExisting", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "user1@example.com", null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "user1@test.com", null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "", null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("user1LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("user1LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", "user"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count(null, null, null, null), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)testRealmResource.users().count("", "", "", ""), (Matcher)CoreMatchers.is((Object)0));
    }

    private RealmResource setupTestEnvironmentWithPermissions(boolean grp1ViewPermissions) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        String testUserId = this.createUser(this.realmId, "test-user", "password", "", "", "");
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.realm.clients().findByClientId("realm-management").get(0);
        String realmManagementId = clientRepresentation.getId();
        RoleRepresentation roleRepresentation = this.realm.clients().get(realmManagementId).roles().get("query-users").toRepresentation();
        this.realm.users().get(testUserId).roles().clientLevel(realmManagementId).add(Collections.singletonList(roleRepresentation));
        List<GroupRepresentation> groups = this.setupUsersInGroupsWithPermissions();
        if (grp1ViewPermissions) {
            AuthorizationResource authorizationResource = this.realm.clients().get(realmManagementId).authorization();
            UserPolicyRepresentation policy = new UserPolicyRepresentation();
            String policyName = "test-policy";
            policy.setName(policyName);
            policy.setUsers(Collections.singleton(testUserId));
            authorizationResource.policies().user().create(policy).close();
            PolicyRepresentation policyRepresentation = authorizationResource.policies().findByName(policyName);
            Optional<GroupRepresentation> optional = groups.stream().filter(g -> g.getName().equals("grp1")).findFirst();
            Assert.assertThat((Object)optional.isPresent(), (Matcher)CoreMatchers.is((Object)true));
            GroupRepresentation grp1 = optional.get();
            ScopePermissionRepresentation scopePermissionRepresentation = authorizationResource.permissions().scope().findByName("view.members.permission.group." + grp1.getId());
            scopePermissionRepresentation.setPolicies(Collections.singleton(policyRepresentation.getId()));
            scopePermissionRepresentation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
            authorizationResource.permissions().scope().findById(scopePermissionRepresentation.getId()).update(scopePermissionRepresentation);
        }
        Keycloak testUserClient = AdminClientUtil.createAdminClient((boolean)true, (String)this.realm.toRepresentation().getRealm(), (String)"test-user", (String)"password", (String)"admin-cli", (String)"");
        return testUserClient.realm(this.realm.toRepresentation().getRealm());
    }

    private List<GroupRepresentation> setupUsersInGroupsWithPermissions() {
        GroupRepresentation grp1 = this.createGroupWithPermissions("grp1");
        GroupRepresentation grp2 = this.createGroupWithPermissions("grp2");
        String user1Id = this.createUser(this.realmId, "user1", "password", "user1FirstName", "user1LastName", "user1@example.com");
        String user2Id = this.createUser(this.realmId, "user2", "password", "user2FirstName", "user2LastName", "user2@example.com");
        String user3Id = this.createUser(this.realmId, "user3", "password", "user3FirstName", "user3LastName", "user3@example.com");
        String user4Id = this.createUser(this.realmId, "user4", "password", "user4FirstName", "user4LastName", "user4@example.com");
        this.realm.users().get(user1Id).joinGroup(grp1.getId());
        this.realm.users().get(user2Id).joinGroup(grp1.getId());
        this.realm.users().get(user3Id).joinGroup(grp1.getId());
        this.realm.users().get(user4Id).joinGroup(grp2.getId());
        ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>();
        groups.add(grp1);
        groups.add(grp2);
        return groups;
    }

    private GroupRepresentation createGroupWithPermissions(String name) {
        GroupRepresentation grp = new GroupRepresentation();
        grp.setName(name);
        this.realm.groups().add(grp);
        Optional<GroupRepresentation> optional = this.realm.groups().groups().stream().filter(g -> g.getName().equals(name)).findFirst();
        Assert.assertThat((Object)optional.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        grp = optional.get();
        String id = grp.getId();
        this.realm.groups().group(id).setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertThat((Object)this.realm.groups().group(id).getPermissions().isEnabled(), (Matcher)CoreMatchers.is((Object)true));
        return grp;
    }
}

