/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.representations.idm.LDAPCapabilityRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableVault;
import org.keycloak.testsuite.util.LDAPRule;

@EnableVault
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserFederationLdapConnectionTest
extends AbstractAdminTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Test
    public void testLdapConnections1() {
        Response response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("unknown", "ldap://localhost:10389", "foo", "bar", "false", null));
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testConnection", "ldap://localhostt:10389", "foo", "bar", "false", null));
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testConnection", "ldap://localhost:10389", "foo", "bar", "false", null, "false", "none"));
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testAuthentication", "ldap://localhost:10389", "foo", "bar", "false", "10000"));
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testAuthentication", "ldap://localhost:10389", "uid=admin,ou=system", "secret", "false", null));
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testAuthentication", "ldap://localhost:10389", "uid=admin,ou=system", "${vault.ldap_bindCredential}", "false", null));
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testAuthentication", "ldap://localhost:10389", "uid=admin,ou=system", "${vault.ldap_bindCredential}", "false", null));
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection("testAuthentication", "ldap://localhost:10389", "uid=admin,ou=system", "${vault.ldap_bindCredential}", "false", null);
        this.assertStatus(response, 204);
    }

    @Test
    public void testLdapConnectionsSsl() {
        Response response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testConnection", "ldaps://localhost:10636", "foo", "bar", "false", null, null, "none"));
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testConnection", "ldaps://localhostt:10636", "foo", "bar", "false", null));
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testAuthentication", "ldaps://localhost:10636", "foo", "bar", "false", null));
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testAuthentication", "ldaps://localhost:10636", "uid=admin,ou=system", "secret", "true", null));
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testAuthentication", "ldaps://localhost:10636", "uid=admin,ou=system", "secret", "true", "10000"));
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection(new TestLdapConnectionRepresentation("testAuthentication", "ldaps://localhost:10636", "uid=admin,ou=system", "${vault.ldap_bindCredential}", "true", null));
        this.assertStatus(response, 204);
    }

    @Test
    public void testLdapCapabilities() {
        TestLdapConnectionRepresentation config = new TestLdapConnectionRepresentation("queryServerCapabilities", "ldap://localhost:10389", "uid=admin,ou=system", "secret", "false", null, "false", "simple");
        List ldapCapabilities = this.realm.ldapServerCapabilities(config);
        Assert.assertThat((Object)ldapCapabilities, (Matcher)Matchers.hasItem((Object)new LDAPCapabilityRepresentation((Object)"1.3.6.1.4.1.4203.1.11.1", LDAPCapabilityRepresentation.CapabilityType.EXTENSION)));
        try {
            config = new TestLdapConnectionRepresentation("queryServerCapabilities", "ldap://localhost:10389", "foo", "bar", "false", null, "false", "simple");
            this.realm.ldapServerCapabilities(config);
            Assert.fail((String)"It wasn't expected to successfully sent the request for query capabilities");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
    }

    private void assertStatus(Response response, int status) {
        Assert.assertEquals((long)status, (long)response.getStatus());
        response.close();
    }
}

