/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.UserBuilder;

public class SMTPConnectionTest
extends AbstractKeycloakTest {
    public final String SMTP_PASSWORD = this.setSmtpPassword();
    @Rule
    public GreenMailRule greenMailRule = new GreenMailRule();
    private RealmResource realm;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    public String setSmtpPassword() {
        return "admin";
    }

    @Before
    public void before() {
        this.realm = this.adminClient.realm("master");
        List admin = this.realm.users().search("admin", Integer.valueOf(0), Integer.valueOf(1));
        UserRepresentation user = UserBuilder.edit((UserRepresentation)admin.get(0)).email("admin@localhost").build();
        this.realm.users().get(user.getId()).update(user);
    }

    private Map<String, String> settings(String host, String port, String from, String auth, String ssl, String starttls, String username, String password) throws Exception {
        return this.smtpMap(host, port, from, auth, ssl, starttls, username, password, "", "");
    }

    private Map<String, String> smtpMap(String host, String port, String from, String auth, String ssl, String starttls, String username, String password, String replyTo, String envelopeFrom) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("host", host);
        config.put("port", port);
        config.put("from", from);
        config.put("auth", auth);
        config.put("ssl", ssl);
        config.put("starttls", starttls);
        config.put("user", username);
        config.put("password", password);
        config.put("replyTo", replyTo);
        config.put("envelopeFrom", envelopeFrom);
        return config;
    }

    @Test
    public void testWithNullSettings() throws Exception {
        Response response = this.realm.testSMTPConnection(this.settings(null, null, null, null, null, null, null, null));
        this.assertStatus(response, 500);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testWithProperSettings() throws Exception {
        Response response = this.realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", null, null, null, null, null));
        this.assertStatus(response, 204);
        this.assertMailReceived();
    }

    @Test
    public void testWithAuthEnabledCredentialsEmpty() throws Exception {
        Response response = this.realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, null, null));
        this.assertStatus(response, 500);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testWithAuthEnabledValidCredentials() throws Exception {
        this.greenMailRule.credentials("admin@localhost", "admin");
        Response response = this.realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", this.SMTP_PASSWORD));
        this.assertStatus(response, 204);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testAuthEnabledAndSavedCredentials() throws Exception {
        RealmRepresentation realmRep = this.realm.toRepresentation();
        Map oldSmtp = realmRep.getSmtpServer();
        try {
            realmRep.setSmtpServer(this.smtpMap("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", this.SMTP_PASSWORD, null, null));
            this.realm.update(realmRep);
            this.greenMailRule.credentials("admin@localhost", "admin");
            Response response = this.realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", "**********"));
            this.assertStatus(response, 204);
        }
        finally {
            realmRep.setSmtpServer(oldSmtp);
            this.realm.update(realmRep);
        }
    }

    private void assertStatus(Response response, int status) {
        Assert.assertEquals((long)status, (long)response.getStatus());
        response.close();
    }

    private void assertMailReceived() {
        if (this.greenMailRule.getReceivedMessages().length == 1) {
            try {
                MimeMessage message = this.greenMailRule.getReceivedMessages()[0];
                Assert.assertEquals((Object)"[KEYCLOAK] - SMTP test message", (Object)message.getSubject());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Assert.fail((String)"E-mail was not received");
        }
    }
}

