/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.ManagementPermissionRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;

public class ManagementPermissionsTest
extends AbstractTestRealmKeycloakTest {
    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void updateGroupPermissions() {
        RealmResource realmResource = this.adminClient.realms().realm("test");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("perm-group-test");
        Response response = realmResource.groups().add(group);
        String id = ApiUtil.getCreatedId((Response)response);
        GroupResource groupResource = realmResource.groups().group(id);
        ManagementPermissionReference result = groupResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
    }

    @Test
    public void updateClientPermissions() {
        RealmResource realmResource = this.adminClient.realms().realm("test");
        ClientRepresentation clientRepresentation = new ClientRepresentation();
        clientRepresentation.setName("perm-client-test");
        Response response = realmResource.clients().create(clientRepresentation);
        String id = ApiUtil.getCreatedId((Response)response);
        ClientResource clientResource = realmResource.clients().get(id);
        ManagementPermissionReference result = clientResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
    }

    @Test
    public void updateRealmRolePermissions() {
        RealmResource realmResource = this.adminClient.realms().realm("test");
        RoleRepresentation roleRepresentation = new RoleRepresentation();
        roleRepresentation.setName("perm-role-test");
        realmResource.roles().create(roleRepresentation);
        RoleResource roleResource = realmResource.roles().get("perm-role-test");
        ManagementPermissionReference result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
    }

    @Test
    public void updateClientRolePermissions() {
        RealmResource realmResource = this.adminClient.realms().realm("test");
        ClientRepresentation clientRepresentation = new ClientRepresentation();
        clientRepresentation.setName("perm-client-test");
        Response response = realmResource.clients().create(clientRepresentation);
        String id = ApiUtil.getCreatedId((Response)response);
        ClientResource clientResource = realmResource.clients().get(id);
        RoleRepresentation roleRepresentation = new RoleRepresentation();
        roleRepresentation.setName("perm-client-role-test");
        clientResource.roles().create(roleRepresentation);
        RoleResource roleResource = clientResource.roles().get("perm-client-role-test");
        ManagementPermissionReference result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEnabled());
    }
}

