/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientInitialAccessResource;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.AdminEventPaths;

public class InitialAccessTokenResourceTest
extends AbstractAdminTest {
    private ClientInitialAccessResource resource;

    @Before
    public void before() {
        this.resource = this.realm.clientInitialAccess();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testInitialAccessTokens() {
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(2));
        rep.setExpiration(Integer.valueOf(100));
        int time = Time.currentTime();
        ClientInitialAccessPresentation response = this.resource.create(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientInitialAccessPath(response.getId()), (Object)rep, ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        org.junit.Assert.assertNotNull((Object)response.getId());
        org.junit.Assert.assertEquals((Object)new Integer(2), (Object)response.getCount());
        org.junit.Assert.assertEquals((Object)new Integer(2), (Object)response.getRemainingCount());
        org.junit.Assert.assertEquals((Object)new Integer(100), (Object)response.getExpiration());
        org.junit.Assert.assertThat((Object)response.getTimestamp(), (Matcher)CoreMatchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(time)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(Time.currentTime()))));
        org.junit.Assert.assertNotNull((Object)response.getToken());
        rep.setCount(Integer.valueOf(3));
        response = this.resource.create(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientInitialAccessPath(response.getId()), (Object)rep, ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        rep.setCount(Integer.valueOf(4));
        response = this.resource.create(rep);
        String lastId = response.getId();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientInitialAccessPath(lastId), (Object)rep, ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        List list = this.resource.list();
        org.junit.Assert.assertEquals((long)3L, (long)list.size());
        org.junit.Assert.assertEquals((long)9L, (long)(((ClientInitialAccessPresentation)list.get(0)).getCount() + ((ClientInitialAccessPresentation)list.get(1)).getCount() + ((ClientInitialAccessPresentation)list.get(2)).getCount()));
        org.junit.Assert.assertNull((Object)((ClientInitialAccessPresentation)list.get(0)).getToken());
        this.resource.delete(lastId);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientInitialAccessPath(lastId), ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        list = this.resource.list();
        org.junit.Assert.assertEquals((long)2L, (long)list.size());
        org.junit.Assert.assertEquals((long)5L, (long)(((ClientInitialAccessPresentation)list.get(0)).getCount() + ((ClientInitialAccessPresentation)list.get(1)).getCount()));
    }

    @Test
    public void testPeriodicExpiration() throws ClientRegistrationException, InterruptedException {
        ClientInitialAccessPresentation response1 = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(1), Integer.valueOf(1)));
        ClientInitialAccessPresentation response2 = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(1000), Integer.valueOf(1)));
        ClientInitialAccessPresentation response3 = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(1000), Integer.valueOf(0)));
        ClientInitialAccessPresentation response4 = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(1)));
        List list = this.resource.list();
        org.junit.Assert.assertEquals((long)4L, (long)list.size());
        this.setTimeOffset(10);
        this.testingClient.testing().removeExpired("admin-client-test");
        list = this.resource.list();
        org.junit.Assert.assertEquals((long)2L, (long)list.size());
        List remainingIds = list.stream().map(initialAccessPresentation -> initialAccessPresentation.getId()).collect(Collectors.toList());
        Assert.assertNames(remainingIds, response2.getId(), response4.getId());
        this.setTimeOffset(2000);
        this.testingClient.testing().removeExpired("admin-client-test");
        list = this.resource.list();
        org.junit.Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)((ClientInitialAccessPresentation)list.get(0)).getId(), (Object)response4.getId());
        this.realm.clientInitialAccess().delete(response4.getId());
    }
}

