/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.AdminRoles;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.PermissionsTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.utils.tls.TLSUtils;

public class CrossRealmPermissionsTest
extends AbstractKeycloakTest {
    private static final String REALM_NAME = "crossrealm-test";
    private static final String REALM2_NAME = "crossrealm2-test";
    private static Keycloak adminClient1;
    private static Keycloak adminClient2;
    private RealmResource realm1;
    private RealmResource realm2;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder builder = RealmBuilder.create().name(REALM_NAME).testMail();
        builder.client(ClientBuilder.create().clientId("test-client").publicClient().directAccessGrants());
        builder.user(UserBuilder.create().username(AdminRoles.REALM_ADMIN).role("realm-management", AdminRoles.REALM_ADMIN).addPassword("password"));
        testRealms.add(builder.build());
        adminClient1 = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)REALM_NAME, (String)AdminRoles.REALM_ADMIN, (String)"password", (String)"test-client", (String)"secret", (SSLContext)TLSUtils.initializeTLS());
        this.realm1 = adminClient1.realm(REALM_NAME);
        builder = RealmBuilder.create().name(REALM2_NAME).testMail();
        builder.client(ClientBuilder.create().clientId("test-client").publicClient().directAccessGrants());
        builder.user(UserBuilder.create().username(AdminRoles.REALM_ADMIN).role("realm-management", AdminRoles.REALM_ADMIN).addPassword("password"));
        testRealms.add(builder.build());
        adminClient2 = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)REALM2_NAME, (String)AdminRoles.REALM_ADMIN, (String)"password", (String)"test-client", (String)"secret", (SSLContext)TLSUtils.initializeTLS());
        this.realm2 = adminClient2.realm(REALM2_NAME);
    }

    @AfterClass
    public static void afterClass() {
        adminClient1.close();
        adminClient2.close();
    }

    @Test
    public void users() {
        UserRepresentation user = UserBuilder.create().username("randomuser-" + Time.currentTimeMillis()).build();
        Response response = this.realm1.users().create(user);
        final String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.realm1.users().get(userId).toRepresentation();
        this.expectNotFound(new PermissionsTest.Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(userId).toRepresentation();
            }
        }, this.realm2);
        this.expectNotFound(new PermissionsTest.Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(userId).update(new UserRepresentation());
            }
        }, this.realm2);
        this.expectNotFound(new PermissionsTest.Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(userId).remove();
            }
        }, this.realm2);
        this.expectNotFound(new PermissionsTest.Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(userId).getUserSessions();
            }
        }, this.realm2);
    }

    private void expectNotFound(final PermissionsTest.Invocation invocation, RealmResource realm) {
        this.expectNotFound(new PermissionsTest.InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                invocation.invoke(realm);
            }
        }, realm);
    }

    private void expectNotFound(PermissionsTest.InvocationWithResponse invocation, RealmResource realm) {
        int statusCode = 0;
        try {
            AtomicReference<Response> responseReference = new AtomicReference<Response>();
            invocation.invoke(realm, responseReference);
            Response response = responseReference.get();
            if (response != null) {
                statusCode = response.getStatus();
            } else {
                Assert.fail((String)"Expected failure");
            }
        }
        catch (ClientErrorException e) {
            statusCode = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)404L, (long)statusCode);
    }
}

