/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.InputStream;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AuthzCleanupTest
extends AbstractKeycloakTest {
    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("test").client(ClientBuilder.create().clientId("myclient").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/myclient").defaultRoles("client-role-1", "client-role-2", "Acme administrator", "Acme viewer", "tenant administrator", "tenant viewer", "tenant user").build()).build());
    }

    public static void setup(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        session.getContext().setRealm(realm);
        AuthorizationProvider authz = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel myclient = realm.getClientByClientId("myclient");
        ResourceServer resourceServer = authz.getStoreFactory().getResourceServerStore().findById(myclient.getId());
        AuthzCleanupTest.createRolePolicy(authz, resourceServer, myclient.getClientId() + "/client-role-1");
        AuthzCleanupTest.createRolePolicy(authz, resourceServer, myclient.getClientId() + "/client-role-2");
    }

    private static Policy createRolePolicy(AuthorizationProvider authz, ResourceServer resourceServer, String roleName) {
        RolePolicyRepresentation representation = new RolePolicyRepresentation();
        representation.setName(roleName);
        representation.setType("role");
        representation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        representation.setLogic(Logic.POSITIVE);
        representation.addRole(roleName, true);
        return authz.getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)representation, resourceServer);
    }

    @Test
    public void testCreate() throws Exception {
        ClientsResource clients = this.getAdminClient().realms().realm("test").clients();
        ClientRepresentation client = (ClientRepresentation)clients.findByClientId("myclient").get(0);
        ResourceServerRepresentation settings = (ResourceServerRepresentation)JsonSerialization.readValue((InputStream)this.getClass().getResourceAsStream("/authorization-test/acme-resource-server-cleanup-test.json"), ResourceServerRepresentation.class);
        clients.get(client.getId()).authorization().importSettings(settings);
        this.testingClient.server().run(AuthzCleanupTest::setup);
    }
}

