/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.TokenVerifier;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.TokenSignatureUtil;

public class AdminSignatureAlgorithmTest
extends AbstractKeycloakTest {
    private CloseableHttpClient client;

    @Before
    public void before() {
        this.client = HttpClientBuilder.create().build();
    }

    @After
    public void after() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void changeRealmTokenAlgorithm() throws Exception {
        String defaultSignatureAlgorithm = this.adminClient.realm("master").toRepresentation().getDefaultSignatureAlgorithm();
        TokenSignatureUtil.changeRealmTokenSignatureProvider((String)"master", (Keycloak)this.adminClient, (String)"ES256");
        try (Keycloak adminClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)this.suiteContext.getAuthServerInfo().getContextRoot().toString());){
            AccessTokenResponse accessToken = adminClient.tokenManager().getAccessToken();
            TokenVerifier verifier = TokenVerifier.create((String)accessToken.getToken(), AccessToken.class);
            Assert.assertEquals((Object)"ES256", (Object)verifier.getHeader().getAlgorithm().name());
            Assert.assertNotNull((Object)adminClient.realms().findAll());
            String whoAmiUrl = this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/admin/master/console/whoami";
            JsonNode jsonNode = SimpleHttp.doGet((String)whoAmiUrl, (HttpClient)this.client).auth(accessToken.getToken()).asJson();
            Assert.assertNotNull((Object)jsonNode.get("realm"));
            Assert.assertNotNull((Object)jsonNode.get("userId"));
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((String)"master", (Keycloak)this.adminClient, (String)defaultSignatureAlgorithm);
        }
    }
}

