/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.testsuite.admin.AbstractAdminTest;

public class AdminPreflightTest
extends AbstractAdminTest {
    private CloseableHttpClient client;

    @Before
    public void before() {
        this.client = HttpClientBuilder.create().build();
    }

    @After
    public void after() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testPreflight() throws IOException {
        HttpOptions options = new HttpOptions(this.getAdminUrl("realms/master/users"));
        options.setHeader("Origin", "http://test");
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)options);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"true", (Object)response.getFirstHeader("Access-Control-Allow-Credentials").getValue());
        Assert.assertEquals((Object)"DELETE, POST, GET, PUT", (Object)response.getFirstHeader("Access-Control-Allow-Methods").getValue());
        Assert.assertEquals((Object)"http://test", (Object)response.getFirstHeader("Access-Control-Allow-Origin").getValue());
        Assert.assertEquals((Object)"3600", (Object)response.getFirstHeader("Access-Control-Max-Age").getValue());
        Assert.assertTrue((boolean)response.getFirstHeader("Access-Control-Allow-Headers").getValue().contains("Authorization"));
        Assert.assertTrue((boolean)response.getFirstHeader("Access-Control-Allow-Headers").getValue().contains("Content-Type"));
    }

    private String getAdminUrl(String resource) {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/admin/" + resource;
    }
}

