/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.UserBuilder;

public class AdminHeadersTest
extends AbstractAdminTest {
    private CloseableHttpClient client;

    @Before
    public void before() {
        this.client = HttpClientBuilder.create().build();
    }

    @After
    public void after() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testHeaders() {
        Response response = this.realm.users().create(UserBuilder.create().username("headers-user").build());
        MultivaluedMap h = response.getHeaders();
        this.assertDefaultValue(BrowserSecurityHeaders.STRICT_TRANSPORT_SECURITY, (MultivaluedMap<String, Object>)h);
        this.assertDefaultValue(BrowserSecurityHeaders.X_FRAME_OPTIONS, (MultivaluedMap<String, Object>)h);
        this.assertDefaultValue(BrowserSecurityHeaders.X_CONTENT_TYPE_OPTIONS, (MultivaluedMap<String, Object>)h);
        this.assertDefaultValue(BrowserSecurityHeaders.X_XSS_PROTECTION, (MultivaluedMap<String, Object>)h);
        this.assertDefaultValue(BrowserSecurityHeaders.REFERRER_POLICY, (MultivaluedMap<String, Object>)h);
        response.close();
    }

    private void assertDefaultValue(BrowserSecurityHeaders header, MultivaluedMap<String, Object> h) {
        Assert.assertThat((Object)h.getFirst((Object)header.getHeaderName()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)header.getDefaultValue())));
    }

    private String getAdminUrl(String resource) {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/admin/" + resource;
    }
}

