/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet.crossdc;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.keycloak.testsuite.adapter.AbstractSAMLAdapterClusteredTest;
import org.keycloak.testsuite.adapter.servlet.SendUsernameServlet;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.annotation.InitialDcState;
import org.keycloak.testsuite.arquillian.containers.InfinispanServerDeployableContainer;
import org.keycloak.testsuite.crossdc.ServerSetup;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly-ha-node-1;app-server-wildfly-ha-node-2"), @AppServerContainer(value="app-server-wildfly-deprecated-ha-node-1;app-server-wildfly-deprecated-ha-node-2"), @AppServerContainer(value="app-server-eap-ha-node-1;app-server-eap-ha-node-2")})
@InitialDcState(authServers=ServerSetup.FIRST_NODE_IN_EVERY_DC, cacheServers=ServerSetup.FIRST_NODE_IN_EVERY_DC)
public class SAMLAdapterCrossDCTest
extends AbstractSAMLAdapterClusteredTest {
    private static final String SESSION_CACHE_NAME = "employee-distributable-cache";
    private static final String JBOSS_WEB_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<jboss-web>\n    <replication-config>\n        <replication-granularity>SESSION</replication-granularity>\n        <cache-name>web.employee-distributable-cache</cache-name>\n    </replication-config>\n</jboss-web>";

    @BeforeClass
    public static void checkCrossDcTest() {
        Assume.assumeThat((String)"Seems not to be running cross-DC tests", (Object)System.getProperty("cache.server"), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        Assume.assumeFalse((String)String.format("%s not supported with `cache-auth` profile.", SAMLAdapterCrossDCTest.class), (boolean)InfinispanServerDeployableContainer.CACHE_SERVER_AUTH);
    }

    @TargetsContainer(value="app-server-currentha-node-1")
    @Deployment(name="employee-distributable", managed=false)
    protected static WebArchive employee() {
        return (WebArchive)SAMLAdapterCrossDCTest.samlServletDeployment("employee-distributable", "employee-distributable/WEB-INF/web.xml", SendUsernameServlet.class).addAsWebInfResource((Asset)new StringAsset(JBOSS_WEB_XML), "jboss-web.xml");
    }

    @TargetsContainer(value="app-server-currentha-node-2")
    @Deployment(name="employee-distributable_2", managed=false)
    protected static WebArchive employee2() {
        return SAMLAdapterCrossDCTest.employee();
    }

    @Override
    protected void prepareServerDirectories() throws Exception {
        this.prepareServerDirectory("standalone-crossdc", "standalone-ha-node-1");
        this.prepareServerDirectory("standalone-crossdc", "standalone-ha-node-2");
    }
}

