/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet.cluster;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.util.Retry;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractAdapterClusteredTest;
import org.keycloak.testsuite.adapter.page.SessionPortalDistributable;
import org.keycloak.testsuite.adapter.servlet.SessionServlet;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.support.ui.WebDriverWait;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly-ha-node-1;app-server-wildfly-ha-node-2"), @AppServerContainer(value="app-server-wildfly-deprecated-ha-node-1;app-server-wildfly-deprecated-ha-node-2"), @AppServerContainer(value="app-server-eap-ha-node-1;app-server-eap-ha-node-2"), @AppServerContainer(value="app-server-eap6-ha-node-1;app-server-eap6-ha-node-2")})
public class OIDCAdapterClusterTest
extends AbstractAdapterClusteredTest {
    @Page
    protected OIDCLogin loginPage;
    @Page
    protected SessionPortalDistributable sessionPortalPage;

    @TargetsContainer(value="app-server-currentha-node-1")
    @Deployment(name="session-portal-distributable", managed=false)
    protected static WebArchive sessionPortalNode1() {
        return OIDCAdapterClusterTest.servletDeployment("session-portal-distributable", "keycloak.json", SessionServlet.class);
    }

    @TargetsContainer(value="app-server-currentha-node-2")
    @Deployment(name="session-portal-distributable_2", managed=false)
    protected static WebArchive sessionPortalNode2() {
        return OIDCAdapterClusterTest.servletDeployment("session-portal-distributable", "keycloak.json", SessionServlet.class);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.addAdapterTestRealms(testRealms);
        if (!"localhost".equals(ServerURLs.APP_SERVER_HOST)) {
            for (RealmRepresentation realm : testRealms) {
                Optional<ClientRepresentation> clientRepresentation = realm.getClients().stream().filter(c -> c.getClientId().equals("session-portal-distributable")).findFirst();
                clientRepresentation.ifPresent(cr -> {
                    cr.setAdminUrl(cr.getAdminUrl().replace("localhost", ServerURLs.APP_SERVER_HOST));
                    cr.setBaseUrl(cr.getBaseUrl().replace("localhost", ServerURLs.APP_SERVER_HOST));
                    cr.setRedirectUris(cr.getRedirectUris().stream().map(url -> url.replace("localhost", ServerURLs.APP_SERVER_HOST)).collect(Collectors.toList()));
                });
            }
        }
    }

    @Override
    protected void deploy() {
        this.deployer.deploy("session-portal-distributable");
        this.deployer.deploy("session-portal-distributable_2");
    }

    @Override
    protected void undeploy() {
        this.deployer.undeploy("session-portal-distributable");
        this.deployer.undeploy("session-portal-distributable_2");
    }

    @Before
    public void onBefore() {
        this.loginPage.setAuthRealm("demo");
    }

    @Test
    public void testSuccessfulLoginAndBackchannelLogout(@ArquillianResource @OperateOnDeployment(value="session-portal-distributable") URL appUrl) {
        String proxiedUrl = this.getProxiedUrl(appUrl);
        this.driver.navigate().to(proxiedUrl);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPage);
        this.loginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals(proxiedUrl);
        this.assertSessionCounter("ha-node-2", NODE_2_URI, NODE_1_URI, proxiedUrl, 2);
        this.assertSessionCounter("ha-node-1", NODE_1_URI, NODE_2_URI, proxiedUrl, 3);
        this.assertSessionCounter("ha-node-2", NODE_2_URI, NODE_1_URI, proxiedUrl, 4);
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{proxiedUrl}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        Retry.execute(() -> {
            this.driver.navigate().to(proxiedUrl);
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPage);
        }, (int)10, (long)300L);
    }

    @Test
    public void testSuccessfulLoginAndProgrammaticLogout(@ArquillianResource @OperateOnDeployment(value="session-portal-distributable") URL appUrl) {
        String proxiedUrl = this.getProxiedUrl(appUrl);
        this.driver.navigate().to(proxiedUrl);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPage);
        this.loginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals(proxiedUrl);
        this.assertSessionCounter("ha-node-2", NODE_2_URI, NODE_1_URI, proxiedUrl, 2);
        this.assertSessionCounter("ha-node-1", NODE_1_URI, NODE_2_URI, proxiedUrl, 3);
        this.assertSessionCounter("ha-node-2", NODE_2_URI, NODE_1_URI, proxiedUrl, 4);
        String logoutUri = proxiedUrl + "/logout";
        this.driver.navigate().to(logoutUri);
        Retry.execute(() -> {
            this.driver.navigate().to(proxiedUrl);
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPage);
        }, (int)10, (long)300L);
    }

    private void waitForCacheReplication(String appUrl, int expectedCount) {
        new WebDriverWait(DroneUtils.getCurrentDriver(), 5L).until(driver -> {
            driver.navigate().to(appUrl + "/donotincrease");
            WaitUtils.waitForPageToLoad();
            return driver.getPageSource().contains("Counter=" + expectedCount) && driver.getPageSource().contains("CounterWrapper=" + expectedCount);
        });
    }

    private void assertSessionCounter(String hostToPointToName, URI hostToPointToUri, URI hostToRemove, String appUrl, int expectedCount) {
        this.updateProxy(hostToPointToName, hostToPointToUri, hostToRemove);
        this.waitForCacheReplication(appUrl, expectedCount - 1);
        this.driver.navigate().to(appUrl);
        WaitUtils.waitForPageToLoad();
        String pageSource = this.driver.getPageSource();
        Assert.assertThat((Object)pageSource, (Matcher)CoreMatchers.containsString((String)("Counter=" + expectedCount)));
        Assert.assertThat((Object)pageSource, (Matcher)CoreMatchers.containsString((String)("CounterWrapper=" + expectedCount)));
        Assert.assertThat((Object)pageSource, (Matcher)CoreMatchers.containsString((String)("Node name=" + hostToPointToName)));
    }
}

