/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.CustomerPortalSubsystem;
import org.keycloak.testsuite.adapter.page.ProductPortalSubsystem;
import org.keycloak.testsuite.adapter.servlet.CustomerDatabaseServlet;
import org.keycloak.testsuite.adapter.servlet.CustomerServlet;
import org.keycloak.testsuite.adapter.servlet.ErrorServlet;
import org.keycloak.testsuite.adapter.servlet.ProductServlet;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.containers.SelfManagedAppContainerLifecycle;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.operations.OperationException;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
public class SecuredDeploymentsAdapterTest
extends AbstractServletsAdapterTest
implements SelfManagedAppContainerLifecycle {
    @ArquillianResource
    private ContainerController controller;
    @Page
    private CustomerPortalSubsystem customerPortalSubsystem;
    @Page
    private ProductPortalSubsystem productPortalSubsystem;

    @Deployment(name="customer-portal-subsystem")
    protected static WebArchive customerPortalSubsystem() {
        return SecuredDeploymentsAdapterTest.servletDeployment("customer-portal-subsystem", CustomerServlet.class, ErrorServlet.class, ServletTestUtils.class);
    }

    @Deployment(name="product-portal-subsystem")
    protected static WebArchive productPortalSubsystem() {
        return SecuredDeploymentsAdapterTest.servletDeployment("product-portal-subsystem", ProductServlet.class);
    }

    @Deployment(name="customer-db")
    protected static WebArchive customerDb() {
        return SecuredDeploymentsAdapterTest.servletDeployment("customer-db", AdapterActionsFilter.class, CustomerDatabaseServlet.class);
    }

    @BeforeClass
    public static void assumeTLSEnabled() {
        Assume.assumeTrue((boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
    }

    @Before
    public void startServer() throws InterruptedException, IOException, OperationException, TimeoutException, CommandFailedException, CliException {
        try {
            AppServerTestEnricher.prepareServerDir((String)"standalone-secured-deployments");
        }
        catch (IOException ex) {
            throw new RuntimeException("Wasn't able to prepare server dir.", ex);
        }
        this.controller.start(this.testContext.getAppServerInfo().getQualifier());
        if (!sslConfigured && super.shouldConfigureSSL()) {
            AppServerTestEnricher.enableHTTPSForAppServer();
            sslConfigured = true;
        }
    }

    @Override
    public boolean shouldConfigureSSL() {
        return false;
    }

    @After
    public void stopServer() {
        this.controller.stop(this.testContext.getAppServerInfo().getQualifier());
    }

    @Test
    public void testSecuredDeployments() {
        this.customerPortalSubsystem.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        this.assertPageContains("Bill Burke");
        this.assertPageContains("Stian Thorgersen");
        this.productPortalSubsystem.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.productPortalSubsystem);
        this.assertPageContains("iPhone");
        this.assertPageContains("iPad");
    }

    private void assertPageContains(String string) {
        String pageSource = this.driver.getPageSource();
        Assert.assertThat((Object)pageSource, (Matcher)Matchers.containsString((String)string));
    }
}

