/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.saml.SAML2ErrorResponseBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.constants.X500SAMLProfileConstants;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.Employee2Servlet;
import org.keycloak.testsuite.adapter.page.EmployeeSigServlet;
import org.keycloak.testsuite.adapter.servlet.AbstractSAMLServletAdapterTest;
import org.keycloak.testsuite.adapter.servlet.SendUsernameServlet;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.auth.page.login.Login;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.openqa.selenium.By;
import org.w3c.dom.Document;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9"), @AppServerContainer(value="app-server-jetty92"), @AppServerContainer(value="app-server-jetty93"), @AppServerContainer(value="app-server-jetty94")})
public class SAMLLoginResponseHandlingTest
extends AbstractSAMLServletAdapterTest {
    @Page
    protected Employee2Servlet employee2ServletPage;
    @Page
    protected EmployeeSigServlet employeeSigServletPage;

    @Deployment(name="employee2")
    protected static WebArchive employee2() {
        return SAMLLoginResponseHandlingTest.samlServletDeployment("employee2", "web-with-action-filter.xml", SendUsernameServlet.class, AdapterActionsFilter.class, PublicKeyLocator.class);
    }

    @Deployment(name="employee-sig")
    protected static WebArchive employeeSig() {
        return SAMLLoginResponseHandlingTest.samlServletDeployment("employee-sig", SendUsernameServlet.class);
    }

    @Test
    public void testNilAttributeValueAttribute() {
        ((ModifySamlResponseStepBuilder)this.beginAuthenticationAndLogin((AbstractPage)this.employee2ServletPage, SamlClient.Binding.POST).processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
            AttributeStatementType attributeType = (AttributeStatementType)statements.stream().filter(statement -> statement instanceof AttributeStatementType).findFirst().orElse((StatementAbstractType)new AttributeStatementType());
            AttributeType attr = new AttributeType("attribute-with-null-attribute-value");
            attr.addAttributeValue(null);
            attributeType.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
            ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().addStatement((StatementAbstractType)attributeType);
            return ob;
        })).build().navigateTo(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0])).execute(response -> {
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
            Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"attribute-with-null-attribute-value: <br />")));
        });
    }

    @Test
    public void testErrorHandlingUnsigned() throws Exception {
        SAML2ErrorResponseBuilder builder = new SAML2ErrorResponseBuilder().destination(this.employeeSigServletPage.toString() + "saml").issuer("http://localhost:" + System.getProperty("auth.server.http.port", "8180") + "/realms/demo").status(JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get());
        Document document = builder.buildDocument();
        new SamlClientBuilder().addStep((client, currentURI, currentResponse, context) -> SamlClient.Binding.REDIRECT.createSamlUnsignedResponse(URI.create(this.employeeSigServletPage.toString() + "/saml"), null, document)).execute(closeableHttpResponse -> Assert.assertThat((Object)closeableHttpResponse, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"INVALID_SIGNATURE"))));
    }

    @Test
    public void testErrorHandlingSigned() throws Exception {
        SAML2ErrorResponseBuilder builder = new SAML2ErrorResponseBuilder().destination(this.employeeSigServletPage.toString() + "saml").issuer("http://localhost:" + System.getProperty("auth.server.http.port", "8180") + "/realms/demo").status(JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get());
        Document document = builder.buildDocument();
        new SamlClientBuilder().addStep((client, currentURI, currentResponse, context) -> SamlClient.Binding.REDIRECT.createSamlSignedResponse(URI.create(this.employeeSigServletPage.toString() + "/saml"), null, document, "MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB")).execute(closeableHttpResponse -> Assert.assertThat((Object)closeableHttpResponse, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"ERROR_STATUS"))));
    }

    @Test
    public void testAttributes() throws Exception {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"http://localhost:8280/employee2/");
        ProtocolMappersResource protocolMappersResource = clientResource.getProtocolMappers();
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        config.put("attribute.nameformat", "Basic");
        config.put("user.attribute", "topAttribute");
        config.put("attribute.name", "topAttribute");
        this.getCleanup().addCleanup(this.createProtocolMapper(protocolMappersResource, "topAttribute", "saml", "saml-user-attribute-mapper", config));
        config = new LinkedHashMap();
        config.put("attribute.nameformat", "Basic");
        config.put("user.attribute", "level2Attribute");
        config.put("attribute.name", "level2Attribute");
        this.getCleanup().addCleanup(this.createProtocolMapper(protocolMappersResource, "level2Attribute", "saml", "saml-user-attribute-mapper", config));
        config = new LinkedHashMap();
        config.put("attribute.nameformat", "Basic");
        config.put("single", "true");
        config.put("attribute.name", "group");
        this.getCleanup().addCleanup(this.createProtocolMapper(protocolMappersResource, "groups", "saml", "saml-group-membership-mapper", config));
        this.setRolesToCheck("manager,user");
        this.employee2ServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmSAMLPostLoginPage.form().login("level2GroupUser", "password");
        this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0]).toURL());
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("topAttribute: true");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("level2Attribute: true");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains(X500SAMLProfileConstants.EMAIL.get() + ": level2@redhat.com");
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("group: []");
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("group: null");
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("group: <br />");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("group: level2");
        this.employee2ServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
        this.setRolesToCheck("manager,employee,user");
        this.employee2ServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0]).toURL());
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains(X500SAMLProfileConstants.EMAIL.get() + ": bburke@redhat.com");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("friendly email: bburke@redhat.com");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("phone: 617");
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("friendly phone:");
        this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("getAssertionFromDocument").build(new Object[0]).toURL());
        WaitUtils.waitForPageToLoad();
        Assert.assertEquals((Object)"", (Object)UIUtils.getRawPageSource());
        this.employee2ServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
        config = new LinkedHashMap();
        config.put("attribute.value", "hard");
        config.put("attribute.nameformat", "Basic");
        config.put("attribute.name", "hardcoded-attribute");
        this.getCleanup().addCleanup(this.createProtocolMapper(protocolMappersResource, "hardcoded-attribute", "saml", "saml-hardcode-attribute-mapper", config));
        config = new LinkedHashMap();
        config.put("role", "hardcoded-role");
        this.getCleanup().addCleanup(this.createProtocolMapper(protocolMappersResource, "hardcoded-role", "saml", "saml-hardcode-role-mapper", config));
        config = new LinkedHashMap();
        config.put("new.role.name", "pee-on");
        config.put("role", "http://localhost:8280/employee/.employee");
        this.getCleanup().addCleanup(this.createProtocolMapper(protocolMappersResource, "renamed-employee-role", "saml", "saml-role-name-mapper", config));
        for (ProtocolMapperRepresentation mapper : clientResource.toRepresentation().getProtocolMappers()) {
            if (!mapper.getName().equals("role-list")) continue;
            protocolMappersResource.delete(mapper.getId());
            HashMap origConfig = new HashMap(mapper.getConfig());
            mapper.setId(null);
            mapper.getConfig().put("single", "true");
            mapper.getConfig().put("attribute.name", "memberOf");
            Response response = protocolMappersResource.createMapper(mapper);
            try {
                String createdId = ApiUtil.getCreatedId((Response)response);
                this.getCleanup().addCleanup(() -> {
                    protocolMappersResource.delete(createdId);
                    mapper.setConfig(origConfig);
                    protocolMappersResource.createMapper(mapper).close();
                });
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        this.setRolesToCheck("pee-on,el-jefe,manager,hardcoded-role");
        config = new LinkedHashMap();
        config.put("new.role.name", "el-jefe");
        config.put("role", "user");
        this.getCleanup().addCleanup(this.createProtocolMapper(protocolMappersResource, "renamed-role", "saml", "saml-role-name-mapper", config));
        this.employee2ServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0]).toURL());
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("hardcoded-attribute: hard");
        this.employee2ServletPage.checkRolesEndPoint(false);
        this.employee2ServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    private void setRolesToCheck(String roles) throws Exception {
        this.employee2ServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("setCheckRoles").queryParam("roles", new Object[]{roles}).build(new Object[0]).toURL());
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).text().contains("These roles will be checked:");
        this.employee2ServletPage.logout();
    }
}

