/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.testsuite.adapter.servlet.SAMLServletAdapterTest;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.utils.annotation.UseServletFilter;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
@UseServletFilter(filterName="saml-filter", filterClass="org.keycloak.adapters.saml.servlet.SamlFilter", filterDependency="org.keycloak:keycloak-saml-servlet-filter-adapter")
public class SAMLFilterServletAdapterTest
extends SAMLServletAdapterTest {
    @BeforeClass
    public static void enabled() {
        String appServerJavaHome = System.getProperty("app.server.java.home", "");
        Assume.assumeFalse((appServerJavaHome.contains("1.7") || appServerJavaHome.contains("ibm-java-70") ? 1 : 0) != 0);
        ContainerAssume.assumeNotAppServerSSL();
    }

    @Before
    public void checkRoles() {
        this.badClientSalesPostSigServletPage.checkRoles(true);
        this.badRealmSalesPostSigServletPage.checkRoles(true);
        this.employeeAcsServletPage.checkRoles(true);
        this.employeeSigServletPage.checkRoles(true);
        this.employeeSigFrontServletPage.checkRoles(true);
        this.salesMetadataServletPage.checkRoles(true);
        this.salesPostServletPage.checkRoles(true);
        this.salesPostEncServletPage.checkRoles(true);
        this.salesPostEncSignAssertionsOnlyServletPage.checkRoles(true);
        this.salesPostSigServletPage.checkRoles(true);
        this.salesPostPassiveServletPage.checkRoles(true);
        this.salesPostSigPersistentServletPage.checkRoles(true);
        this.salesPostSigTransientServletPage.checkRoles(true);
        this.salesPostAssertionAndResponseSigPage.checkRoles(true);
        this.employeeSigPostNoIdpKeyServletPage.checkRoles(true);
        this.employeeSigRedirNoIdpKeyServletPage.checkRoles(true);
        this.employeeSigRedirOptNoIdpKeyServletPage.checkRoles(true);
        this.employeeRoleMappingPage.setupLoginInfo(this.testRealmSAMLPostLoginPage, this.bburkeUser);
        this.employee2ServletPage.navigateTo();
        this.testRealmLoginPage.form().login(this.bburkeUser);
        this.employee2ServletPage.checkRolesEndPoint(true);
        this.employee2ServletPage.logout();
        this.salesPostSigEmailServletPage.navigateTo();
        this.testRealmLoginPage.form().login(this.bburkeUser);
        this.salesPostSigEmailServletPage.checkRolesEndPoint(true);
        this.salesPostSigEmailServletPage.logout();
    }

    @After
    public void uncheckRoles() {
        this.badClientSalesPostSigServletPage.checkRoles(false);
        this.badRealmSalesPostSigServletPage.checkRoles(false);
        this.employeeAcsServletPage.checkRoles(false);
        this.employee2ServletPage.checkRoles(false);
        this.employeeSigServletPage.checkRoles(false);
        this.employeeSigFrontServletPage.checkRoles(false);
        this.salesMetadataServletPage.checkRoles(false);
        this.salesPostServletPage.checkRoles(false);
        this.salesPostEncServletPage.checkRoles(false);
        this.salesPostEncSignAssertionsOnlyServletPage.checkRoles(false);
        this.salesPostSigServletPage.checkRoles(false);
        this.salesPostPassiveServletPage.checkRoles(false);
        this.salesPostSigEmailServletPage.checkRoles(false);
        this.salesPostSigPersistentServletPage.checkRoles(false);
        this.salesPostSigTransientServletPage.checkRoles(false);
        this.employeeSigPostNoIdpKeyServletPage.checkRoles(false);
        this.employeeSigRedirNoIdpKeyServletPage.checkRoles(false);
        this.employeeSigRedirOptNoIdpKeyServletPage.checkRoles(false);
        this.employeeRoleMappingPage.clearLoginInfo();
    }

    @Override
    @Test
    @Ignore
    public void testSavedPostRequest() {
    }

    @Override
    @Test
    @Ignore
    public void multiTenant1SamlTest() throws Exception {
    }

    @Override
    @Test
    @Ignore
    public void multiTenant2SamlTest() throws Exception {
    }

    @Override
    @Test
    public void testAdapterRoleMappings() throws Exception {
        try {
            this.employeeRoleMappingPage.setRolesToCheck("manager,coordinator,team-lead,employee");
            super.testAdapterRoleMappings();
        }
        finally {
            this.employeeRoleMappingPage.checkRolesEndPoint(false);
        }
    }
}

