/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.SalesPostClockSkewServlet;
import org.keycloak.testsuite.adapter.servlet.AbstractSAMLServletAdapterTest;
import org.keycloak.testsuite.adapter.servlet.SendUsernameServlet;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.keycloak.testsuite.utils.io.IOUtil;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-jetty92"), @AppServerContainer(value="app-server-jetty93"), @AppServerContainer(value="app-server-jetty94")})
public class SAMLClockSkewAdapterTest
extends AbstractSAMLServletAdapterTest {
    @Page
    protected SalesPostClockSkewServlet salesPostClockSkewServletPage;
    private static final String DEPLOYMENT_NAME_3_SEC = "sales-post-clock-skew_3Sec";
    private static final String DEPLOYMENT_NAME_30_SEC = "sales-post-clock-skew_30Sec";
    @ArquillianResource
    private Deployer deployer;

    @Deployment(name="sales-post-clock-skew_3Sec", managed=false)
    protected static WebArchive salesPostClockSkewServlet3Sec() {
        return SAMLClockSkewAdapterTest.samlServletDeployment("sales-post-clock-skew", DEPLOYMENT_NAME_3_SEC, "sales-post-clock-skew/WEB-INF/web.xml", 3, AdapterActionsFilter.class, PublicKeyLocator.class, SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-clock-skew_30Sec", managed=false)
    protected static WebArchive salesPostClockSkewServlet30Sec() {
        return SAMLClockSkewAdapterTest.samlServletDeployment("sales-post-clock-skew", DEPLOYMENT_NAME_30_SEC, "sales-post-clock-skew/WEB-INF/web.xml", 30, AdapterActionsFilter.class, PublicKeyLocator.class, SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-clock-skew", managed=false)
    protected static WebArchive salesPostClockSkewServlet5Sec() {
        return SAMLClockSkewAdapterTest.samlServletDeployment("sales-post-clock-skew", "sales-post-clock-skew/WEB-INF/web.xml", 5, AdapterActionsFilter.class, PublicKeyLocator.class, SendUsernameServlet.class);
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/testsaml.json"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOutcome(int timeOffset, Matcher matcher) throws Exception {
        try {
            String resultPage = (String)((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.salesPostClockSkewServletPage.toString()).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(doc -> {
                this.setAdapterAndServerTimeOffset(timeOffset, this.salesPostClockSkewServletPage.toString());
                return doc;
            })).build().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
            Assert.assertThat((Object)resultPage, (Matcher)matcher);
        }
        catch (Throwable throwable) {
            this.setAdapterAndServerTimeOffset(0, this.salesPostClockSkewServletPage.toString());
            throw throwable;
        }
        this.setAdapterAndServerTimeOffset(0, this.salesPostClockSkewServletPage.toString());
    }

    private void assertTokenIsNotValid(int timeOffset) throws Exception {
        this.deployer.deploy(DEPLOYMENT_NAME_3_SEC);
        try {
            this.assertOutcome(timeOffset, Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.containsString((String)"request-path: principal=bburke")), (Matcher)Matchers.containsString((String)"SAMLRequest"), (Matcher)Matchers.containsString((String)"FORM METHOD=\"POST\"")));
        }
        finally {
            this.deployer.undeploy(DEPLOYMENT_NAME_3_SEC);
        }
    }

    @Test
    public void testTokenHasExpired() throws Exception {
        this.assertTokenIsNotValid(65);
    }

    @Test
    public void testTokenIsNotYetValid() throws Exception {
        this.assertTokenIsNotValid(-65);
    }

    @Test
    public void testTokenTimeIsValid() throws Exception {
        this.deployer.deploy(DEPLOYMENT_NAME_30_SEC);
        try {
            this.assertOutcome(-10, Matchers.allOf((Matcher)Matchers.containsString((String)"request-path:"), (Matcher)Matchers.containsString((String)"principal=bburke")));
        }
        finally {
            this.deployer.undeploy(DEPLOYMENT_NAME_30_SEC);
        }
    }

    @Test
    @AppServerContainers(value={@AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9"), @AppServerContainer(value="app-server-undertow", skip=true), @AppServerContainer(value="app-server-wildfly", skip=true), @AppServerContainer(value="app-server-wildfly-deprecated", skip=true), @AppServerContainer(value="app-server-eap", skip=true), @AppServerContainer(value="app-server-eap6", skip=true), @AppServerContainer(value="app-server-eap71", skip=true), @AppServerContainer(value="app-server-jetty92", skip=true), @AppServerContainer(value="app-server-jetty93", skip=true), @AppServerContainer(value="app-server-jetty94", skip=true)})
    public void testClockSkewTomcat() throws Exception {
        this.deployer.deploy("sales-post-clock-skew");
        try {
            this.assertOutcome(-4, Matchers.allOf((Matcher)Matchers.containsString((String)"request-path:"), (Matcher)Matchers.containsString((String)"principal=bburke")));
            this.assertTokenIsNotValid(65);
            this.assertTokenIsNotValid(-65);
        }
        finally {
            this.deployer.undeploy("sales-post-clock-skew");
        }
    }
}

