/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.common.Profile;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.servlet.LinkAndExchangeServlet;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginUpdateProfilePage;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.util.BasicAuthHelper;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
@EnableFeature(value=Profile.Feature.TOKEN_EXCHANGE, skipRestart=true)
public class BrokerLinkAndTokenExchangeTest
extends AbstractServletsAdapterTest {
    public static final String CHILD_IDP = "child";
    public static final String PARENT_IDP = "parent-idp";
    public static final String PARENT_USERNAME = "parent";
    public static final String PARENT2_USERNAME = "parent2";
    public static final String PARENT3_USERNAME = "parent3";
    public static final String UNAUTHORIZED_CHILD_CLIENT = "unauthorized-child-client";
    public static final String PARENT_CLIENT = "parent-client";
    @Page
    protected LoginUpdateProfilePage loginUpdateProfilePage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    private LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    private ClientApp appPage;
    private String childUserId = null;

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Deployment(name="exchange-linking")
    protected static WebArchive accountLink() {
        return BrokerLinkAndTokenExchangeTest.servletDeployment("exchange-linking", LinkAndExchangeServlet.class, ServletTestUtils.class);
    }

    @Override
    public void beforeAuthTest() {
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(CHILD_IDP);
        realm.setEnabled(Boolean.valueOf(true));
        ClientRepresentation servlet = new ClientRepresentation();
        servlet.setClientId("exchange-linking");
        servlet.setProtocol("openid-connect");
        String uri = "/exchange-linking";
        if (!this.isRelative()) {
            uri = this.appServerContextRootPage.toString() + uri;
        }
        servlet.setEnabled(Boolean.valueOf(true));
        servlet.setAdminUrl(uri);
        servlet.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        servlet.setBaseUrl(uri);
        servlet.setRedirectUris(new LinkedList());
        servlet.getRedirectUris().add(uri + "/*");
        servlet.setSecret("password");
        servlet.setFullScopeAllowed(Boolean.valueOf(true));
        realm.setClients(new LinkedList());
        realm.getClients().add(servlet);
        ClientRepresentation unauthorized = new ClientRepresentation();
        unauthorized.setEnabled(Boolean.valueOf(true));
        unauthorized.setClientId(UNAUTHORIZED_CHILD_CLIENT);
        unauthorized.setProtocol("openid-connect");
        unauthorized.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        unauthorized.setSecret("password");
        unauthorized.setFullScopeAllowed(Boolean.valueOf(true));
        realm.getClients().add(unauthorized);
        testRealms.add(realm);
        realm = new RealmRepresentation();
        realm.setRealm(PARENT_IDP);
        realm.setEnabled(Boolean.valueOf(true));
        ClientRepresentation parentApp = new ClientRepresentation();
        parentApp.setEnabled(Boolean.valueOf(true));
        parentApp.setClientId(PARENT_CLIENT);
        parentApp.setProtocol("openid-connect");
        parentApp.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        parentApp.setSecret("password");
        parentApp.setFullScopeAllowed(Boolean.valueOf(true));
        realm.setClients(new LinkedList());
        realm.getClients().add(parentApp);
        testRealms.add(realm);
    }

    @Test
    @DisableFeature(value=Profile.Feature.TOKEN_EXCHANGE, skipRestart=true)
    @UncaughtServerErrorExpected
    public void testFeatureDisabled() throws Exception {
        this.checkFeature(Response.Status.NOT_IMPLEMENTED.getStatusCode());
    }

    @Test
    public void testFeatureEnabled() throws Exception {
        this.checkFeature(Response.Status.OK.getStatusCode());
    }

    @Before
    public void beforeTest() throws Exception {
        this.addIdpUser();
        this.addChildUser();
        this.createBroker();
    }

    public void addIdpUser() {
        RealmResource realm = this.adminClient.realms().realm(PARENT_IDP);
        UserRepresentation user = new UserRepresentation();
        user.setUsername(PARENT_USERNAME);
        user.setEnabled(Boolean.valueOf(true));
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realm, (UserRepresentation)user, (String)"password");
        user = new UserRepresentation();
        user.setUsername(PARENT2_USERNAME);
        user.setEnabled(Boolean.valueOf(true));
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realm, (UserRepresentation)user, (String)"password");
        user = new UserRepresentation();
        user.setUsername(PARENT3_USERNAME);
        user.setFirstName("first name");
        user.setLastName("last name");
        user.setEmail("email");
        user.setEnabled(Boolean.valueOf(true));
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realm, (UserRepresentation)user, (String)"password");
    }

    public void addChildUser() {
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        UserRepresentation user = new UserRepresentation();
        user.setUsername(CHILD_IDP);
        user.setEnabled(Boolean.valueOf(true));
        this.childUserId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realm, (UserRepresentation)user, (String)"password");
        UserRepresentation user2 = new UserRepresentation();
        user2.setUsername("child2");
        user2.setEnabled(Boolean.valueOf(true));
        String user2Id = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realm, (UserRepresentation)user2, (String)"password");
        realm.roles().create(new RoleRepresentation("user", null, false));
        RoleRepresentation role = realm.roles().get("user").toRepresentation();
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        roles.add(role);
        realm.users().get(this.childUserId).roles().realmLevel().add(roles);
        realm.users().get(user2Id).roles().realmLevel().add(roles);
        ClientRepresentation brokerService = (ClientRepresentation)realm.clients().findByClientId("broker").get(0);
        role = realm.clients().get(brokerService.getId()).roles().get("read-token").toRepresentation();
        roles.clear();
        roles.add(role);
        realm.users().get(this.childUserId).roles().clientLevel(brokerService.getId()).add(roles);
        realm.users().get(user2Id).roles().clientLevel(brokerService.getId()).add(roles);
    }

    public static void setupRealm(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(CHILD_IDP);
        ClientModel client = realm.getClientByClientId("exchange-linking");
        IdentityProviderModel idp = realm.getIdentityProviderByAlias(PARENT_IDP);
        Assert.assertNotNull((Object)idp);
        ClientModel directExchanger = realm.addClient("direct-exchanger");
        directExchanger.setClientId("direct-exchanger");
        directExchanger.setPublicClient(false);
        directExchanger.setDirectAccessGrantsEnabled(true);
        directExchanger.setEnabled(true);
        directExchanger.setSecret("secret");
        directExchanger.setProtocol("openid-connect");
        directExchanger.setFullScopeAllowed(false);
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        management.idps().setPermissionsEnabled(idp, true);
        ClientPolicyRepresentation clientRep = new ClientPolicyRepresentation();
        clientRep.setName("toIdp");
        clientRep.addClient(new String[]{client.getId()});
        clientRep.addClient(new String[]{directExchanger.getId()});
        ResourceServer server = management.realmResourceServer();
        Policy clientPolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientRep, server);
        management.idps().exchangeToPermission(idp).addAssociatedPolicy(clientPolicy);
        ClientPolicyRepresentation clientImpersonateRep = new ClientPolicyRepresentation();
        clientImpersonateRep.setName("clientImpersonators");
        clientImpersonateRep.addClient(new String[]{directExchanger.getId()});
        server = management.realmResourceServer();
        Policy clientImpersonatePolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientImpersonateRep, server);
        management.users().setPermissionsEnabled(true);
        management.users().adminImpersonatingPermission().addAssociatedPolicy(clientImpersonatePolicy);
        management.users().adminImpersonatingPermission().setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
    }

    public static void turnOffTokenStore(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(CHILD_IDP);
        IdentityProviderModel idp = realm.getIdentityProviderByAlias(PARENT_IDP);
        idp.setStoreToken(false);
        realm.updateIdentityProvider(idp);
    }

    public static void turnOnTokenStore(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(CHILD_IDP);
        IdentityProviderModel idp = realm.getIdentityProviderByAlias(PARENT_IDP);
        idp.setStoreToken(true);
        realm.updateIdentityProvider(idp);
    }

    public void createBroker() {
        this.createParentChild();
        this.testingClient.server().run(BrokerLinkAndTokenExchangeTest::setupRealm);
    }

    public void createParentChild() {
        BrokerTestTools.createKcOidcBroker(this.adminClient, CHILD_IDP, PARENT_IDP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @UncaughtServerErrorExpected
    public void testAccountLink() throws Exception {
        this.testingClient.server().run(BrokerLinkAndTokenExchangeTest::turnOnTokenStore);
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        List links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        String servletUri = this.appPage.getInjectedUrl().toString();
        UriBuilder linkBuilder = UriBuilder.fromUri((String)servletUri).path("link");
        String linkUrl = linkBuilder.clone().queryParam("realm", new Object[]{CHILD_IDP}).queryParam("provider", new Object[]{PARENT_IDP}).build(new Object[0]).toString();
        System.out.println("linkUrl: " + linkUrl);
        this.navigateTo(linkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(PARENT_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent(PARENT_IDP));
        this.loginPage.login(PARENT_USERNAME, "password");
        System.out.println("After linking: " + this.driver.getCurrentUrl());
        System.out.println(this.driver.getPageSource());
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(linkBuilder.toTemplate()));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Account Linked"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Exchange token received"));
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertFalse((boolean)links.isEmpty());
        String accessToken = this.oauth.doGrantAccessTokenRequest(CHILD_IDP, CHILD_IDP, "password", null, "exchange-linking", "password").getAccessToken();
        try (ResteasyClient httpClient = AdminClientUtil.createResteasyClient();){
            WebTarget exchangeUrl = this.childTokenExchangeWebTarget((Client)httpClient);
            System.out.println("Exchange url: " + exchangeUrl.getUri().toString());
            Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"exchange-linking", (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_issuer", PARENT_IDP)));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            response.close();
            String externalToken = tokenResponse.getToken();
            Assert.assertNotNull((Object)externalToken);
            Assert.assertTrue((tokenResponse.getExpiresIn() > 0L ? 1 : 0) != 0);
            this.setTimeOffset((int)tokenResponse.getExpiresIn() + 1);
            accessToken = this.oauth.doGrantAccessTokenRequest(CHILD_IDP, CHILD_IDP, "password", null, "exchange-linking", "password").getAccessToken();
            response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"exchange-linking", (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_issuer", PARENT_IDP)));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            response.close();
            Assert.assertNotEquals((Object)externalToken, (Object)tokenResponse.getToken());
            response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-exchanger", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_subject", CHILD_IDP).param("requested_issuer", PARENT_IDP)));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            response.close();
            Assert.assertNotEquals((Object)externalToken, (Object)tokenResponse.getToken());
            this.logoutAll();
            realm.users().get(this.childUserId).removeFederatedIdentity(PARENT_IDP);
            links = realm.users().get(this.childUserId).getFederatedIdentity();
            Assert.assertTrue((boolean)links.isEmpty());
        }
    }

    protected WebTarget childTokenExchangeWebTarget(Client httpClient) {
        return httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path(CHILD_IDP).path("protocol/openid-connect/token");
    }

    protected WebTarget childLogoutWebTarget(Client httpClient) {
        return httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path(CHILD_IDP).path("protocol/openid-connect/logout");
    }

    protected String parentJwksUrl() {
        return UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT).path("/realms").path(PARENT_IDP).path("protocol/openid-connect").path(OIDCLoginProtocolService.class, "certs").build(new Object[0]).toString();
    }

    @Test
    @UncaughtServerErrorExpected
    public void testAccountLinkNoTokenStore() throws Exception {
        this.testingClient.server().run(BrokerLinkAndTokenExchangeTest::turnOffTokenStore);
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        List links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        UriBuilder linkBuilder = UriBuilder.fromUri((String)this.appPage.getInjectedUrl().toString()).path("link");
        String linkUrl = linkBuilder.clone().queryParam("realm", new Object[]{CHILD_IDP}).queryParam("provider", new Object[]{PARENT_IDP}).build(new Object[0]).toString();
        System.out.println("linkUrl: " + linkUrl);
        this.navigateTo(linkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(PARENT_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent(PARENT_IDP));
        this.loginPage.login(PARENT_USERNAME, "password");
        System.out.println("After linking: " + this.driver.getCurrentUrl());
        System.out.println(this.driver.getPageSource());
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(linkBuilder.toTemplate()));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Account Linked"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Exchange token received"));
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertFalse((boolean)links.isEmpty());
        this.logoutAll();
        realm.users().get(this.childUserId).removeFederatedIdentity(PARENT_IDP);
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
    }

    @Test
    @UncaughtServerErrorExpected
    public void testExportImport() throws Exception {
        ContainerAssume.assumeNotAuthServerRemote();
        this.testExternalExchange();
        this.testingClient.testing().exportImport().setProvider("singleFile");
        String targetFilePath = this.testingClient.testing().exportImport().getExportImportTestDirectory() + File.separator + "singleFile-full.json";
        this.testingClient.testing().exportImport().setFile(targetFilePath);
        this.testingClient.testing().exportImport().setAction("export");
        this.testingClient.testing().exportImport().setRealmName(CHILD_IDP);
        this.testingClient.testing().exportImport().runExport();
        this.adminClient.realms().realm(CHILD_IDP).remove();
        this.testingClient.testing().exportImport().setAction("import");
        this.testingClient.testing().exportImport().runImport();
        this.testingClient.testing().exportImport().clear();
        this.testExternalExchange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @UncaughtServerErrorExpected
    public void testExternalExchange() throws Exception {
        RealmResource childRealm = this.adminClient.realms().realm(CHILD_IDP);
        String accessToken = this.oauth.doGrantAccessTokenRequest(PARENT_IDP, PARENT2_USERNAME, "password", null, PARENT_CLIENT, "password").getAccessToken();
        Assert.assertEquals((long)0L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
        try (ResteasyClient httpClient = AdminClientUtil.createResteasyClient();){
            WebTarget exchangeUrl = this.childTokenExchangeWebTarget((Client)httpClient);
            System.out.println("Exchange url: " + exchangeUrl.getUri().toString());
            this.checkFeature(200);
            IdentityProviderRepresentation rep = this.adminClient.realm(CHILD_IDP).identityProviders().get(PARENT_IDP).toRepresentation();
            rep.getConfig().put("validateSignature", String.valueOf(true));
            rep.getConfig().put("useJwksUrl", String.valueOf(true));
            rep.getConfig().put("jwksUrl", this.parentJwksUrl());
            String parentIssuer = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT).path("/realms").path(PARENT_IDP).build(new Object[0]).toString();
            rep.getConfig().put("issuer", parentIssuer);
            this.adminClient.realm(CHILD_IDP).identityProviders().get(PARENT_IDP).update(rep);
            String exchangedUserId = null;
            String exchangedUsername = null;
            Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"exchange-linking", (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:jwt").param("subject_issuer", PARENT_IDP).param("scope", "openid")));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            String idToken = tokenResponse.getIdToken();
            JWSInput jws = new JWSInput(tokenResponse.getToken());
            AccessToken token = (AccessToken)jws.readJsonContent(AccessToken.class);
            response.close();
            exchangedUserId = token.getSubject();
            exchangedUsername = token.getPreferredUsername();
            System.out.println("exchangedUserId: " + exchangedUserId);
            System.out.println("exchangedUsername: " + exchangedUsername);
            response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"exchange-linking", (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", tokenResponse.getToken()).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_issuer", PARENT_IDP)));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            Assert.assertEquals((Object)accessToken, (Object)tokenResponse.getToken());
            response.close();
            Assert.assertEquals((long)1L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
            response = this.childLogoutWebTarget((Client)httpClient).queryParam("id_token_hint", new Object[]{idToken}).request().get();
            response.close();
            Assert.assertEquals((long)0L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
            List links = childRealm.users().get(exchangedUserId).getFederatedIdentity();
            Assert.assertEquals((long)1L, (long)links.size());
            response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"exchange-linking", (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:jwt").param("subject_issuer", PARENT_IDP).param("scope", "openid")));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            idToken = tokenResponse.getIdToken();
            jws = new JWSInput(tokenResponse.getToken());
            token = (AccessToken)jws.readJsonContent(AccessToken.class);
            response.close();
            String exchanged2UserId = token.getSubject();
            String exchanged2Username = token.getPreferredUsername();
            Assert.assertEquals((Object)exchangedUserId, (Object)exchanged2UserId);
            Assert.assertEquals((Object)exchangedUsername, (Object)exchanged2Username);
            response = this.childLogoutWebTarget((Client)httpClient).queryParam("id_token_hint", new Object[]{idToken}).request().get();
            response.close();
            Assert.assertEquals((long)0L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
            List links2 = childRealm.users().get(exchangedUserId).getFederatedIdentity();
            Assert.assertEquals((long)1L, (long)links2.size());
            response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"exchange-linking", (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:jwt").param("scope", "openid")));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            idToken = tokenResponse.getIdToken();
            jws = new JWSInput(tokenResponse.getToken());
            token = (AccessToken)jws.readJsonContent(AccessToken.class);
            response.close();
            exchanged2UserId = token.getSubject();
            exchanged2Username = token.getPreferredUsername();
            Assert.assertEquals((Object)exchangedUserId, (Object)exchanged2UserId);
            Assert.assertEquals((Object)exchangedUsername, (Object)exchanged2Username);
            response = this.childLogoutWebTarget((Client)httpClient).queryParam("id_token_hint", new Object[]{idToken}).request().get();
            response.close();
            Assert.assertEquals((long)0L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
            links2 = childRealm.users().get(exchangedUserId).getFederatedIdentity();
            Assert.assertEquals((long)1L, (long)links2.size());
            childRealm.users().get(exchangedUserId).remove();
            response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)UNAUTHORIZED_CHILD_CLIENT, (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:jwt").param("subject_issuer", PARENT_IDP)));
            Assert.assertEquals((long)403L, (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalExchange_extractIdentityFromProfile() throws Exception {
        RealmResource childRealm = this.adminClient.realms().realm(CHILD_IDP);
        String accessToken = this.oauth.doGrantAccessTokenRequest(PARENT_IDP, PARENT3_USERNAME, "password", null, PARENT_CLIENT, "password").getAccessToken();
        Assert.assertEquals((long)0L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
        try (ResteasyClient httpClient = AdminClientUtil.createResteasyClient();){
            AccessToken token;
            WebTarget exchangeUrl = this.childTokenExchangeWebTarget((Client)httpClient);
            IdentityProviderRepresentation rep = this.adminClient.realm(CHILD_IDP).identityProviders().get(PARENT_IDP).toRepresentation();
            rep.getConfig().put("validateSignature", String.valueOf(false));
            this.adminClient.realm(CHILD_IDP).identityProviders().get(PARENT_IDP).update(rep);
            try (Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"exchange-linking", (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:jwt").param("subject_issuer", PARENT_IDP).param("scope", "openid")));){
                Assert.assertEquals((long)200L, (long)response.getStatus());
                AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
                JWSInput jws = new JWSInput(tokenResponse.getToken());
                token = (AccessToken)jws.readJsonContent(AccessToken.class);
            }
            Assert.assertNotNull((Object)token);
            Assert.assertNotNull((Object)token.getSubject());
            Assert.assertEquals((Object)PARENT3_USERNAME, (Object)token.getPreferredUsername());
            Assert.assertEquals((Object)"first name", (Object)token.getGivenName());
            Assert.assertEquals((Object)"last name", (Object)token.getFamilyName());
            Assert.assertEquals((Object)"email", (Object)token.getEmail());
            childRealm.users().get(token.getSubject()).remove();
        }
    }

    public void logoutAll() {
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).build(new Object[]{CHILD_IDP}).toString();
        this.navigateTo(logoutUri);
        logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).build(new Object[]{PARENT_IDP}).toString();
        this.navigateTo(logoutUri);
    }

    private void navigateTo(String uri) {
        this.driver.navigate().to(uri);
        WaitUtils.waitForPageToLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFeature(int statusCode) throws Exception {
        String accessToken = this.oauth.doGrantAccessTokenRequest(PARENT_IDP, PARENT2_USERNAME, "password", null, PARENT_CLIENT, "password").getAccessToken();
        if (statusCode != Response.Status.NOT_IMPLEMENTED.getStatusCode()) {
            Assert.assertEquals((long)0L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
        }
        try (ResteasyClient httpClient = AdminClientUtil.createResteasyClient();){
            WebTarget exchangeUrl = this.childTokenExchangeWebTarget((Client)httpClient);
            IdentityProviderRepresentation rep = this.adminClient.realm(CHILD_IDP).identityProviders().get(PARENT_IDP).toRepresentation();
            rep.getConfig().put("validateSignature", String.valueOf(false));
            this.adminClient.realm(CHILD_IDP).identityProviders().get(PARENT_IDP).update(rep);
            Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"exchange-linking", (String)"password")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:jwt").param("subject_issuer", PARENT_IDP).param("scope", "openid")));
            Assert.assertEquals((long)statusCode, (long)response.getStatus());
            if (statusCode != Response.Status.NOT_IMPLEMENTED.getStatusCode()) {
                AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
                String idToken = tokenResponse.getIdToken();
                Assert.assertNotNull((Object)idToken);
                response.close();
                Assert.assertEquals((long)1L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
                response = this.childLogoutWebTarget((Client)httpClient).queryParam("id_token_hint", new Object[]{idToken}).request().get();
                response.close();
                Assert.assertEquals((long)0L, (long)this.adminClient.realm(CHILD_IDP).getClientSessionStats().size());
            }
        }
    }

    public static class ClientApp
    extends AbstractPageWithInjectedUrl {
        public static final String DEPLOYMENT_NAME = "exchange-linking";
        @ArquillianResource
        @OperateOnDeployment(value="exchange-linking")
        private URL url;

        public URL getInjectedUrl() {
            return this.url;
        }
    }
}

