/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.auth.page.login.Login;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.io.IOUtil;

public abstract class AbstractSAMLServletAdapterTest
extends AbstractServletsAdapterTest {
    public static final String WEB_XML_WITH_ACTION_FILTER = "web-with-action-filter.xml";

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("demo");
        this.testRealmSAMLRedirectLoginPage.setAuthRealm("demo");
        this.testRealmSAMLPostLoginPage.setAuthRealm("demo");
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/testsaml.json"));
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/tenant1-realm.json"));
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/tenant2-realm.json"));
    }

    @Override
    protected void setAdapterAndServerTimeOffset(int timeOffset, String ... servletUris) {
        this.setTimeOffset(timeOffset);
        Arrays.stream(servletUris).map(url -> {
            url = url + "unsecured";
            return url;
        }).forEach(servletUri -> {
            String url = UriBuilder.fromUri((String)servletUri).queryParam("timeOffset", new Object[]{timeOffset}).build(new Object[0]).toString();
            try (CloseableHttpClient client = HttpClientBuilder.create().build();){
                HttpGet request = new HttpGet(url);
                CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)request);
                System.out.println(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                httpResponse.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot change time on url " + url, e);
            }
        });
    }

    protected SamlClientBuilder beginAuthenticationAndLogin(AbstractPage page, SamlClient.Binding binding) {
        return new SamlClientBuilder().navigateTo(page.buildUri()).processSamlResponse(binding).build().login().user(this.bburkeUser).build();
    }

    protected AutoCloseable createProtocolMapper(ProtocolMappersResource resource, String name, String protocol, String protocolMapper, Map<String, String> config) {
        ProtocolMapperRepresentation representation = new ProtocolMapperRepresentation();
        representation.setName(name);
        representation.setProtocol(protocol);
        representation.setProtocolMapper(protocolMapper);
        representation.setConfig(config);
        try (Response response = resource.createMapper(representation);){
            String createdId = ApiUtil.getCreatedId((Response)response);
            AutoCloseable autoCloseable = () -> resource.delete(createdId);
            return autoCloseable;
        }
    }

    protected void checkLoggedOut(AbstractPage page, Login loginPage) {
        page.navigateTo();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)loginPage);
    }
}

