/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.hal;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractAdapterTest;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppServerWelcomePage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.WebDriver;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

@AppServerContainer(value="app-server-eap71")
public class ConsoleProtectionTest
extends AbstractAdapterTest {
    @Drone
    @JavascriptBrowser
    protected WebDriver jsDriver;
    @Page
    @JavascriptBrowser
    protected AppServerWelcomePage appServerWelcomePage;
    @Page
    @JavascriptBrowser
    protected AccountUpdateProfilePage accountUpdateProfilePage;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/wildfly-integration/wildfly-management-realm.json"));
    }

    @Before
    public void beforeConsoleProtectionTest() throws IOException, OperationException {
        Assume.assumeTrue((String)"This testClass doesn't work with phantomjs", (!"phantomjs".equals(System.getProperty("js.browser")) ? 1 : 0) != 0);
        try (OnlineManagementClient clientWorkerNodeClient = AppServerTestEnricher.getManagementClient();){
            Operations operations = new Operations(clientWorkerNodeClient);
            Assume.assumeTrue((boolean)operations.exists(Address.subsystem((String)"elytron").and("security-domain", "KeycloakDomain")));
            clientWorkerNodeClient.execute("/subsystem=keycloak/realm=jboss-infra:add(auth-server-url=" + ServerURLs.getAuthServerContextRoot() + "/auth,realm-public-key=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB)");
            clientWorkerNodeClient.execute("/subsystem=keycloak/secure-deployment=wildfly-management:add(realm=jboss-infra,resource=wildfly-management,principal-attribute=preferred_username,bearer-only=true,ssl-required=EXTERNAL)");
            clientWorkerNodeClient.execute("/core-service=management/management-interface=http-interface:undefine-attribute(name=security-realm)");
            clientWorkerNodeClient.execute("/subsystem=elytron/http-authentication-factory=keycloak-mgmt-http-authentication:add(security-domain=KeycloakDomain,http-server-mechanism-factory=wildfly-management,mechanism-configurations=[{mechanism-name=KEYCLOAK,mechanism-realm-configurations=[{realm-name=KeycloakOIDCRealm,realm-mapper=keycloak-oidc-realm-mapper}]}])");
            clientWorkerNodeClient.execute("/core-service=management/management-interface=http-interface:write-attribute(name=http-authentication-factory,value=keycloak-mgmt-http-authentication)");
            clientWorkerNodeClient.execute("/core-service=management/management-interface=http-interface:write-attribute(name=http-upgrade, value={enabled=true, sasl-authentication-factory=management-sasl-authentication})");
            clientWorkerNodeClient.execute("/core-service=management/access=authorization:write-attribute(name=provider,value=rbac)");
            clientWorkerNodeClient.execute("/core-service=management/access=authorization:write-attribute(name=use-identity-roles,value=true)");
            clientWorkerNodeClient.execute("/subsystem=keycloak/secure-server=wildfly-console:add(realm=jboss-infra,resource=wildfly-console,public-client=true)");
            this.log.debug((Object)"Reloading the server");
            new Administration(clientWorkerNodeClient).reload();
            this.log.debug((Object)"Reloaded");
        }
        catch (IOException | InterruptedException | TimeoutException | CliException cause) {
            throw new RuntimeException("Failed to configure app server", cause);
        }
        DroneUtils.addWebDriver((WebDriver)this.jsDriver);
        this.log.debug((Object)"Added jsDriver");
    }

    private void testLogin() throws InterruptedException {
        this.appServerWelcomePage.navigateToConsole();
        this.appServerWelcomePage.login("admin", "admin");
        WaitUtils.pause((long)2000L);
        Assert.assertTrue((boolean)this.appServerWelcomePage.isCurrent());
    }

    @Test
    public void testUserCanAccessAccountService() throws InterruptedException {
        this.testLogin();
        this.appServerWelcomePage.navigateToAccessControl();
        this.appServerWelcomePage.navigateManageProfile();
        Assert.assertTrue((boolean)this.accountUpdateProfilePage.isCurrent());
    }
}

