/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.cors;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.AngularCorsProductTestApp;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
@EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class CorsExampleAdapterTest
extends AbstractExampleAdapterTest {
    public static final String CORS = "cors";
    @ArquillianResource
    private Deployer deployer;
    @Drone
    @JavascriptBrowser
    protected WebDriver jsDriver;
    @Page
    @JavascriptBrowser
    protected OIDCLogin jsDriverTestRealmLoginPage;
    @Page
    @JavascriptBrowser
    private AngularCorsProductTestApp jsDriverAngularCorsProductPage;
    @Page
    @JavascriptBrowser
    private Account jsDriverTestRealmAccount;

    @Deployment(name="angular-cors-product", managed=false)
    protected static WebArchive angularCorsProductExample() throws IOException {
        return CorsExampleAdapterTest.exampleDeployment("integration-arquillian-test-apps-cors-angular-product");
    }

    @Deployment(name="cors-database", managed=false)
    protected static WebArchive corsDatabaseServiceExample() throws IOException {
        return CorsExampleAdapterTest.exampleDeployment("integration-arquillian-test-apps-cors-database-service");
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/cors/cors-realm.json")));
    }

    @Before
    public void onBefore() {
        DroneUtils.addWebDriver((WebDriver)this.jsDriver);
        this.deployer.deploy("cors-database");
        this.deployer.deploy("angular-cors-product");
    }

    @After
    public void onAfter() {
        this.deployer.undeploy("cors-database");
        this.deployer.undeploy("angular-cors-product");
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.jsDriverTestRealmLoginPage.setAuthRealm(CORS);
        this.jsDriverTestRealmAccount.setAuthRealm(CORS);
    }

    @Test
    public void angularCorsProductTest() {
        this.jsDriverAngularCorsProductPage.navigateTo();
        this.jsDriverTestRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsDriverAngularCorsProductPage);
        this.jsDriverAngularCorsProductPage.reloadData();
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("iphone");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("ipad");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("ipod");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getHeaders()).text().contains("\"x-custom1\":\"some-value\"");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getHeaders()).text().contains("\"www-authenticate\":\"some-value\"");
        this.jsDriverAngularCorsProductPage.loadRoles();
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("user");
        this.jsDriverAngularCorsProductPage.addRole();
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("stuff");
        this.jsDriverAngularCorsProductPage.deleteRole();
        ((StringMatcher)WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().not()).contains("stuff");
        this.jsDriverAngularCorsProductPage.loadAvailableSocialProviders();
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("twitter");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("google");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("linkedin");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("facebook");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("stackoverflow");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("github");
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("microsoft");
        this.jsDriverAngularCorsProductPage.loadPublicRealmInfo();
        WaitUtils.waitUntilElement((WebElement)this.jsDriverAngularCorsProductPage.getOutput()).text().contains("Realm name: cors");
        String serverVersion = this.getAuthServerVersion();
        TestCase.assertNotNull((Object)serverVersion);
        this.jsDriverAngularCorsProductPage.navigateTo();
        WaitUtils.waitForPageToLoad();
    }

    @Nullable
    private String getAuthServerVersion() {
        DroneUtils.getCurrentDriver().navigate().to(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/admin/master/console/#/server-info");
        this.jsDriverTestRealmLoginPage.form().login("admin", "admin");
        Pattern pattern = Pattern.compile("<td [^>]+>Server Version</td>\\s+<td [^>]+>([^<]+)</td>");
        Matcher matcher = pattern.matcher(DroneUtils.getCurrentDriver().getPageSource());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

