/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.adapter.example.authorization.AbstractServletAuthzAdapterTest;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
public class ServletAuthzCacheDisabledAdapterTest
extends AbstractServletAuthzAdapterTest {
    @Deployment(name="servlet-authz-app", managed=false)
    public static WebArchive deployment() throws IOException {
        return (WebArchive)ServletAuthzCacheDisabledAdapterTest.exampleDeployment("servlet-authz-app").addAsWebInfResource(new File(TEST_APPS_HOME_DIR + "/servlet-authz-app/keycloak-cache-disabled-authz-service.json"), "keycloak.json");
    }

    @Test
    public void testCreateNewResource() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.assertWasNotDenied();
            this.driver.navigate().to(this.getResourceServerUrl() + "/new-resource");
            this.assertWasNotDenied();
            ResourceRepresentation resource = new ResourceRepresentation();
            resource.setName("New Resource");
            resource.setUri("/new-resource");
            this.getAuthorizationResource().resources().create(resource);
            ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
            permission.setName(resource.getName() + " Permission");
            permission.addResource(resource.getName());
            permission.addPolicy(new String[]{"Deny Policy"});
            permission = (ResourcePermissionRepresentation)this.getAuthorizationResource().permissions().resource().create(permission).readEntity(ResourcePermissionRepresentation.class);
            this.login("alice", "alice");
            this.assertWasNotDenied();
            this.driver.navigate().to(this.getResourceServerUrl() + "/new-resource");
            this.assertWasDenied();
            permission = this.getAuthorizationResource().permissions().resource().findById(permission.getId()).toRepresentation();
            permission.removePolicy("Deny Policy");
            permission.addPolicy(new String[]{"Any User Policy"});
            this.getAuthorizationResource().permissions().resource().findById(permission.getId()).update(permission);
            this.login("alice", "alice");
            this.assertWasNotDenied();
            this.driver.navigate().to(this.getResourceServerUrl() + "/new-resource");
            this.assertWasNotDenied();
        });
    }
}

