/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.testsuite.adapter.example.authorization.AbstractServletAuthzAdapterTest;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.OAuthClient;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7")})
public class ServletAuthzCIPAdapterTest
extends AbstractServletAuthzAdapterTest {
    @Deployment(name="servlet-authz-app", managed=false)
    public static WebArchive deployment() throws IOException {
        return (WebArchive)ServletAuthzCIPAdapterTest.exampleDeployment("servlet-authz-app").addAsWebInfResource(new File(TEST_APPS_HOME_DIR + "/servlet-authz-app/keycloak-claim-information-point-authz-service.json"), "keycloak.json");
    }

    @Test
    @AppServerContainers(value={@AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
    public void testClaimInformationPoint() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.assertWasNotDenied();
            this.driver.navigate().to(this.getResourceServerUrl() + "/protected/context/context.jsp?request-claim=unexpected-value");
            this.assertWasDenied();
            this.driver.navigate().to(this.getResourceServerUrl() + "/protected/context/context.jsp?request-claim=expected-value");
            this.assertWasNotDenied();
            this.hasText("Access granted: true");
            this.driver.navigate().to(this.getResourceServerUrl() + "/protected/context/context.jsp");
            this.assertWasDenied();
        });
    }

    @Test
    public void testReuseBodyAfterClaimProcessing() {
        this.performTests(() -> {
            OAuthClient.AccessTokenResponse response = this.oauth.realm("servlet-authz").clientId("servlet-authz-app").doGrantAccessTokenRequest("secret", "alice", "alice");
            ResteasyClient client = AdminClientUtil.createResteasyClient();
            Map body = new HashMap<String, String>();
            body.put("test", "test-value");
            Response post = client.target(this.getResourceServerUrl() + "/protected/filter/body").request().header("Authorization", (Object)("Bearer " + response.getAccessToken())).post(Entity.entity(body, (MediaType)MediaType.APPLICATION_JSON_TYPE));
            body = (Map)post.readEntity(Map.class);
            Assert.assertEquals((Object)"test-value", body.get("test"));
        });
    }
}

