/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.utils.io.IOUtil;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
public class DefaultAuthzConfigAdapterTest
extends AbstractExampleAdapterTest {
    private static final String REALM_NAME = "hello-world-authz";
    private static final String RESOURCE_SERVER_ID = "hello-world-authz-service";
    @ArquillianResource
    private Deployer deployer;

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/hello-world-authz-service/hello-world-authz-realm.json")));
    }

    @Deployment(name="hello-world-authz-service", managed=false)
    public static WebArchive deployment() throws IOException {
        return DefaultAuthzConfigAdapterTest.exampleDeployment(RESOURCE_SERVER_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultAuthzConfig() throws Exception {
        try {
            this.configureAuthorizationServices();
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.login();
            Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your permissions are"));
            Assert.assertTrue((boolean)this.driver.getPageSource().contains("Default Resource"));
            boolean hasDefaultPermission = false;
            boolean hasDefaultPolicy = false;
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if ("Default Policy".equals(policy.getName())) {
                    hasDefaultPolicy = true;
                }
                if (!"Default Permission".equals(policy.getName())) continue;
                hasDefaultPermission = true;
            }
            Assert.assertTrue((boolean)hasDefaultPermission);
            Assert.assertTrue((boolean)hasDefaultPolicy);
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    private void login() throws MalformedURLException {
        this.driver.navigate().to(this.getResourceServerUrl() + "/");
        this.loginPage.form().login("alice", "alice");
    }

    private URL getResourceServerUrl() throws MalformedURLException {
        return new URL(ServerURLs.getAppServerContextRoot() + "/" + RESOURCE_SERVER_ID);
    }

    private void configureAuthorizationServices() {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation client = (ClientRepresentation)clients.findByClientId(RESOURCE_SERVER_ID).get(0);
        client.setAuthorizationServicesEnabled(Boolean.valueOf(false));
        clients.get(client.getId()).update(client);
        client.setAuthorizationServicesEnabled(Boolean.valueOf(true));
        clients.get(client.getId()).update(client);
    }

    private AuthorizationResource getAuthorizationResource() throws FileNotFoundException {
        return this.getClientResource(RESOURCE_SERVER_ID).authorization();
    }

    private ClientResource getClientResource(String clientId) {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation resourceServer = (ClientRepresentation)clients.findByClientId(clientId).get(0);
        return clients.get(resourceServer.getId());
    }
}

